/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshKeyExchangeLegacy;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.Curve25519;
import com.sshtools.common.ssh.components.jce.JCEComponentManager;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.components.SshKeyExchangeServer;
import com.sshtools.server.components.SshKeyExchangeServerFactory;
import com.sshtools.synergy.ssh.SshTransport;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

public class Curve25519SHA256LibSshServer
extends SshKeyExchangeServer
implements SshKeyExchangeLegacy {
    public static final int SSH_MSG_KEX_ECDH_INIT = 30;
    public static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    public static final String CURVE25519_SHA2_AT_LIBSSH_ORG = "curve25519-sha256@libssh.org";
    public final String name;
    byte[] f;
    byte[] privateKey;
    byte[] e;
    String clientId;
    String serverId;
    byte[] clientKexInit;
    byte[] serverKexInit;

    public Curve25519SHA256LibSshServer() {
        this(CURVE25519_SHA2_AT_LIBSSH_ORG);
    }

    protected Curve25519SHA256LibSshServer(String name) {
        super("SHA-256", SecurityLevel.PARANOID, 5000);
        this.name = name;
    }

    @Override
    public String getAlgorithm() {
        return this.name;
    }

    public String getProvider() {
        return "";
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putInt(this.e.length);
        hash.putBytes(this.e);
        hash.putInt(this.f.length);
        hash.putBytes(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public void init(SshTransport<SshServerContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        try {
            this.transport = transport;
            this.clientId = clientId;
            this.serverId = serverId;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            this.hostKey = pubkey.getEncoded();
            this.prvkey = prvkey;
            this.pubkey = pubkey;
            this.firstPacketFollows = firstPacketFollows;
            this.useFirstPacket = useFirstPacket;
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
    }

    private void initCrypto() throws InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SshException {
        this.f = new byte[32];
        this.privateKey = new byte[32];
        JCEComponentManager.getSecureRandom().nextBytes(this.privateKey);
        Curve25519.keygen((byte[])this.f, null, (byte[])this.privateKey);
    }

    public void test() {
        try {
            this.initCrypto();
        }
        catch (Throwable e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    @Override
    public boolean processMessage(byte[] msg) throws SshException, IOException {
        if (msg[0] != 30) {
            return false;
        }
        if (this.firstPacketFollows && !this.useFirstPacket) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Client attempted to guess the kex in use but we determined it was wrong so we're waiting for another SSH_MSG_KEX_ECDH_INIT", (Object[])new Object[0]);
            }
            this.firstPacketFollows = false;
            return true;
        }
        try (ByteArrayReader reply = new ByteArrayReader(msg, 1, msg.length - 1);){
            this.initCrypto();
            this.e = reply.readBinaryString();
            byte[] k = new byte[32];
            Curve25519.curve((byte[])k, (byte[])this.privateKey, (byte[])this.e);
            this.secret = new BigInteger(1, k);
        }
        this.calculateExchangeHash();
        int count = 0;
        while (true) {
            this.signature = this.prvkey.sign(this.exchangeHash, this.pubkey.getSigningAlgorithm());
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Verifying signature output to mitigate passive SSH key compromise vulnerability", (Object[])new Object[0]);
            }
            if (this.pubkey.verifySignature(this.signature, this.exchangeHash)) break;
            if (count++ >= 3) {
                throw new SshException(61440, "Detected invalid signautre from private key!");
            }
            if (!Log.isDebugEnabled()) continue;
            Log.debug((String)"Detected invalid signature output from {} implementation", (Object[])new Object[]{this.pubkey.getSigningAlgorithm()});
        }
        this.transport.postMessage(new SshMessage(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                ByteArrayWriter baw = new ByteArrayWriter();
                try {
                    buf.put((byte)31);
                    buf.putInt(Curve25519SHA256LibSshServer.this.hostKey.length);
                    buf.put(Curve25519SHA256LibSshServer.this.hostKey);
                    byte[] tmp = Curve25519SHA256LibSshServer.this.f;
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                    baw.writeString(Curve25519SHA256LibSshServer.this.pubkey.getSigningAlgorithm());
                    baw.writeBinaryString(Curve25519SHA256LibSshServer.this.signature);
                    tmp = baw.toByteArray();
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                }
                catch (IOException ex) {
                    Curve25519SHA256LibSshServer.this.transport.disconnect(3, "Could not read host key");
                }
                finally {
                    try {
                        baw.close();
                    }
                    catch (IOException iOException) {}
                }
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_KEX_ECDH_REPLY", (Object[])new Object[0]);
                }
            }
        }, true);
        this.transport.sendNewKeys();
        return true;
    }

    public static class Curve25519SHA256LibSshServerFactory
    implements SshKeyExchangeServerFactory<Curve25519SHA256LibSshServer> {
        public Curve25519SHA256LibSshServer create() throws NoSuchAlgorithmException, IOException {
            return new Curve25519SHA256LibSshServer();
        }

        public String[] getKeys() {
            return new String[]{Curve25519SHA256LibSshServer.CURVE25519_SHA2_AT_LIBSSH_ORG};
        }
    }
}

