/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.components.jce;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.ssh.components.ComponentManager;
import com.sshtools.common.ssh.components.Digest;
import com.sshtools.common.ssh.components.SshPrivateKey;
import com.sshtools.common.ssh.components.SshPublicKey;
import com.sshtools.common.ssh.components.jce.ECUtils;
import com.sshtools.common.ssh.components.jce.JCEProvider;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.components.SshKeyExchangeServer;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import javax.crypto.KeyAgreement;

public abstract class DiffieHellmanEcdh
extends SshKeyExchangeServer
implements SshKeyExchange<SshServerContext> {
    public static final int SSH_MSG_KEX_ECDH_INIT = 30;
    public static final int SSH_MSG_KEX_ECDH_REPLY = 31;
    String name;
    String curve;
    byte[] Q_S;
    byte[] Q_C;
    String clientId;
    String serverId;
    byte[] clientKexInit;
    byte[] serverKexInit;
    KeyPairGenerator keyGen;
    KeyAgreement keyAgreement;
    KeyPair keyPair;

    protected DiffieHellmanEcdh(String name, String curve, String hashAlgorithm, SecurityLevel securityLevel, int priority) {
        super(hashAlgorithm, securityLevel, priority);
        this.name = name;
        this.curve = curve;
    }

    @Override
    public String getAlgorithm() {
        return this.name;
    }

    protected void calculateExchangeHash() throws SshException {
        Digest hash = (Digest)ComponentManager.getDefaultInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putInt(this.Q_C.length);
        hash.putBytes(this.Q_C);
        hash.putInt(this.Q_S.length);
        hash.putBytes(this.Q_S);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }

    public void init(SshTransport<SshServerContext> transport, String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvkey, SshPublicKey pubkey, boolean firstPacketFollows, boolean useFirstPacket) throws IOException {
        try {
            this.transport = transport;
            this.clientId = clientId;
            this.serverId = serverId;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            this.hostKey = pubkey.getEncoded();
            this.prvkey = prvkey;
            this.pubkey = pubkey;
            this.firstPacketFollows = firstPacketFollows;
            this.useFirstPacket = useFirstPacket;
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
    }

    @Override
    public boolean processMessage(byte[] msg) throws SshException, IOException {
        if (msg[0] != 30) {
            return false;
        }
        if (this.firstPacketFollows && !this.useFirstPacket) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Client attempted to guess the kex in use but we determined it was wrong so we're waiting for another SSH_MSG_KEX_ECDH_INIT", (Object[])new Object[0]);
            }
            this.firstPacketFollows = false;
            return true;
        }
        try (ByteArrayReader reply = new ByteArrayReader(msg, 1, msg.length - 1);){
            this.initCrypto();
            this.Q_C = reply.readBinaryString();
            ECPublicKey ec = (ECPublicKey)this.keyPair.getPublic();
            this.Q_S = ECUtils.toByteArray((ECPoint)ec.getW(), (EllipticCurve)ec.getParams().getCurve());
            this.keyAgreement.doPhase(ECUtils.decodeKey((byte[])this.Q_C, (String)this.curve), true);
            byte[] tmp = this.keyAgreement.generateSecret();
            if ((tmp[0] & 0x80) == 128) {
                byte[] tmp2 = new byte[tmp.length + 1];
                System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
                tmp = tmp2;
            }
            this.secret = new BigInteger(tmp);
        }
        this.calculateExchangeHash();
        int count = 0;
        while (true) {
            this.signature = this.prvkey.sign(this.exchangeHash, this.pubkey.getSigningAlgorithm());
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Verifying signature output to mitigate passive SSH key compromise vulnerability", (Object[])new Object[0]);
            }
            if (this.pubkey.verifySignature(this.signature, this.exchangeHash)) break;
            if (count++ >= 3) {
                throw new SshException(61440, "Detected invalid signautre from private key!");
            }
            if (!Log.isDebugEnabled()) continue;
            Log.debug((String)"Detected invalid signature output from {} implementation", (Object[])new Object[]{this.pubkey.getSigningAlgorithm()});
        }
        this.transport.postMessage(new SshMessage(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                ByteArrayWriter baw = new ByteArrayWriter();
                try {
                    buf.put((byte)31);
                    buf.putInt(DiffieHellmanEcdh.this.hostKey.length);
                    buf.put(DiffieHellmanEcdh.this.hostKey);
                    byte[] tmp = DiffieHellmanEcdh.this.Q_S;
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                    baw.writeString(DiffieHellmanEcdh.this.pubkey.getAlgorithm());
                    baw.writeBinaryString(DiffieHellmanEcdh.this.signature);
                    tmp = baw.toByteArray();
                    buf.putInt(tmp.length);
                    buf.put(tmp);
                }
                catch (IOException ex) {
                    DiffieHellmanEcdh.this.transport.disconnect(3, "Could not read host key");
                }
                finally {
                    try {
                        baw.close();
                    }
                    catch (IOException iOException) {}
                }
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_KEX_ECDH_REPLY", (Object[])new Object[0]);
                }
            }
        }, true);
        this.transport.sendNewKeys();
        return true;
    }

    public String getProvider() {
        return this.keyGen.getProvider().getName();
    }

    private void initCrypto() throws InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, SshException {
        ComponentManager.getInstance().supportedDigests().getInstance(this.getHashAlgorithm());
        this.keyGen = JCEProvider.getProviderForAlgorithm((String)JCEProvider.getECDSAAlgorithmName()) == null ? KeyPairGenerator.getInstance(JCEProvider.getECDSAAlgorithmName()) : KeyPairGenerator.getInstance(JCEProvider.getECDSAAlgorithmName(), JCEProvider.getProviderForAlgorithm((String)JCEProvider.getECDSAAlgorithmName()));
        this.keyAgreement = JCEProvider.getProviderForAlgorithm((String)"ECDH") == null ? KeyAgreement.getInstance("ECDH") : KeyAgreement.getInstance("ECDH", JCEProvider.getProviderForAlgorithm((String)"ECDH"));
        ECGenParameterSpec namedSpec = new ECGenParameterSpec(this.curve);
        this.keyGen.initialize(namedSpec);
        this.keyPair = this.keyGen.generateKeyPair();
        this.keyAgreement.init(this.keyPair.getPrivate());
    }

    public void test() throws IOException {
        try {
            this.initCrypto();
        }
        catch (SshException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }
}

