/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.events.Event;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.VFSFile;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;

public class VFSFileFactory
implements AbstractFileFactory<VFSFile> {
    private FileSystemOptions opts;
    private FileObject defaultPath;
    private boolean useURI = true;
    private FileSystemManager manager;
    private String defaultDirectory;

    public VFSFileFactory() throws FileNotFoundException {
        this((FileSystemManager)null);
    }

    public VFSFileFactory(String defaultDirectory) throws FileNotFoundException {
        this((FileSystemManager)null, defaultDirectory);
    }

    public VFSFileFactory(FileSystemOptions opts) throws FileNotFoundException {
        this(null, opts, null);
    }

    public VFSFileFactory(FileSystemOptions opts, String defaultDirectory) throws FileNotFoundException {
        this(null, opts, defaultDirectory);
    }

    public VFSFileFactory(FileSystemManager manager) throws FileNotFoundException {
        this(manager, new FileSystemOptions(), null);
    }

    public VFSFileFactory(FileSystemManager manager, String defaultDirectory) throws FileNotFoundException {
        this(manager, new FileSystemOptions(), defaultDirectory);
    }

    public VFSFileFactory(FileSystemManager manager, FileSystemOptions opts) throws FileNotFoundException {
        this(manager, opts, null);
    }

    public VFSFileFactory(FileSystemManager manager, FileSystemOptions opts, String defaultDirectory) throws FileNotFoundException {
        this.opts = opts;
        this.defaultDirectory = defaultDirectory;
        try {
            if (manager == null) {
                manager = VFS.getManager();
            }
        }
        catch (FileSystemException fse) {
            throw new FileNotFoundException("Could not obtain VFS manager.");
        }
        this.manager = manager;
        if (defaultDirectory == null) {
            try {
                this.defaultPath = manager.resolveFile(System.getProperty("maverick.vfsDefaultPath", "."));
            }
            catch (FileSystemException e) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Unable to determine default path", (Throwable)e, (Object[])new Object[0]);
                }
                throw new FileNotFoundException("Unable to determine a default path. Pass a AbstractFileHomeFactory instance into this constructor of VFSFileFactory");
            }
        }
    }

    public FileSystemManager getFileSystemManager() {
        return this.manager;
    }

    public boolean isReturnURIForPath() {
        return this.useURI;
    }

    public void setReturnURIForPath(boolean useURI) {
        this.useURI = useURI;
    }

    public VFSFile getFile(String parent, String path) throws PermissionDeniedException, IOException {
        try {
            FileObject obj = this.manager.resolveFile(parent, this.opts);
            obj = obj.resolveFile(path);
            return new VFSFile(obj, this);
        }
        catch (FileSystemException e) {
            try {
                FileObject alt = this.defaultDirectory == null ? this.manager.resolveFile(this.defaultPath, parent) : this.manager.resolveFile(this.manager.resolveFile(this.defaultDirectory), parent);
                alt = alt.resolveFile(path);
                return new VFSFile(alt, this);
            }
            catch (Exception e1) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Unable to resolve file " + path), (Throwable)e1, (Object[])new Object[0]);
                }
                throw new FileNotFoundException("Path " + path + " was not found");
            }
        }
    }

    public VFSFile getFile(String path) throws PermissionDeniedException, IOException {
        FileObject obj;
        try {
            obj = this.manager.resolveFile(path, this.opts);
        }
        catch (FileSystemException e) {
            try {
                obj = this.defaultDirectory == null ? this.manager.resolveFile(this.defaultPath, path) : this.manager.resolveFile(this.manager.resolveFile(this.defaultDirectory), path);
            }
            catch (Exception e1) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("Unable to resolve file " + path), (Throwable)e1, (Object[])new Object[0]);
                }
                throw new FileNotFoundException("Path " + path + " was not found");
            }
        }
        return new VFSFile(obj, this);
    }

    public Event populateEvent(Event evt) {
        return evt;
    }

    public void setDefaultPath(String path) throws FileNotFoundException {
        try {
            this.defaultPath = this.manager.resolveFile(path, this.opts);
        }
        catch (FileSystemException e) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Unable to set default path", (Throwable)e, (Object[])new Object[0]);
            }
            throw new FileNotFoundException("Unable to determine a default path. Set AbstractFileHomeFactory instance on VFSFileFactory");
        }
    }

    public VFSFile getDefaultPath() throws PermissionDeniedException, IOException {
        return this.getFile("");
    }
}

