/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.files.vfs;

import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.vfs.VirtualFile;
import com.sshtools.common.files.vfs.VirtualMappedFile;
import com.sshtools.common.files.vfs.VirtualMount;
import com.sshtools.common.files.vfs.VirtualMountFile;
import com.sshtools.common.files.vfs.VirtualMountTemplate;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.util.FileUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.StringTokenizer;

public class VirtualFileFactory
implements AbstractFileFactory<VirtualFile> {
    protected boolean cached = true;
    Map<String, VirtualFile> cache = new HashMap<String, VirtualFile>();
    List<VirtualMount> mounts = new ArrayList<VirtualMount>();
    Map<String, VirtualMountFile> mountCache = new HashMap<String, VirtualMountFile>();
    private VirtualMount defaultMount;

    public VirtualFileFactory(VirtualMountTemplate defaultMount, VirtualMountTemplate ... additionalMounts) throws IOException, PermissionDeniedException {
        this.setupMounts(defaultMount, additionalMounts);
    }

    public VirtualMount getMount(String path) throws IOException {
        if ((path = path.replace('\\', '/').trim()).equals("") || path.equals(".") || path.startsWith("./")) {
            return this.defaultMount;
        }
        for (VirtualMount mount : this.mounts) {
            String mountPath = FileUtils.checkEndsWithSlash((String)mount.getMount());
            if (!(path = FileUtils.checkEndsWithSlash((String)path)).startsWith(mountPath)) continue;
            return mount;
        }
        throw new FileNotFoundException("No mount for " + path);
    }

    private void setupMounts(VirtualMountTemplate homeMount, VirtualMountTemplate ... additionalMounts) throws IOException, PermissionDeniedException {
        if (homeMount != null) {
            this.defaultMount = new VirtualMount(homeMount, this, homeMount.getActualFileFactory(), true, false, homeMount.isCreateMountFolder(), homeMount.lastModified());
            if (this.defaultMount.isCreateMountFolder()) {
                this.defaultMount.getActualFileFactory().getFile(this.defaultMount.getRoot()).createFolder();
            }
            this.mounts.add(this.defaultMount);
        }
        for (VirtualMountTemplate m : additionalMounts) {
            VirtualMount vm = this.createMount(m, m.getActualFileFactory(), m.isCreateMountFolder(), m.lastModified());
            if (vm.isCreateMountFolder()) {
                vm.getActualFileFactory().getFile(vm.getRoot()).createFolder();
            }
            this.mounts.add(vm);
        }
        this.sort(this.mounts);
        this.rebuildMountCache();
    }

    private void rebuildMountCache() throws PermissionDeniedException, IOException {
        this.mountCache.clear();
        this.cache.clear();
        for (VirtualMount mount : this.mounts) {
            String mountPath = FileUtils.addTrailingSlash((String)mount.getMount());
            this.mountCache.put(mountPath, new VirtualMountFile(mountPath, mount, this, false));
            for (String parentPath : FileUtils.getParentPaths((String)mountPath)) {
                if (this.mountCache.containsKey(parentPath)) continue;
                this.mountCache.put(parentPath, new VirtualMountFile(this.isRoot(parentPath) ? parentPath : FileUtils.checkEndsWithNoSlash((String)parentPath), this.getMount(parentPath), this, true));
            }
        }
    }

    private void sort(List<VirtualMount> mounts) {
        Collections.sort(mounts, new Comparator<VirtualMount>(){

            @Override
            public int compare(VirtualMount o1, VirtualMount o2) {
                if (o1.isParentOf(o2)) {
                    return 1;
                }
                if (o1.isChildOf(o2)) {
                    return -1;
                }
                return o2.getMount().compareTo(o1.getMount());
            }
        });
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Sorting mounts by path and with child relationship preferred", (Object[])new Object[0]);
            for (VirtualMount m : mounts) {
                Log.debug((String)"Mount {} on {}", (Object[])new Object[]{m.getMount(), m.getRoot()});
            }
        }
    }

    private VirtualMount createMount(VirtualMountTemplate template, AbstractFileFactory<?> actualFileFactory, boolean createMoundFolder, long lastModified) throws IOException, PermissionDeniedException {
        return new VirtualMount(template, this, actualFileFactory, createMoundFolder, lastModified);
    }

    public VirtualMount[] getMounts(String path) {
        if (path.equals("")) {
            return new VirtualMount[]{this.defaultMount};
        }
        path = FileUtils.addTrailingSlash((String)path);
        ArrayList<VirtualMount> matched = new ArrayList<VirtualMount>();
        for (VirtualMount m : this.mounts) {
            String mountPath = FileUtils.addTrailingSlash((String)m.getMount());
            if (!path.startsWith(mountPath) && !mountPath.startsWith(path)) continue;
            matched.add(m);
        }
        return matched.toArray(new VirtualMount[0]);
    }

    private boolean isRoot(String path) {
        return path.equals("/");
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCached(boolean cached) {
        this.cached = cached;
    }

    private String canonicalisePath(String path) {
        StringTokenizer t = new StringTokenizer(path, "/", true);
        Stack<String> pathStack = new Stack<String>();
        while (t.hasMoreTokens()) {
            String e = t.nextToken();
            if (e.equals("..")) {
                if (pathStack.size() <= 1) continue;
                pathStack.pop();
                pathStack.pop();
                continue;
            }
            if (pathStack.size() > 0 && pathStack.peek() == "/" && e.equals("/")) continue;
            pathStack.push(e);
        }
        Object ret = "";
        for (String e : pathStack) {
            ret = (String)ret + e;
        }
        if (!((String)ret).startsWith("/")) {
            ret = FileUtils.addTrailingSlash((String)this.defaultMount.getMount()) + (String)ret;
        }
        return ret;
    }

    public Map<String, VirtualFile> resolveChildren(VirtualFile parent) throws PermissionDeniedException, IOException {
        HashMap<String, VirtualFile> files = new HashMap<String, VirtualFile>();
        AbstractFile file = parent.resolveFile();
        if (file.isDirectory()) {
            for (AbstractFile child : file.getChildren()) {
                files.put(child.getName(), new VirtualMappedFile(child, parent.getMount(), this));
            }
        }
        String currentPath = FileUtils.checkEndsWithSlash((String)parent.getAbsolutePath());
        for (VirtualMount m : this.getMounts(currentPath)) {
            String mountPath = FileUtils.checkEndsWithSlash((String)m.getMount());
            if (!mountPath.startsWith(currentPath) || mountPath.equals(currentPath)) continue;
            String childPath = FileUtils.checkEndsWithNoSlash((String)mountPath.substring(currentPath.length()));
            List childPaths = FileUtils.getParentPaths((String)childPath);
            Collections.reverse(childPaths);
            boolean intermediate = false;
            intermediate = !childPaths.isEmpty();
            if (intermediate) {
                childPath = FileUtils.checkEndsWithNoSlash((String)((String)childPaths.get(0)));
            }
            files.put(childPath, new VirtualMountFile(currentPath + childPath, m, this, intermediate));
        }
        return files;
    }

    public VirtualFile getFile(String path) throws PermissionDeniedException, IOException {
        String mountPath;
        VirtualFile mountFile;
        String virtualPath = path.equals("") ? this.defaultMount.getMount() : this.canonicalisePath(path);
        if (!virtualPath.equals("") && this.mountCache.size() > 0 && Objects.nonNull(mountFile = (VirtualFile)this.mountCache.get(mountPath = FileUtils.addTrailingSlash((String)virtualPath)))) {
            return mountFile;
        }
        if (!virtualPath.equals("/")) {
            virtualPath = FileUtils.removeTrailingSlash((String)virtualPath);
        }
        VirtualMount m = this.getMount(virtualPath);
        VirtualFile cached = this.getCachedObject(virtualPath);
        if (Objects.nonNull(cached)) {
            return cached;
        }
        VirtualMappedFile f = new VirtualMappedFile(virtualPath, m, this);
        if (m.isCached()) {
            this.cacheObject(f);
        }
        return f;
    }

    private void cacheObject(VirtualFile f) throws IOException, PermissionDeniedException {
        if (Objects.isNull(this.cache)) {
            this.cache = new HashMap<String, VirtualFile>();
        }
        this.cache.put(f.getAbsolutePath(), f);
    }

    protected VirtualFile getCachedObject(String virtualPath) {
        if (Objects.nonNull(this.cache)) {
            this.cache.get(virtualPath);
        }
        return null;
    }

    public VirtualFile getDefaultPath() throws PermissionDeniedException, IOException {
        return this.getFile("");
    }

    public void mount(VirtualMountTemplate template) throws IOException, PermissionDeniedException {
        this.mount(template, false);
    }

    public void mount(VirtualMountTemplate template, boolean unmount) throws IOException, PermissionDeniedException {
        this.mount(this.createMount(template, template.getActualFileFactory(), template.isCreateMountFolder(), template.lastModified()), unmount);
    }

    private void mount(VirtualMount mount, boolean unmount) throws IOException, PermissionDeniedException {
        if (unmount && this.isMounted(mount.getMount())) {
            this.unmount(mount);
        }
        if (this.isMounted(mount.getMount())) {
            throw new IOException(mount.getMount() + " already mounted on " + this.getMount(mount.getMount()).getRoot());
        }
        Log.info((String)("Mounting " + mount.getMount() + " on " + mount.getRoot()), (Object[])new Object[0]);
        this.mounts.add(mount);
        this.sort(this.mounts);
        this.rebuildMountCache();
        Log.info((String)("Mounted " + mount.getMount() + " on " + mount.getRoot()), (Object[])new Object[0]);
    }

    public void unmount(VirtualMount mount) throws IOException, PermissionDeniedException {
        Log.info((String)("Unmounting " + mount.getMount() + " from " + mount.getRoot()), (Object[])new Object[0]);
        VirtualMount mounted = null;
        for (VirtualMount m : this.mounts) {
            if (!FileUtils.checkEndsWithSlash((String)m.getMount()).equals(FileUtils.checkEndsWithSlash((String)mount.getMount()))) continue;
            mounted = m;
        }
        if (Objects.isNull(mounted)) {
            throw new IOException(String.format("Could not find mount %s", mount.getMount()));
        }
        this.mounts.remove(mounted);
        this.sort(this.mounts);
        this.rebuildMountCache();
    }

    public VirtualMount getDefaultMount() {
        return this.defaultMount;
    }

    public boolean isMounted(String path) {
        if (path.equals("")) {
            return true;
        }
        for (VirtualMount mount : this.mounts) {
            if (!FileUtils.addTrailingSlash((String)mount.getMount()).equals(FileUtils.addTrailingSlash((String)path))) continue;
            return true;
        }
        return false;
    }
}

