/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.server.vsession;

import com.sshtools.common.files.nio.AbstractFileURI;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.policy.ClassLoaderPolicy;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.SessionChannelServer;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.Utils;
import com.sshtools.server.AgentForwardingChannel;
import com.sshtools.server.SessionChannelNG;
import com.sshtools.server.SshServerContext;
import com.sshtools.server.vsession.Command;
import com.sshtools.server.vsession.Environment;
import com.sshtools.server.vsession.MshListener;
import com.sshtools.server.vsession.RootShell;
import com.sshtools.server.vsession.ShellCommand;
import com.sshtools.server.vsession.ShellCommandFactory;
import com.sshtools.server.vsession.UnsupportedCommandException;
import com.sshtools.server.vsession.VirtualConsole;
import com.sshtools.synergy.ssh.ChannelNG;
import com.sshtools.synergy.ssh.Connection;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.ParsedLine;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.ExternalTerminal;

public class VirtualShellNG
extends SessionChannelNG {
    String shellCommand = null;
    Environment env = new Environment();
    Set<String> protectedEnvironmentVars = new HashSet<String>();
    RootShell shell;
    protected VirtualConsole console;
    protected ShellCommandFactory commandFactory;
    boolean rawMode = false;
    List<WindowSizeChangeListener> listeners = new ArrayList<WindowSizeChangeListener>();
    private Terminal terminal;

    public VirtualShellNG(SshConnection con, ShellCommandFactory commandFactory, String shellCommand) {
        this(con, commandFactory);
        this.shellCommand = shellCommand;
    }

    public VirtualShellNG(SshConnection con, ShellCommandFactory commandFactory) {
        super(con);
        this.commandFactory = commandFactory;
        this.addEventListener(new ChannelEventListener(){

            public void onChannelDataIn(Channel channel, ByteBuffer data) {
                byte[] tmp = new byte[data.remaining()];
                data.get(tmp);
                try {
                    if (VirtualShellNG.this.terminal instanceof AbstractPosixTerminal) {
                        ((AbstractPosixTerminal)VirtualShellNG.this.terminal).getPty().getMasterOutput().write(tmp);
                        ((AbstractPosixTerminal)VirtualShellNG.this.terminal).getPty().getMasterOutput().flush();
                    } else {
                        ((ExternalTerminal)VirtualShellNG.this.terminal).processInputBytes(tmp, 0, tmp.length);
                    }
                    VirtualShellNG.this.evaluateWindowSpace();
                }
                catch (Exception e) {
                    Log.error((String)"Failed to send input to terminal.", (Throwable)e, (Object[])new Object[0]);
                    VirtualShellNG.this.close();
                }
            }
        });
    }

    public void addWindowSizeChangeListener(WindowSizeChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeWindowSizeChangeListener(WindowSizeChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void addProtectedEnvironmentVar(String name) {
        this.protectedEnvironmentVars.add(name.toUpperCase());
    }

    protected boolean executeCommand(String cmd) {
        try {
            this.shell = this.commandFactory.createShell(this.con);
            this.console = this.createConsole();
            this.shell.execCommand(this.getInputStream(), this.console, cmd);
            return true;
        }
        catch (Exception e) {
            if (Log.isErrorEnabled()) {
                Log.error((String)("Failed to execute command " + cmd), (Throwable)e, (Object[])new Object[0]);
            }
            return false;
        }
    }

    protected void changeWindowDimensions(int cols, int rows, int width, int height) {
        this.console.getTerminal().setSize(new Size(cols, rows));
        for (WindowSizeChangeListener l : this.listeners) {
            l.newSize(rows, cols);
        }
    }

    public void onSessionOpen() {
        this.shell.start();
    }

    protected boolean startShell() {
        if (Utils.isNotBlank((String)this.shellCommand)) {
            return this.executeCommand(this.shellCommand);
        }
        try {
            this.shell = this.createShell(this.con);
            this.console = this.createConsole();
            this.shell.startShell(null, this.console);
            return true;
        }
        catch (Throwable t) {
            Log.warn((String)"Failed to start shell.", (Throwable)t, (Object[])new Object[0]);
            return false;
        }
    }

    protected RootShell createShell(SshConnection con) throws PermissionDeniedException, IOException {
        return this.commandFactory.createShell(con);
    }

    private VirtualConsole createConsole() throws IOException, PermissionDeniedException {
        Attributes attrs = new Attributes();
        attrs.setInputFlag(Attributes.InputFlag.ICRNL, true);
        this.terminal = TerminalBuilder.builder().system(false).streams(this.getInputStream(), this.getOutputStream()).type(this.env.getOrDefault("TERM", "ansi").toString()).size(new Size(this.env.getOrDefault("COLS", 80).intValue(), this.env.getOrDefault("ROWS", 80).intValue())).encoding(Charset.forName("UTF-8")).attributes(attrs).build();
        HashMap<String, Connection> env = new HashMap<String, Connection>();
        env.put("connection", this.getConnection());
        FileSystem fs = FileSystems.newFileSystem(AbstractFileURI.create((SshConnection)this.getConnection(), (String[])new String[]{""}), env, ((ClassLoaderPolicy)((SshServerContext)this.getContext()).getPolicy(ClassLoaderPolicy.class)).getClassLoader());
        LineReaderBuilder lineReaderBuilder = LineReaderBuilder.builder().terminal(this.terminal).completer((Completer)new VirtualShellCompletor()).variable("history-size", (Object)1000).variable("history-file", (Object)fs.getPath(".history", new String[0]));
        return new VirtualConsole((SessionChannelServer)this, this.env, this.terminal, lineReaderBuilder.build(), this.shell);
    }

    protected boolean requestAgentForwarding(String requestType) {
        try {
            if (!this.getConnection().containsProperty("ssh-agent")) {
                this.connection.openChannel((ChannelNG)new AgentForwardingChannel(requestType, (SessionChannelServer)this));
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected boolean allocatePseudoTerminal(String term, int cols, int rows, int width, int height, byte[] modes) {
        this.env.put("TERM", term);
        this.env.put("COLS", cols);
        this.env.put("ROWS", rows);
        this.env.put("PTYMODES", modes);
        return true;
    }

    public boolean setEnvironmentVariable(String name, String value) {
        if (this.protectedEnvironmentVars.contains(name.toUpperCase())) {
            return false;
        }
        this.env.put(name, value);
        return true;
    }

    protected void onChannelOpenFailure() {
    }

    protected void processSignal(String signal) {
    }

    protected void onLocalEOF() {
    }

    public void enableRawMode() {
        this.console.getTerminal().pause();
        super.enableRawMode();
    }

    public void disableRawMode() {
        this.console.getTerminal().resume();
        super.disableRawMode();
    }

    public static interface WindowSizeChangeListener {
        public void newSize(int var1, int var2);
    }

    class VirtualShellCompletor
    implements Completer,
    MshListener {
        Command currentCommand = null;
        AtomicBoolean inCommand = new AtomicBoolean();

        VirtualShellCompletor() {
            VirtualShellNG.this.shell.addListener(this);
        }

        public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            if (!this.inCommand.get()) {
                this.processShellCompletion(reader, line, candidates);
            } else {
                this.processInCommandCompletion(reader, line, candidates);
            }
        }

        private void processInCommandCompletion(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            List tmp = (List)VirtualShellNG.this.console.getEnvironment().get("_COMPLETIONS");
            if (Objects.nonNull(tmp)) {
                candidates.addAll(tmp);
            }
        }

        private void processShellCompletion(LineReader reader, ParsedLine line, List<Candidate> candidates) {
            switch (line.wordIndex()) {
                case 0: {
                    for (String cmd : VirtualShellNG.this.commandFactory.getSupportedCommands()) {
                        candidates.add(new Candidate(cmd));
                    }
                    break;
                }
                default: {
                    try {
                        ShellCommand cmd = (ShellCommand)VirtualShellNG.this.commandFactory.createCommand((String)line.words().get(0), VirtualShellNG.this.con);
                        cmd.complete(reader, line, candidates);
                        break;
                    }
                    catch (PermissionDeniedException | UnsupportedCommandException | IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException throwable) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public void commandStarted(Command cmd, String[] args, VirtualConsole console) {
            this.inCommand.set(true);
            this.currentCommand = cmd;
        }

        @Override
        public void commandFinished(Command cmd, String[] args, VirtualConsole console) {
            this.inCommand.set(false);
            this.currentCommand = null;
        }
    }
}

