/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.x509;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshX509PublicKey;
import com.sshtools.common.ssh.components.jce.Ssh2EcdsaSha2NistPublicKey;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.ECPublicKey;

public abstract class SshX509EcdsaSha2NistPublicKeyRfc6187
extends Ssh2EcdsaSha2NistPublicKey
implements SshX509PublicKey {
    Certificate[] certs;

    public SshX509EcdsaSha2NistPublicKeyRfc6187(String name, String spec, String curve, String nistpCurve) {
        super(name, spec, curve, nistpCurve);
    }

    public SshX509EcdsaSha2NistPublicKeyRfc6187(ECPublicKey pk, String curve) throws IOException {
        super(pk, curve);
    }

    public SshX509EcdsaSha2NistPublicKeyRfc6187(Certificate[] chain, String curve) throws IOException {
        super((ECPublicKey)chain[0].getPublicKey(), curve);
        this.certs = chain;
    }

    public void init(byte[] blob, int start, int len) throws SshException {
        try (ByteArrayReader reader = new ByteArrayReader(blob, start, len);){
            String alg = reader.readString();
            if (!alg.equals(this.getAlgorithm())) {
                throw new SshException("Public key blob is not a " + this.getAlgorithm() + " formatted key [" + alg + "]", 4);
            }
            int certificateCount = (int)reader.readInt();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Expecting chain of " + certificateCount), (Object[])new Object[0]);
            }
            if (certificateCount <= 0) {
                throw new SshException("There are no certificats present in the public key blob", 17);
            }
            this.certs = new Certificate[certificateCount];
            for (int i = 0; i < certificateCount; ++i) {
                byte[] certBlob = reader.readBinaryString();
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                this.certs[i] = certFactory.generateCertificate(new ByteArrayInputStream(certBlob));
            }
            this.pub = (ECPublicKey)this.certs[0].getPublicKey();
        }
    }

    public Certificate getCertificate() {
        return this.certs[0];
    }

    public Certificate[] getCertificateChain() {
        return this.certs;
    }

    public abstract String getAlgorithm();

    public byte[] getEncoded() throws SshException {
        ByteArrayWriter writer = new ByteArrayWriter();
        try {
            writer.writeString(this.getAlgorithm());
            writer.writeInt(this.certs.length);
            for (Certificate c : this.certs) {
                writer.writeBinaryString(c.getEncoded());
            }
            writer.writeInt(0);
            byte[] byArray = writer.toByteArray();
            return byArray;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new SshException("Failed to encode certificate chain", 5, (Throwable)certificateEncodingException);
        }
        catch (IOException iOException) {
            throw new SshException("Failed to write certificate chain", 5, (Throwable)iOException);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException iOException) {}
        }
    }
}

