/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import net.sf.sshapi.AbstractLifecycleComponent;
import net.sf.sshapi.SshException;

public abstract class AbstractLifecycleComponentWithEvents
extends AbstractLifecycleComponent {
    private boolean open;

    public final boolean isOpen() {
        return this.open;
    }

    public final void open() throws SshException {
        if (this.isOpen()) {
            throw new SshException(SshException.ALREADY_OPEN, "Channel already open.");
        }
        this.onOpen();
        this.open = true;
        this.fireOpened();
    }

    protected final void checkOpen() {
        if (!this.open) {
            throw new IllegalStateException("Not open");
        }
    }

    public final void close() throws SshException {
        if (!this.isOpen()) {
            throw new SshException(SshException.NOT_OPEN, "Channel not open.");
        }
        this.fireClosing();
        this.onClose();
        this.open = false;
        this.fireClosed();
    }

    protected abstract void onOpen() throws SshException;

    protected abstract void onClose() throws SshException;
}

