/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.net.SocketFactory;
import net.sf.sshapi.Capability;
import net.sf.sshapi.DefaultProviderFactory;
import net.sf.sshapi.Logger;
import net.sf.sshapi.SshBannerHandler;
import net.sf.sshapi.SshClient;
import net.sf.sshapi.SshProvider;
import net.sf.sshapi.SshProxyServerDetails;
import net.sf.sshapi.hostkeys.SshHostKeyValidator;
import net.sf.sshapi.util.ConsoleLogger;

public class SshConfiguration {
    public static final String CIPHER_TRIPLEDES_CBC = "3des-cbc";
    public static final String CIPHER_BLOWFISH_CBC = "blowfish-cbc";
    public static final String CIPHER_AES128_CBC = "aes128-cbc";
    public static final String HMAC_SHA1 = "hmac-sha1";
    public static final String HMAC_SHA1_96 = "hmac-sha1-96";
    public static final String HMAC_MD5 = "hmac-md5";
    public static final String HMAC_MD5_96 = "hmac-md5-96";
    public static final String COMPRESSION_NONE = "none";
    public static final String COMPRESSION_ZLIB = "zlib";
    public static final String KEX_DIFFIE_HELLMAN_GROUP1_SHA1 = "diffie-hellman-group1-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP14_SHA1 = "diffie-hellman-group14-sha1";
    public static final String KEX_DIFFIE_HELLMAN_GROUP_EXCHANGE_SHA1 = "diffie-hellman-group-exchange-sha1";
    public static final String PUBLIC_KEY_SSHDSA = "ssh-dss";
    public static final String PUBLIC_KEY_SSHRSA = "ssh-rsa";
    public static final String PUBLIC_KEY_SSHRSA1 = "rsa1";
    public static final String CIPHER_DES = "des";
    public static final String CIPHER_3DES = "3des";
    public static final int SSH1_ONLY = 1;
    public static final int SSH2_ONLY = 2;
    public static final int SSH1_OR_SSH2 = 3;
    private static Logger logger = new ConsoleLogger();
    private int protocolVersion = 3;
    private final Properties properties;
    private SshHostKeyValidator hostKeyValidator;
    private String x11Host;
    private int x11Port;
    private byte[] x11Cookie;
    private SshBannerHandler bannerHandler;
    private String preferredServerToClientCipher;
    private String preferredClientToServerCipher;
    private String preferredServerToClientMAC;
    private String preferredClientToServerMAC;
    private String preferredServerToClientCompression;
    private String preferredClientToServerCompression;
    private String preferredKeyExchange;
    private String preferredPublicKey;
    private SshProxyServerDetails proxyServer;
    private String preferredSSH1Cipher;
    private String sftpSSH1Path;
    private List requiredCapabilities = new ArrayList();
    private SocketFactory socketFactory;
    public static final String CFG_KNOWN_HOSTS_REVERSE_DNS = "sshapi.knownHosts.reverseDNS";
    public static final String CFG_KNOWN_HOSTS_PATH = "sshapi.knownHosts.path";

    public SshConfiguration() {
        this(new Properties());
    }

    public static void setLogger(Logger logger) {
        SshConfiguration.logger = logger;
    }

    public static Logger getLogger() {
        return logger;
    }

    public SshConfiguration(SshHostKeyValidator hostKeyValidator) {
        this(new Properties(), hostKeyValidator);
    }

    public SshConfiguration(Properties properties) {
        this(properties, null);
    }

    public SshConfiguration(Properties properties, SshHostKeyValidator hostKeyValidator) {
        this.properties = properties;
        this.hostKeyValidator = hostKeyValidator;
    }

    public void addRequiredCapability(Capability capability) {
        this.requiredCapabilities.add(capability);
    }

    public SshHostKeyValidator getHostKeyValidator() {
        return this.hostKeyValidator;
    }

    public void setHostKeyValidator(SshHostKeyValidator hostKeyValidator) {
        this.hostKeyValidator = hostKeyValidator;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getX11Host() {
        return this.x11Host;
    }

    public void setX11Host(String x11Host) {
        this.x11Host = x11Host;
    }

    public int getX11Port() {
        return this.x11Port;
    }

    public void setX11Port(int x11Port) {
        this.x11Port = x11Port;
    }

    public byte[] getX11Cookie() {
        return this.x11Cookie;
    }

    public void setX11Cookie(byte[] x11Cookie) {
        this.x11Cookie = x11Cookie;
    }

    public SshBannerHandler getBannerHandler() {
        return this.bannerHandler;
    }

    public void setBannerHandler(SshBannerHandler bannerHandler) {
        this.bannerHandler = bannerHandler;
    }

    public String getPreferredServerToClientCipher() {
        return this.preferredServerToClientCipher;
    }

    public void setPreferredServerToClientCipher(String preferredServerToClientCipher) {
        this.preferredServerToClientCipher = preferredServerToClientCipher;
    }

    public String getPreferredClientToServerCipher() {
        return this.preferredClientToServerCipher;
    }

    public void setPreferredClientToServerCipher(String preferredClientToServerCipher) {
        this.preferredClientToServerCipher = preferredClientToServerCipher;
    }

    public String getPreferredServerToClientMAC() {
        return this.preferredServerToClientMAC;
    }

    public void setPreferredServerToClientMAC(String preferredServerToClientMAC) {
        this.preferredServerToClientMAC = preferredServerToClientMAC;
    }

    public String getPreferredClientToServerMAC() {
        return this.preferredClientToServerMAC;
    }

    public void setPreferredClientToServerMAC(String preferredClientToServerMAC) {
        this.preferredClientToServerMAC = preferredClientToServerMAC;
    }

    public String getPreferredServerToClientCompression() {
        return this.preferredServerToClientCompression;
    }

    public void setPreferredServerToClientCompression(String preferredServerToClientCompression) {
        this.preferredServerToClientCompression = preferredServerToClientCompression;
    }

    public String getPreferredClientToServerCompression() {
        return this.preferredClientToServerCompression;
    }

    public void setPreferredClientToServerCompression(String preferredClientToServerCompression) {
        this.preferredClientToServerCompression = preferredClientToServerCompression;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getPreferredKeyExchange() {
        return this.preferredKeyExchange;
    }

    public void setPreferredKeyExchange(String preferredKeyExchange) {
        this.preferredKeyExchange = preferredKeyExchange;
    }

    public String getPreferredPublicKey() {
        return this.preferredPublicKey;
    }

    public void setPreferredPublicKey(String preferredPublicKey) {
        this.preferredPublicKey = preferredPublicKey;
    }

    public SshProxyServerDetails getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(SshProxyServerDetails proxyServer) {
        this.proxyServer = proxyServer;
    }

    public void setPreferredSSH1CipherType(String preferredSSH1Cipher) {
        this.preferredSSH1Cipher = preferredSSH1Cipher;
    }

    public String getPreferredSSH1CipherType() {
        return this.preferredSSH1Cipher;
    }

    public void setSftpSSH1Path(String sftpSSH1Path) {
        this.sftpSSH1Path = sftpSSH1Path;
    }

    public String getSftpSSH1Path() {
        return this.sftpSSH1Path;
    }

    public void providerHasCapabilities(SshProvider provider) throws UnsupportedOperationException {
        Iterator i = this.requiredCapabilities.iterator();
        while (i.hasNext()) {
            Capability c = (Capability)i.next();
            if (provider.getCapabilities().contains(c)) continue;
            throw new UnsupportedOperationException("Capability " + c + " is required, but not supported by this provider.");
        }
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public SshClient createClient() {
        SshProvider provider = DefaultProviderFactory.getInstance().getProvider(this);
        return provider.createClient(this);
    }
}

