/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.forwarding;

import net.sf.sshapi.AbstractLifecycleComponent;
import net.sf.sshapi.SshException;
import net.sf.sshapi.forwarding.SshPortForward;

public abstract class AbstractPortForward
extends AbstractLifecycleComponent
implements SshPortForward {
    private boolean open;
    private int timeout;

    public void close() throws SshException {
        if (!this.open) {
            throw new SshException(SshException.NOT_OPEN, "The port forward is not open");
        }
        this.fireClosing();
        this.onClose();
        this.open = false;
        this.fireClosed();
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isOpen() {
        return this.open;
    }

    public final void open() throws SshException {
        if (this.open) {
            throw new SshException(SshException.ALREADY_OPEN, "The port forward is already open");
        }
        this.onOpen();
        this.open = true;
        this.fireOpened();
    }

    protected abstract void onOpen() throws SshException;

    protected abstract void onClose() throws SshException;
}

