/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.sftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.StringTokenizer;
import net.sf.sshapi.AbstractLifecycleComponentWithEvents;
import net.sf.sshapi.SshException;
import net.sf.sshapi.sftp.SftpClient;
import net.sf.sshapi.sftp.SftpException;

public abstract class AbstractSftpClient
extends AbstractLifecycleComponentWithEvents
implements SftpClient {
    public void mkdirs(String dir, int permissions) throws SshException {
        String path;
        StringTokenizer tokens = new StringTokenizer(dir, "/");
        String string = path = dir.startsWith("/") ? "/" : "";
        while (tokens.hasMoreElements()) {
            path = path + (String)tokens.nextElement();
            try {
                this.stat(path);
            }
            catch (SftpException ex) {
                if (ex.getCode() == SftpException.SSH_FX_NO_SUCH_FILE) {
                    this.mkdir(path, permissions);
                }
                throw ex;
            }
            path = path + "/";
        }
    }

    public void get(String path, OutputStream out, long filePointer) throws SshException {
        if (filePointer > 0L) {
            throw new UnsupportedOperationException("This provider does not support setting of file pointer for downloads.");
        }
        this.get(path, out);
    }

    public InputStream get(String path, long filePointer) throws SshException {
        if (filePointer > 0L) {
            throw new UnsupportedOperationException("This provider does not support setting of file pointer for downloads.");
        }
        return this.get(path);
    }

    public InputStream get(final String path) throws SshException {
        try {
            final PipedOutputStream pout = new PipedOutputStream();
            PipedInputStream pin = new PipedInputStream(pout);
            new Thread(){

                public void run() {
                    try {
                        AbstractSftpClient.this.get(path, pout);
                    }
                    catch (SshException sshException) {
                        // empty catch block
                    }
                }
            }.start();
            return pin;
        }
        catch (IOException e) {
            throw new SshException(SshException.IO_ERROR, (Throwable)e);
        }
    }

    public OutputStream put(final String path, final int permissions) throws SshException {
        final PipedInputStream pin = new PipedInputStream();
        try {
            PipedOutputStream pout = new PipedOutputStream(pin);
            new Thread(){

                public void run() {
                    try {
                        AbstractSftpClient.this.put(path, pin, permissions);
                    }
                    catch (SshException sshException) {
                        // empty catch block
                    }
                }
            }.start();
            return pout;
        }
        catch (IOException e) {
            throw new SshException(SshException.IO_ERROR, (Throwable)e);
        }
    }

    public OutputStream put(String path, int permissions, long offset) throws SshException {
        if (offset > 0L) {
            throw new UnsupportedOperationException();
        }
        return this.put(path, permissions);
    }
}

