/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.sftp;

import java.text.DateFormat;
import java.util.Date;
import net.sf.sshapi.util.Util;

public class SftpFile {
    public static char[] TYPES = new char[]{' ', '-', 'd', 'l', 'p', '?', 's', 'c', 'b'};
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIRECTORY = 2;
    public static final int TYPE_LINK = 3;
    public static final int TYPE_FIFO = 4;
    public static final int TYPE_UNKNOWN = 5;
    public static final int TYPE_SOCKET = 6;
    public static final int TYPE_CHARACTER = 7;
    public static final int TYPE_BLOCK = 8;
    private final String path;
    private final long size;
    private final long lastModified;
    private final String name;
    private final int type;
    private final int gid;
    private final int uid;
    private final long created;
    private final long accessed;
    private final int permissions;

    public SftpFile(int type, String path, long size, long lastModified, long created, long accessed, int gid, int uid, int permissions) {
        this.path = path;
        this.size = size;
        this.gid = gid;
        this.uid = uid;
        this.lastModified = lastModified;
        this.created = created;
        this.permissions = permissions;
        this.accessed = accessed;
        this.type = type;
        this.name = Util.basename(path);
    }

    public boolean isDirectory() {
        return this.type == 2;
    }

    public boolean isFile() {
        return this.type == 1;
    }

    public boolean isLink() {
        return this.type == 3;
    }

    public int getType() {
        return this.type;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String toString() {
        DateFormat sdf = DateFormat.getDateTimeInstance();
        return this.name + "\t" + this.getSize() + "\t" + sdf.format(new Date(this.getLastModified()));
    }

    public int getGID() {
        return this.gid;
    }

    public int getUID() {
        return this.uid;
    }

    public long getAccessed() {
        return this.accessed;
    }

    public long getCreated() {
        return this.created;
    }

    public int getPermissions() {
        return this.permissions;
    }
}

