/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.impl.j2ssh;

import com.sshtools.j2ssh.ScpClient;
import com.sshtools.j2ssh.authentication.AuthenticationProtocolException;
import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.KBIPrompt;
import com.sshtools.j2ssh.authentication.KBIRequestHandler;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationPrompt;
import com.sshtools.j2ssh.configuration.SshConnectionProperties;
import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.IOChannel;
import com.sshtools.j2ssh.forwarding.ForwardingClient;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.XDisplay;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.session.SessionChannelClient;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.publickey.InvalidSshKeyException;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKeyFile;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Map;
import javax.net.SocketFactory;
import net.sf.sshapi.AbstractClient;
import net.sf.sshapi.AbstractSCPClient;
import net.sf.sshapi.AbstractSocket;
import net.sf.sshapi.SshClient;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.SshExtendedStreamChannel;
import net.sf.sshapi.SshProxyServerDetails;
import net.sf.sshapi.SshSCPClient;
import net.sf.sshapi.SshShell;
import net.sf.sshapi.auth.SshAuthenticator;
import net.sf.sshapi.auth.SshKeyboardInteractiveAuthenticator;
import net.sf.sshapi.auth.SshPasswordAuthenticator;
import net.sf.sshapi.auth.SshPublicKeyAuthenticator;
import net.sf.sshapi.forwarding.AbstractPortForward;
import net.sf.sshapi.forwarding.SshPortForward;
import net.sf.sshapi.hostkeys.AbstractHostKey;
import net.sf.sshapi.hostkeys.SshHostKey;
import net.sf.sshapi.impl.j2ssh.J2SshSftpClient;
import net.sf.sshapi.impl.j2ssh.J2SshShell;
import net.sf.sshapi.impl.j2ssh.J2SshStreamChannel;
import net.sf.sshapi.sftp.SftpClient;
import net.sf.sshapi.util.Util;

class J2SshClient
extends AbstractClient {
    private final com.sshtools.j2ssh.SshClient con = new com.sshtools.j2ssh.SshClient();
    private String username;
    private ForwardingClient forwarding;
    private static int fwdName = 0;
    private int timeout;

    public J2SshClient(SshConfiguration configuration) throws com.sshtools.j2ssh.SshException {
        super(configuration);
    }

    public void connect(String username, String hostname, int port) throws SshException {
        if (this.isConnected()) {
            throw new SshException(SshException.ALREADY_OPEN, "Already connected.");
        }
        try {
            SshConnectionProperties properties = new SshConnectionProperties();
            properties.setHost(hostname);
            properties.setPort(port);
            properties.setForwardingAutoStartMode(true);
            SshConfiguration configuration = this.getConfiguration();
            this.configureAlgorithms(properties, configuration);
            SshProxyServerDetails proxyServer = configuration.getProxyServer();
            if (proxyServer != null) {
                properties.setTransportProviderString(proxyServer.getType().toString());
                properties.setProxyHost(proxyServer.getHostname());
                properties.setProxyPort(proxyServer.getPort());
                properties.setProxyUsername(proxyServer.getUsername());
                properties.setProxyPassword(new String(proxyServer.getPassword()));
            }
            this.con.connect(hostname, port, (HostKeyVerification)new HostKeyVerificationBridge());
            this.username = username;
        }
        catch (IOException e) {
            throw new SshException(SshException.IO_ERROR, (Throwable)e);
        }
    }

    public void setTimeout(int timeout) throws IOException {
        this.timeout = timeout;
        if (this.con != null) {
            this.con.setSocketTimeout(timeout);
        }
    }

    public int getTimeout() throws IOException {
        return this.timeout;
    }

    public boolean authenticate(SshAuthenticator[] authenticators) throws SshException {
        Map authenticatorMap = this.createAuthenticatorMap(authenticators);
        try {
            String[] methods = this.con.getAvailableAuthMethods(this.username).toArray(new String[0]);
            block10: for (int i = 0; i < methods.length && !this.con.isAuthenticated(); ++i) {
                SshAuthenticator authenticator = (SshAuthenticator)authenticatorMap.get(methods[i]);
                if (authenticator == null) continue;
                int result = this.con.authenticate(this.createAuthentication(authenticator, methods[i]));
                switch (result) {
                    case 4: {
                        if (i != 0) continue block10;
                        this.checkBanner();
                        continue block10;
                    }
                    case 2: {
                        throw new SshException("Authentication failed.");
                    }
                    case 3: {
                        if (i != 0) continue block10;
                        this.checkBanner();
                        continue block10;
                    }
                    case 5: {
                        throw new SshException("Authentication cancelled.");
                    }
                    case 1: {
                        if (i != 0) continue block10;
                        this.checkBanner();
                        continue block10;
                    }
                    default: {
                        throw new SshException("Unknown authentication result " + result + ".");
                    }
                }
            }
        }
        catch (com.sshtools.j2ssh.SshException sshe) {
            throw new SshException("Failed to authenticate.", (Throwable)sshe);
        }
        catch (IOException ioe) {
            throw new SshException("I/O error.", (Throwable)ioe);
        }
        if (this.con.isAuthenticated()) {
            this.forwarding = this.con.getForwardingClient();
            if (this.getConfiguration().getX11Host() != null) {
                XDisplay xd = new XDisplay(this.getConfiguration().getX11Host(), this.getConfiguration().getX11Port() - 6000);
                this.forwarding.enableX11Forwarding(xd);
            }
            return true;
        }
        return false;
    }

    private String checkBanner() throws IOException {
        String banner = this.con.getAuthenticationBanner(2000);
        if (banner != null && !banner.trim().equals("") && this.getConfiguration().getBannerHandler() != null) {
            this.getConfiguration().getBannerHandler().banner(banner);
        }
        return banner;
    }

    private SshAuthenticationClient createAuthentication(SshAuthenticator authenticator, String type) throws AuthenticationProtocolException {
        if (authenticator instanceof SshPasswordAuthenticator) {
            final SshPasswordAuthenticator passwordAuthenticator = (SshPasswordAuthenticator)authenticator;
            PasswordAuthenticationClient pac = new PasswordAuthenticationClient();
            pac.setUsername(this.username);
            pac.setAuthenticationPrompt(new SshAuthenticationPrompt(){

                public boolean showPrompt(SshAuthenticationClient sshac) throws AuthenticationProtocolException {
                    if (sshac instanceof PasswordAuthenticationClient) {
                        char[] pw = passwordAuthenticator.promptForPassword((SshClient)J2SshClient.this, "Password");
                        if (pw == null) {
                            return false;
                        }
                        PasswordAuthenticationClient pac = (PasswordAuthenticationClient)sshac;
                        if (pac.getUsername() == null) {
                            pac.setUsername(J2SshClient.this.username);
                        }
                        pac.setPassword(new String(pw));
                        return true;
                    }
                    throw new AuthenticationProtocolException("PasswordAuthenticationClient instance required");
                }
            });
            return pac;
        }
        if (authenticator instanceof SshPublicKeyAuthenticator) {
            final SshPublicKeyAuthenticator publicKeyAuthenticator = (SshPublicKeyAuthenticator)authenticator;
            PublicKeyAuthenticationClient pkc = new PublicKeyAuthenticationClient();
            pkc.setUsername(this.username);
            pkc.setAuthenticationPrompt(new SshAuthenticationPrompt(){

                public boolean showPrompt(SshAuthenticationClient sshac) throws AuthenticationProtocolException {
                    if (sshac instanceof PublicKeyAuthenticationClient) {
                        try {
                            SshPrivateKeyFile pkf = SshPrivateKeyFile.parse((byte[])publicKeyAuthenticator.getPrivateKey());
                            char[] pw = null;
                            if (pkf.isPassphraseProtected() && (pw = publicKeyAuthenticator.promptForPassphrase((SshClient)J2SshClient.this, "Passphrase")) == null) {
                                return false;
                            }
                            PublicKeyAuthenticationClient pac = (PublicKeyAuthenticationClient)sshac;
                            if (pac.getUsername() == null) {
                                pac.setUsername(J2SshClient.this.username);
                            }
                            pac.setKey(pkf.toPrivateKey(pw == null ? "" : new String(pw)));
                        }
                        catch (InvalidSshKeyException e) {
                            AuthenticationProtocolException ape = new AuthenticationProtocolException(e.getLocalizedMessage());
                            ape.initCause((Throwable)e);
                            throw ape;
                        }
                        return true;
                    }
                    throw new AuthenticationProtocolException("PasswordAuthenticationClient instance required");
                }
            });
            return pkc;
        }
        if (authenticator instanceof SshKeyboardInteractiveAuthenticator) {
            final SshKeyboardInteractiveAuthenticator keyboardInteractiveAuthenticator = (SshKeyboardInteractiveAuthenticator)authenticator;
            KBIAuthenticationClient kbic = new KBIAuthenticationClient();
            kbic.setUsername(this.username);
            kbic.setKBIRequestHandler(new KBIRequestHandler(){

                public void showPrompts(String name, String instruction, KBIPrompt[] prompts) {
                    if (prompts != null) {
                        String[] prompt = new String[prompts.length];
                        boolean[] echo = new boolean[prompts.length];
                        for (int i = 0; i < prompts.length; ++i) {
                            prompt[i] = prompts[i].getPrompt();
                            echo[i] = prompts[i].echo();
                        }
                        String[] answers = keyboardInteractiveAuthenticator.challenge(name, instruction, prompt, echo);
                        if (answers != null) {
                            for (int i = 0; i < prompts.length; ++i) {
                                prompts[i].setResponse(answers[i]);
                            }
                        }
                    }
                }
            });
            return kbic;
        }
        throw new UnsupportedOperationException();
    }

    public SshShell createShell(String termType, int colWidth, int rowHeight, int pixWidth, int pixHeight, byte[] terminalModes) throws SshException {
        try {
            SessionChannelClient session = this.con.openSessionChannel();
            if (termType != null) {
                String modes;
                if (terminalModes == null || terminalModes.length == 0) {
                    terminalModes = new byte[]{0};
                }
                if (!session.requestPseudoTerminal(termType, colWidth, rowHeight, pixWidth, pixHeight, modes = new String(terminalModes, "US-ASCII"))) {
                    throw new SshException("Failed to allocate pseudo tty.");
                }
            }
            return new J2SshShell(this.getConfiguration(), session);
        }
        catch (SshException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException("Failed to open session channel.", (Throwable)e);
        }
    }

    public SshExtendedStreamChannel createCommand(final String command) throws SshException {
        try {
            final SessionChannelClient session = this.con.openSessionChannel();
            return new J2SshStreamChannel(this.getConfiguration(), session){

                public void onChannelOpen() throws SshException {
                    try {
                        if (!session.executeCommand(command)) {
                            throw new SshException("Failed to execute command.");
                        }
                    }
                    catch (IOException e) {
                        throw new SshException(SshException.IO_ERROR, (Throwable)e);
                    }
                }
            };
        }
        catch (Exception e) {
            throw new SshException("Failed to open session channel.", (Throwable)e);
        }
    }

    public void disconnect() throws SshException {
        if (!this.isConnected()) {
            throw new SshException(SshException.NOT_OPEN, "Not connected.");
        }
        this.con.disconnect();
    }

    public boolean isConnected() {
        return this.con != null && this.con.isConnected();
    }

    public boolean isAuthenticated() {
        return this.isConnected() && this.con.isAuthenticated();
    }

    public String getRemoteIdentification() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return this.con.getServerId();
    }

    public int getRemoteProtocolVersion() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected");
        }
        return 2;
    }

    public SshPortForward createLocalForward(String localAddress, int localPort, String remoteHost, int remotePort) throws SshException {
        final ForwardingConfiguration fwd = new ForwardingConfiguration("FWD" + fwdName++, localAddress, localPort, remoteHost, remotePort);
        return new AbstractPortForward(){

            protected void onOpen() throws SshException {
                try {
                    J2SshClient.this.forwarding.addLocalForwarding(fwd);
                    J2SshClient.this.forwarding.startLocalForwarding(fwd.getName());
                }
                catch (ForwardingConfigurationException e) {
                    throw new SshException("Failed to start local port forward.", (Throwable)e);
                }
            }

            protected void onClose() throws SshException {
                try {
                    J2SshClient.this.forwarding.stopLocalForwarding(fwd.getName());
                    J2SshClient.this.forwarding.removeLocalForwarding(fwd.getName());
                }
                catch (ForwardingConfigurationException e) {
                    throw new SshException("Failed to stop local port forward.", (Throwable)e);
                }
            }
        };
    }

    public SshPortForward createRemoteForward(String remoteHost, int remotePort, String localAddress, int localPort) throws SshException {
        final ForwardingConfiguration fwd = new ForwardingConfiguration("FWD" + fwdName++, remoteHost, remotePort, localAddress, localPort);
        return new AbstractPortForward(){

            protected void onOpen() throws SshException {
                try {
                    J2SshClient.this.forwarding.addRemoteForwarding(fwd);
                    J2SshClient.this.forwarding.startRemoteForwarding(fwd.getName());
                }
                catch (ForwardingConfigurationException e) {
                    throw new SshException("Failed to start remote port forward.", (Throwable)e);
                }
                catch (IOException e) {
                    throw new SshException(SshException.IO_ERROR, "Failed to start remote port forward.", (Throwable)e);
                }
            }

            protected void onClose() throws SshException {
                try {
                    J2SshClient.this.forwarding.stopRemoteForwarding(fwd.getName());
                    J2SshClient.this.forwarding.removeRemoteForwarding(fwd.getName());
                }
                catch (IOException e) {
                    throw new SshException(SshException.IO_ERROR, "Failed to stop remote port forward.", (Throwable)e);
                }
            }
        };
    }

    public SftpClient createSftpClient() throws SshException {
        return new J2SshSftpClient(this.con);
    }

    public SshSCPClient createSCPClient() throws SshException {
        return new J2SSHSCPClient();
    }

    public String getUsername() {
        return this.username;
    }

    private void configureAlgorithms(SshConnectionProperties properties, SshConfiguration configuration) {
        if (configuration.getPreferredClientToServerCipher() != null) {
            properties.setPrefCSEncryption(configuration.getPreferredClientToServerCipher());
        }
        if (configuration.getPreferredServerToClientCipher() != null) {
            properties.setPrefSCEncryption(configuration.getPreferredServerToClientCipher());
        }
        if (configuration.getPreferredClientToServerMAC() != null) {
            properties.setPrefCSMac(configuration.getPreferredClientToServerMAC());
        }
        if (configuration.getPreferredServerToClientMAC() != null) {
            properties.setPrefSCMac(configuration.getPreferredServerToClientMAC());
        }
        if (configuration.getPreferredClientToServerCompression() != null) {
            properties.setPrefCSComp(configuration.getPreferredClientToServerCompression());
        }
        if (configuration.getPreferredServerToClientCompression() != null) {
            properties.setPrefSCComp(configuration.getPreferredServerToClientCompression());
        }
        if (configuration.getPreferredKeyExchange() != null) {
            properties.setPrefKex(configuration.getPreferredKeyExchange());
        }
        if (configuration.getPreferredPublicKey() != null) {
            properties.setPrefPublicKey(configuration.getPreferredPublicKey());
        }
    }

    public int getChannelCount() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected.");
        }
        return this.con.getActiveChannelCount();
    }

    public SocketFactory createTunneledSocketFactory() throws SshException {
        return new RemoteSocketFactory();
    }

    class RemoteSocketChannel
    extends IOChannel {
        private InetSocketAddress socket;

        RemoteSocketChannel(InetSocketAddress socket) {
            this.socket = socket;
        }

        public byte[] getChannelConfirmationData() {
            return null;
        }

        public byte[] getChannelOpenData() {
            try {
                ByteArrayWriter baw = new ByteArrayWriter();
                String host = this.socket.getHostName();
                baw.writeString(host);
                baw.writeInt(this.socket.getPort());
                baw.writeString("127.0.0.1");
                baw.writeInt(0);
                return baw.toByteArray();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        public String getChannelType() {
            return "direct-tcpip";
        }

        protected int getMinimumWindowSpace() {
            return 32768;
        }

        protected int getMaximumWindowSpace() {
            return 131072;
        }

        protected int getMaximumPacketSize() {
            return 32768;
        }

        protected void onChannelOpen() throws IOException {
        }

        protected void onChannelRequest(String arg0, boolean arg1, byte[] arg2) throws IOException {
            this.connection.sendChannelRequestFailure((Channel)this);
        }
    }

    class RemoteSocket
    extends AbstractSocket {
        private IOChannel channel;

        RemoteSocket() {
        }

        RemoteSocket(String host, int port) throws UnknownHostException, IOException {
            super(host, port);
        }

        RemoteSocket(InetAddress host, int port) throws UnknownHostException, IOException {
            super(host, port);
        }

        public void onConnect(InetSocketAddress addr, int timeout) throws IOException {
            if (!J2SshClient.this.isConnected()) {
                throw new IOException("SSH client is not connected");
            }
            this.channel = new RemoteSocketChannel(addr);
            if (!J2SshClient.this.con.openChannel((Channel)this.channel)) {
                throw new IOException("Failed to open direct-tcpip channel.");
            }
        }

        public void bind(SocketAddress bindpoint) throws IOException {
            throw new UnsupportedOperationException();
        }

        public synchronized void doClose() throws IOException {
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                finally {
                    this.channel = null;
                }
            }
        }

        public InputStream getInputStream() throws IOException {
            if (!this.isConnected()) {
                throw new IOException("Not connected.");
            }
            return this.channel.getInputStream();
        }

        public OutputStream getOutputStream() throws IOException {
            if (!this.isConnected()) {
                throw new IOException("Not connected.");
            }
            return this.channel.getOutputStream();
        }

        public boolean isConnected() {
            return this.channel != null && !this.isClosed();
        }
    }

    class RemoteSocketFactory
    extends SocketFactory {
        RemoteSocketFactory() {
        }

        public Socket createSocket() throws IOException {
            return new RemoteSocket();
        }

        public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
            return new RemoteSocket(host, port);
        }

        public Socket createSocket(InetAddress host, int port) throws IOException {
            return new RemoteSocket(host, port);
        }

        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
            return new RemoteSocket(host, port);
        }

        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return new RemoteSocket(address, port);
        }
    }

    class J2SSHSCPClient
    extends AbstractSCPClient {
        private ScpClient client;

        J2SSHSCPClient() {
        }

        protected void onOpen() throws SshException {
            try {
                this.client = J2SshClient.this.con.openScpClient();
            }
            catch (IOException e) {
                throw new SshException(SshException.IO_ERROR, (Throwable)e);
            }
            super.onOpen();
        }

        public void get(String remoteFilePath, File destinationFile, boolean recursive) throws SshException {
            try {
                this.client.get(destinationFile.getAbsolutePath(), remoteFilePath, recursive);
            }
            catch (IOException e) {
                throw new SshException(SshException.IO_ERROR, (Throwable)e);
            }
        }

        public void doPut(String remotePath, String mode, File sourceFile, boolean recursive) throws SshException {
            try {
                this.client.put(sourceFile.getAbsolutePath(), remotePath, recursive);
            }
            catch (IOException e) {
                throw new SshException(SshException.IO_ERROR, (Throwable)e);
            }
        }
    }

    class HostKeyVerificationBridge
    implements HostKeyVerification {
        HostKeyVerificationBridge() {
        }

        public boolean verifyHost(final String host, final SshPublicKey pk) {
            SshConfiguration configuration = J2SshClient.this.getConfiguration();
            if (configuration.getHostKeyValidator() != null) {
                try {
                    int status = configuration.getHostKeyValidator().verifyHost((SshHostKey)new AbstractHostKey(){

                        public String getType() {
                            return pk.getAlgorithmName();
                        }

                        public byte[] getKey() {
                            return pk.getEncoded();
                        }

                        public String getHost() {
                            return host;
                        }

                        public String getFingerprint() {
                            return pk.getFingerprint();
                        }
                    });
                    return status == 0;
                }
                catch (SshException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("The authenticity of host '" + host + "' can't be established.");
                System.out.println(pk.getAlgorithmName() + " key fingerprint is " + pk.getFingerprint());
                return Util.promptYesNo((String)"Are you sure you want to continue connecting?");
            }
            return false;
        }
    }
}

