/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.impl.j2ssh;

import com.sshtools.j2ssh.transport.AbstractKnownHostsKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.hostkeys.AbstractHostKey;
import net.sf.sshapi.hostkeys.AbstractHostKeyManager;
import net.sf.sshapi.hostkeys.SshHostKey;
import net.sf.sshapi.util.Util;

class J2SshHostKeyManager
extends AbstractHostKeyManager {
    private AbstractKnownHostsKeyVerification knownHosts;

    public J2SshHostKeyManager(SshConfiguration configuration) throws SshException {
        super(configuration);
        try {
            this.knownHosts = new AbstractKnownHostsKeyVerification(Util.getKnownHostsFile((SshConfiguration)configuration).getAbsolutePath()){

                public void onHostKeyMismatch(String arg0, SshPublicKey arg1, SshPublicKey arg2) throws TransportProtocolException {
                }

                public void onUnknownHost(String arg0, SshPublicKey arg1) throws TransportProtocolException {
                }
            };
        }
        catch (InvalidHostFileException e) {
            throw new SshException(SshException.GENERAL, (Throwable)e);
        }
    }

    public void add(final SshHostKey hostKey, boolean persist) throws SshException {
        try {
            this.knownHosts.allowHost(hostKey.getHost(), new SshPublicKey(){

                public boolean verifySignature(byte[] signature, byte[] data) {
                    return false;
                }

                public String getFingerprint() {
                    return hostKey.getFingerprint();
                }

                public byte[] getEncoded() {
                    return hostKey.getKey();
                }

                public int getBitLength() {
                    return 0;
                }

                public String getAlgorithmName() {
                    return hostKey.getType();
                }
            }, persist);
        }
        catch (InvalidHostFileException e) {
            throw new SshException(SshException.GENERAL, (Throwable)e);
        }
    }

    public SshHostKey[] getKeys() {
        ArrayList<3> hostKeys = new ArrayList<3>();
        Map hosts = this.knownHosts.allowedHosts();
        Iterator e = hosts.keySet().iterator();
        while (e.hasNext()) {
            final String host = (String)e.next();
            HashMap allowed = (HashMap)hosts.get(host);
            Iterator e2 = allowed.keySet().iterator();
            while (e2.hasNext()) {
                String algo = (String)e2.next();
                final SshPublicKey key = (SshPublicKey)allowed.get(algo);
                hostKeys.add(new AbstractHostKey(){

                    public String getType() {
                        return key.getAlgorithmName();
                    }

                    public byte[] getKey() {
                        return key.getEncoded();
                    }

                    public String getHost() {
                        return host;
                    }

                    public String getFingerprint() {
                        return key.getFingerprint();
                    }
                });
            }
        }
        return hostKeys.toArray(new SshHostKey[0]);
    }

    public boolean isWriteable() {
        return this.knownHosts.isHostFileWriteable();
    }

    public void remove(SshHostKey hostKey) {
        this.knownHosts.removeAllowedHost(hostKey.getHost());
    }
}

