/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sshapi.impl.j2ssh;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.cipher.SshCipherFactory;
import com.sshtools.j2ssh.transport.compression.SshCompressionFactory;
import com.sshtools.j2ssh.transport.hmac.SshHmacFactory;
import com.sshtools.j2ssh.transport.kex.SshKeyExchangeFactory;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.sf.sshapi.AbstractProvider;
import net.sf.sshapi.Capability;
import net.sf.sshapi.SshClient;
import net.sf.sshapi.SshConfiguration;
import net.sf.sshapi.SshException;
import net.sf.sshapi.hostkeys.SshHostKeyManager;
import net.sf.sshapi.impl.j2ssh.J2SshClient;
import net.sf.sshapi.impl.j2ssh.J2SshHostKeyManager;

public class J2SshProvider
extends AbstractProvider {
    public J2SshProvider() {
        super("J2SSH");
    }

    public SshClient doCreateClient(SshConfiguration configuration) {
        try {
            return new J2SshClient(configuration);
        }
        catch (com.sshtools.j2ssh.SshException e) {
            throw new IllegalArgumentException("Could not create client for configuration.", e);
        }
    }

    public List getCapabilities() {
        return Arrays.asList(Capability.PER_CONNECTION_CONFIGURATION, Capability.SSH2, Capability.HTTP_PROXY, Capability.SOCKS4_PROXY, Capability.SOCKS5_PROXY, Capability.PASSWORD_AUTHENTICATION, Capability.PUBLIC_KEY_AUTHENTICATION, Capability.KEYBOARD_INTERACTIVE_AUTHENTICATION, Capability.HOST_KEY_MANAGEMENT, Capability.SCP, Capability.SFTP, Capability.WINDOW_CHANGE, Capability.TUNNELED_SOCKET_FACTORY, Capability.DATA_TIMEOUTS);
    }

    public SshHostKeyManager createHostKeyManager(SshConfiguration configuration) throws SshException {
        return new J2SshHostKeyManager(configuration);
    }

    public List getSupportedCiphers(int protocolVersion) {
        if (protocolVersion == 1) {
            throw new UnsupportedOperationException("Only SSH2 is supported by J2SSH");
        }
        return SshCipherFactory.getSupportedCiphers();
    }

    public List getSupportedCompression() {
        return SshCompressionFactory.getSupportedCompression();
    }

    public List getSupportedMAC() {
        return SshHmacFactory.getSupportedMacs();
    }

    public void doSupportsConfiguration(SshConfiguration configuration) {
        try {
            Class.forName("com.sshtools.j2ssh.SshClient", false, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnsupportedOperationException("J2SSH is not on the CLASSPATH");
        }
        if (configuration != null && configuration.getProtocolVersion() == 1) {
            throw new UnsupportedOperationException("SSH1 is not supported.");
        }
    }

    public List getSupportedKeyExchange() {
        return SshKeyExchangeFactory.getSupportedKeyExchanges();
    }

    public List getSupportedPublicKey() {
        return Arrays.asList("ssh-rsa", "ssh-dss");
    }

    public void seed(long seed) {
        SecureRandom r = ConfigurationLoader.getRND();
        ((Random)r).setSeed(seed);
    }
}

