/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.ext;

import com.sshtools.vfs.ext.FileObjectEventListener;
import java.io.Closeable;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.impl.DecoratedFileObject;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.AbstractFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.LocalFileProvider;
import org.apache.commons.vfs2.provider.VfsComponent;
import org.apache.commons.vfs2.util.RandomAccessMode;

public class EventFiringFileSystemManager
extends DefaultFileSystemManager
implements FileObjectEventListener,
Closeable {
    private List<FileObjectEventListener> listeners = new ArrayList<FileObjectEventListener>();
    private Map<String, Object> providerMap = Collections.synchronizedMap(new HashMap());
    private List<String> virtualFileSystemSchemes = Collections.synchronizedList(new ArrayList());

    public void addListener(FileObjectEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FileObjectEventListener listener) {
        this.listeners.remove(listener);
    }

    static FileObject wrap(FileObject ob, FileObjectEventListener firer) {
        if (ob == null || ob instanceof MonitoredFile) {
            return ob;
        }
        return new MonitoredFile(firer, ob);
    }

    public void addProvider(String urlScheme, FileProvider provider) throws FileSystemException {
        this.providerMap.put(urlScheme, provider);
        super.addProvider(urlScheme, this.wrap(provider));
    }

    public void addProvider(String[] urlSchemes, FileProvider provider) throws FileSystemException {
        super.addProvider(urlSchemes, this.wrap(provider));
    }

    public FileObject resolveFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.wrap(super.resolveFile(baseFile, uri, fileSystemOptions));
    }

    FileObject wrap(FileObject ob) {
        return EventFiringFileSystemManager.wrap(ob, this);
    }

    FileProvider wrap(FileProvider provider) {
        return provider instanceof LocalFileProvider ? new LocalMonitoredProvider((LocalFileProvider)provider) : new MonitoredProvider(provider);
    }

    public String[] getSchemes() {
        ArrayList<String> schemes = new ArrayList<String>(this.providerMap.size() + this.virtualFileSystemSchemes.size());
        schemes.addAll(this.providerMap.keySet());
        schemes.addAll(this.virtualFileSystemSchemes);
        return schemes.toArray(new String[0]);
    }

    @Override
    public void fireDeletedFile(FileObject f) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).fireDeletedFile(f);
        }
    }

    @Override
    public void fireNewFile(FileObject f) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).fireNewFile(f);
        }
    }

    @Override
    public void fireUpdatedFile(FileObject f) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).fireUpdatedFile(f);
        }
    }

    protected void addVirtualFileSystemScheme(String rootUri) {
        super.addVirtualFileSystemScheme(rootUri);
        this.virtualFileSystemSchemes.add(rootUri);
    }

    class MonitoredProvider
    extends AbstractFileProvider
    implements VfsComponent {
        protected FileProvider provider;

        MonitoredProvider(FileProvider provider) {
            this.provider = provider;
        }

        public void close() {
            if (this.provider instanceof VfsComponent) {
                ((VfsComponent)this.provider).close();
            }
        }

        public FileObject createFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
            return EventFiringFileSystemManager.this.wrap(this.provider.createFileSystem(scheme, file, fileSystemOptions));
        }

        public boolean equals(Object obj) {
            return this.provider.equals(obj);
        }

        public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
            return EventFiringFileSystemManager.this.wrap(this.provider.findFile(baseFile, uri, fileSystemOptions));
        }

        public Collection<Capability> getCapabilities() {
            return this.provider.getCapabilities();
        }

        public FileSystemConfigBuilder getConfigBuilder() {
            return this.provider.getConfigBuilder();
        }

        public int hashCode() {
            return this.provider.hashCode();
        }

        public void init() throws FileSystemException {
            if (this.provider instanceof VfsComponent) {
                ((VfsComponent)this.provider).setLogger(this.getLogger());
                ((VfsComponent)this.provider).setContext(this.getContext());
                ((VfsComponent)this.provider).init();
            }
        }

        public FileName parseUri(FileName root, String uri) throws FileSystemException {
            return this.provider.parseUri(root, uri);
        }
    }

    static class MonitoredFile
    extends DecoratedFileObject {
        final FileObjectEventListener firer;

        public MonitoredFile(FileObjectEventListener firer, FileObject file) {
            super(file);
            this.firer = firer;
        }

        public void copyFrom(FileObject srcFile, FileSelector selector) throws FileSystemException {
            super.copyFrom(srcFile, selector);
            this.firer.fireUpdatedFile((FileObject)this);
        }

        public void createFile() throws FileSystemException {
            super.createFile();
            this.firer.fireNewFile((FileObject)this);
        }

        public void createFolder() throws FileSystemException {
            super.createFolder();
            this.firer.fireNewFile((FileObject)this);
        }

        public boolean delete() throws FileSystemException {
            boolean delete = super.delete();
            this.firer.fireDeletedFile((FileObject)this);
            return delete;
        }

        public int delete(final FileSelector selector) throws FileSystemException {
            final ArrayList deleted = new ArrayList();
            int delete = super.delete(new FileSelector(){

                public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                    boolean sel = selector.includeFile(fileInfo);
                    if (sel) {
                        deleted.add(fileInfo.getFile());
                    }
                    return sel;
                }

                public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                    return selector.traverseDescendents(fileInfo);
                }
            });
            if (delete != deleted.size()) {
                this.firer.fireUpdatedFile((FileObject)this);
            } else {
                for (FileObject d : deleted) {
                    this.firer.fireDeletedFile(d);
                }
            }
            return delete;
        }

        public boolean equals(Object obj) {
            return this.getDecoratedFileObject().equals(obj instanceof MonitoredFile ? ((MonitoredFile)((Object)obj)).getDecoratedFileObject() : obj);
        }

        public FileObject[] findFiles(FileSelector selector) throws FileSystemException {
            FileObject[] f = super.findFiles(selector);
            FileObject[] n = new FileObject[f.length];
            for (int i = 0; i < f.length; ++i) {
                n[i] = this.wrap(f[i]);
            }
            return n;
        }

        public void findFiles(FileSelector selector, boolean depthwise, List<FileObject> selected) throws FileSystemException {
            ArrayList l = new ArrayList();
            super.findFiles(selector, depthwise, l);
            for (FileObject m : l) {
                selected.add(this.wrap(m));
            }
        }

        public FileObject getChild(String name) throws FileSystemException {
            return this.wrap(super.getChild(name));
        }

        public FileObject[] getChildren() throws FileSystemException {
            FileObject[] f = super.getChildren();
            FileObject[] n = new FileObject[f.length];
            for (int i = 0; i < f.length; ++i) {
                n[i] = this.wrap(f[i]);
            }
            return n;
        }

        public FileContent getContent() throws FileSystemException {
            final FileContent content = super.getContent();
            return new FileContent(){

                public void close() throws FileSystemException {
                    content.close();
                }

                public Object getAttribute(String attrName) throws FileSystemException {
                    return content.getAttribute(attrName);
                }

                public String[] getAttributeNames() throws FileSystemException {
                    return content.getAttributeNames();
                }

                public Map<String, Object> getAttributes() throws FileSystemException {
                    return content.getAttributes();
                }

                public Certificate[] getCertificates() throws FileSystemException {
                    return content.getCertificates();
                }

                public FileContentInfo getContentInfo() throws FileSystemException {
                    return content.getContentInfo();
                }

                public FileObject getFile() {
                    return content.getFile();
                }

                public InputStream getInputStream() throws FileSystemException {
                    return content.getInputStream();
                }

                public long getLastModifiedTime() throws FileSystemException {
                    return content.getLastModifiedTime();
                }

                public OutputStream getOutputStream() throws FileSystemException {
                    final OutputStream contentOut = content.getOutputStream();
                    return new FilterOutputStream(contentOut){

                        @Override
                        public void write(byte[] b, int off, int len) throws IOException {
                            contentOut.write(b, off, len);
                        }

                        @Override
                        public void close() throws IOException {
                            try {
                                super.close();
                            }
                            finally {
                                firer.fireUpdatedFile((FileObject)this);
                            }
                        }
                    };
                }

                public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
                    return new FilterOutputStream(content.getOutputStream(bAppend)){

                        @Override
                        public void close() throws IOException {
                            try {
                                super.close();
                            }
                            finally {
                                firer.fireUpdatedFile((FileObject)this);
                            }
                        }
                    };
                }

                public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
                    return content.getRandomAccessContent(mode);
                }

                public long getSize() throws FileSystemException {
                    return content.getSize();
                }

                public boolean hasAttribute(String attrName) throws FileSystemException {
                    return content.hasAttribute(attrName);
                }

                public boolean isOpen() {
                    return content.isOpen();
                }

                public void removeAttribute(String attrName) throws FileSystemException {
                    content.removeAttribute(attrName);
                }

                public void setAttribute(String attrName, Object value) throws FileSystemException {
                    content.setAttribute(attrName, value);
                }

                public void setLastModifiedTime(long modTime) throws FileSystemException {
                    content.setLastModifiedTime(modTime);
                }

                public long write(FileContent output) throws IOException {
                    return content.write(output);
                }

                public long write(FileObject file) throws IOException {
                    return content.write(file);
                }

                public long write(OutputStream output) throws IOException {
                    return content.write(output);
                }

                public long write(OutputStream output, int bufferSize) throws IOException {
                    return content.write(output, bufferSize);
                }
            };
        }

        public FileObject getParent() throws FileSystemException {
            if (this.getName().getURI().equals(this.getFileSystem().getRootName().getURI())) {
                if (this.getFileSystem().getParentLayer() != null) {
                    return this.wrap(this.getFileSystem().getParentLayer().getParent());
                }
                return null;
            }
            return this.wrap(super.getParent());
        }

        public int hashCode() {
            return this.getDecoratedFileObject().hashCode();
        }

        public boolean isHidden() throws FileSystemException {
            return super.isHidden() || this.getName().getBaseName().endsWith("~");
        }

        public void moveTo(FileObject destFile) throws FileSystemException {
            this.firer.fireDeletedFile((FileObject)this);
            super.moveTo(destFile);
            this.firer.fireNewFile(destFile);
        }

        public FileObject resolveFile(String path) throws FileSystemException {
            return this.wrap(super.resolveFile(path));
        }

        public FileObject resolveFile(String name, NameScope scope) throws FileSystemException {
            return this.wrap(super.resolveFile(name, scope));
        }

        FileObject wrap(FileObject ob) {
            return EventFiringFileSystemManager.wrap(ob, this.firer);
        }
    }

    class LocalMonitoredProvider
    extends MonitoredProvider
    implements LocalFileProvider {
        LocalMonitoredProvider(LocalFileProvider provider) {
            super((FileProvider)provider);
        }

        public FileObject findLocalFile(File file) throws FileSystemException {
            return EventFiringFileSystemManager.this.wrap(((LocalFileProvider)this.provider).findLocalFile(file));
        }

        public FileObject findLocalFile(String name) throws FileSystemException {
            return EventFiringFileSystemManager.this.wrap(((LocalFileProvider)this.provider).findLocalFile(name));
        }

        public boolean isAbsoluteLocalName(String name) {
            return ((LocalFileProvider)this.provider).isAbsoluteLocalName(name);
        }
    }
}

