/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.ext;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.operations.FileOperationProvider;

public class FilteredFileSystemManager<M extends FileSystemManager>
implements FileSystemManager {
    protected M underlying;

    public FilteredFileSystemManager(M underlying) {
        this.underlying = underlying;
    }

    public M getUnderlying() {
        return this.underlying;
    }

    public FileObject getBaseFile() throws FileSystemException {
        return this.underlying.getBaseFile();
    }

    public FileObject resolveFile(String name) throws FileSystemException {
        return this.underlying.resolveFile(name);
    }

    public FileObject resolveFile(String name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.underlying.resolveFile(name, fileSystemOptions);
    }

    public FileObject resolveFile(FileObject baseFile, String name) throws FileSystemException {
        return this.underlying.resolveFile(baseFile, name);
    }

    public FileObject resolveFile(File baseFile, String name) throws FileSystemException {
        return this.underlying.resolveFile(baseFile, name);
    }

    public FileName resolveName(FileName root, String name) throws FileSystemException {
        return this.underlying.resolveName(root, name);
    }

    public FileName resolveName(FileName root, String name, NameScope scope) throws FileSystemException {
        return this.underlying.resolveName(root, name, scope);
    }

    public FileObject toFileObject(File file) throws FileSystemException {
        return this.underlying.toFileObject(file);
    }

    public FileObject createFileSystem(String provider, FileObject file) throws FileSystemException {
        return this.underlying.createFileSystem(provider, file);
    }

    public void closeFileSystem(FileSystem filesystem) {
        this.underlying.closeFileSystem(filesystem);
    }

    public FileObject createFileSystem(FileObject file) throws FileSystemException {
        return this.underlying.createFileSystem(file);
    }

    public FileObject createVirtualFileSystem(String rootUri) throws FileSystemException {
        return this.underlying.createVirtualFileSystem(rootUri);
    }

    public FileObject createVirtualFileSystem(FileObject rootFile) throws FileSystemException {
        return this.underlying.createVirtualFileSystem(rootFile);
    }

    public URLStreamHandlerFactory getURLStreamHandlerFactory() {
        return this.underlying.getURLStreamHandlerFactory();
    }

    public boolean canCreateFileSystem(FileObject file) throws FileSystemException {
        return this.underlying.canCreateFileSystem(file);
    }

    public FilesCache getFilesCache() {
        return this.underlying.getFilesCache();
    }

    public CacheStrategy getCacheStrategy() {
        return this.underlying.getCacheStrategy();
    }

    public Class<?> getFileObjectDecorator() {
        return this.underlying.getFileObjectDecorator();
    }

    public Constructor<?> getFileObjectDecoratorConst() {
        return this.underlying.getFileObjectDecoratorConst();
    }

    public FileContentInfoFactory getFileContentInfoFactory() {
        return this.underlying.getFileContentInfoFactory();
    }

    public boolean hasProvider(String scheme) {
        return this.underlying.hasProvider(scheme);
    }

    public String[] getSchemes() {
        return this.underlying.getSchemes();
    }

    public Collection<Capability> getProviderCapabilities(String scheme) throws FileSystemException {
        return this.underlying.getProviderCapabilities(scheme);
    }

    public void setLogger(Log log) {
        this.underlying.setLogger(log);
    }

    public FileSystemConfigBuilder getFileSystemConfigBuilder(String scheme) throws FileSystemException {
        return this.underlying.getFileSystemConfigBuilder(scheme);
    }

    public FileName resolveURI(String uri) throws FileSystemException {
        return this.underlying.resolveURI(uri);
    }

    public void addOperationProvider(String scheme, FileOperationProvider operationProvider) throws FileSystemException {
        this.underlying.addOperationProvider(scheme, operationProvider);
    }

    public void addOperationProvider(String[] schemes, FileOperationProvider operationProvider) throws FileSystemException {
        this.underlying.addOperationProvider(schemes, operationProvider);
    }

    public FileOperationProvider[] getOperationProviders(String scheme) throws FileSystemException {
        return this.underlying.getOperationProviders(scheme);
    }

    public FileObject resolveFile(URI uri) throws FileSystemException {
        return this.underlying.resolveFile(uri);
    }

    public FileObject resolveFile(URL url) throws FileSystemException {
        return this.underlying.resolveFile(url);
    }
}

