/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.ext;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VFS;

public class Sync {
    static final Log LOG = LogFactory.getLog(Sync.class);
    private List<FileObject> sources = new ArrayList<FileObject>();
    private FileObject destination;
    private boolean recursive = true;
    private boolean preserveAttributes = true;
    private boolean deleteRemoved = true;
    private Checker checker = new LastModifiedChecker();
    private Completor completor;

    public Sync() {
    }

    public Sync(FileObject destination, FileObject ... sources) {
        this.sources(sources);
        this.destination(destination);
    }

    public Completor completor() {
        return this.completor;
    }

    public Sync completor(Completor decorator) {
        this.completor = decorator;
        return this;
    }

    public Sync sources(FileObject ... sources) {
        this.sources.clear();
        this.sources.addAll(Arrays.asList(sources));
        return this;
    }

    public Sync addSource(FileObject source) {
        this.sources.add(source);
        return this;
    }

    public List<FileObject> sources() {
        return this.sources;
    }

    public Sync destination(FileObject destination) {
        this.destination = destination;
        return this;
    }

    public FileObject destination() {
        return this.destination;
    }

    public Sync deleteRemoved(boolean deleteRemoved) {
        this.deleteRemoved = deleteRemoved;
        return this;
    }

    public boolean deleteRemoved() {
        return this.deleteRemoved;
    }

    public Sync recursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public boolean recursive() {
        return this.recursive;
    }

    public Sync preserveAttributes(boolean preserveAttributes) {
        this.preserveAttributes = preserveAttributes;
        return this;
    }

    public boolean preserveAttributes() {
        return this.preserveAttributes;
    }

    public Checker checker() {
        return this.checker;
    }

    public Sync checker(Checker checker) {
        this.checker = checker;
        return this;
    }

    public void sync() throws IOException {
        if (!(this.destination.exists() || this.destination.getParent() != null && this.destination.getParent().exists() && this.destination.getParent().getType() == FileType.FOLDER && this.sources.size() <= 1)) {
            throw new FileNotFoundException("Destination doesn't exist.");
        }
        for (FileObject f : this.sources) {
            this.sync(f, this.destination, 0);
            this.completor.completeRoot(f, this.destination);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void sync(FileObject from, FileObject to, int depth) throws IOException {
        if (from.getType() == FileType.FOLDER) {
            if (depth > 0 && !this.recursive) {
                return;
            }
            if (to.getType() == FileType.FOLDER || to.getParent() != null && to.getParent().exists() && to.getParent().getType() == FileType.FOLDER) {
                LinkedList<FileObject> exist = new LinkedList<FileObject>();
                if (this.deleteRemoved && to.exists()) {
                    exist.addAll(Arrays.asList(to.getChildren()));
                }
                if (!to.exists()) {
                    to.createFolder();
                }
                for (FileObject c : from.getChildren()) {
                    FileObject target = to.resolveFile(c.getName().getBaseName());
                    this.sync(c, target, depth + 1);
                    exist.remove(target);
                }
                Iterator iterator = exist.iterator();
                while (iterator.hasNext()) {
                    FileObject c = (FileObject)iterator.next();
                    LOG.info((Object)String.format("Removing %s as it was removing from the source directory %s", c, to));
                    c.deleteAll();
                }
                return;
            }
            if (to.getType() == FileType.FILE) {
                throw new IOException(String.format("Could not synchronize %s. Target file %s is a directory", from, to));
            }
            throw new IOException(String.format("Could not synchronize %s. Target file %s is imaginary", from, to));
        }
        if (from.getType() != FileType.FILE) {
            throw new IOException(String.format("Source file %s is imaginary", from));
        }
        if (to.getType() == FileType.FOLDER) {
            this.syncFile(from, to.resolveFile(from.getName().getBaseName()));
            return;
        }
        if (to.getType() == FileType.FILE || to.getParent() != null && to.getParent().exists() && to.getParent().getType() == FileType.FOLDER) {
            this.syncFile(from, to);
            return;
        }
        throw new IOException(String.format("Could not synchronize %s. Target file %s is imaginary", from, to));
    }

    protected void syncFile(FileObject from, FileObject to) throws IOException {
        Result result = Result.UPDATE;
        if (this.checker != null && (result = this.checker.check(from, to)) == Result.ABORT) {
            throw new IOException("Synchronize aborted.");
        }
        if (result == Result.SKIP) {
            LOG.info((Object)String.format("Skipping %s to %s", from, to));
        } else {
            LOG.info((Object)String.format("Copying %s to %s", from, to));
            to.copyFrom(from, (FileSelector)new AllFileSelector());
            if (this.checker != null) {
                this.checker.tag(result, from, to);
            }
            if (this.preserveAttributes) {
                to.setReadable(from.isReadable(), true);
                to.setWritable(from.isWriteable(), true);
                to.setExecutable(from.isExecutable(), true);
            }
            if (this.completor != null) {
                this.completor.complete(from, to);
            }
            LOG.info((Object)String.format("Copied %s to %s", from, to));
        }
    }

    public static void main(String[] args) throws Exception {
        int i;
        if (args.length < 2) {
            throw new IllegalArgumentException("Expects at least a source URI and a target URI.");
        }
        FileSystemManager vfs = VFS.getManager();
        Sync sync = new Sync();
        for (i = 0; i < args.length - 1; ++i) {
            sync.addSource(vfs.resolveFile(args[i]));
        }
        sync.destination(vfs.resolveFile(args[i]));
        sync.sync();
    }

    public static class LastModifiedChecker
    implements Checker {
        @Override
        public Result check(FileObject incoming, FileObject existing) throws FileSystemException {
            if (!existing.exists()) {
                LOG.info((Object)String.format("%s doesn't exist, so updating from incoming %s", existing, incoming));
                return Result.UPDATE;
            }
            if (!incoming.exists()) {
                LOG.warn((Object)String.format("%s doesn't exist at all, so skipping %s", incoming, existing));
                return Result.SKIP;
            }
            long m1 = 0L;
            try {
                m1 = incoming.exists() ? incoming.getContent().getLastModifiedTime() : 0L;
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception checking local file. Assuming doesn't exist.", (Throwable)e);
            }
            long m2 = existing.getContent().getLastModifiedTime();
            if (m1 > m2) {
                LOG.info((Object)String.format("The incoming %s is newer than the existing %s, updating", incoming, existing));
                return Result.UPDATE;
            }
            LOG.info((Object)String.format("The existing %s is newer or identical to %s, skipping", existing, incoming));
            return Result.SKIP;
        }

        @Override
        public void tag(Result result, FileObject incoming, FileObject existing) throws FileSystemException {
            FileContent content = incoming == null ? null : incoming.getContent();
            long tm = content == null ? System.currentTimeMillis() : content.getLastModifiedTime();
            LOG.info((Object)String.format("Setting last modified of %s to %s from %s", existing, tm, incoming));
            existing.getContent().setLastModifiedTime(tm);
        }
    }

    public static class AlwaysCopyChecker
    implements Checker {
        @Override
        public Result check(FileObject incoming, FileObject existing) throws FileSystemException {
            return Result.UPDATE;
        }

        @Override
        public void tag(Result result, FileObject file, FileObject existing) throws FileSystemException {
        }
    }

    public static interface Checker {
        public Result check(FileObject var1, FileObject var2) throws FileSystemException;

        public void tag(Result var1, FileObject var2, FileObject var3) throws FileSystemException;
    }

    public static interface Completor {
        public void complete(FileObject var1, FileObject var2);

        default public void completeRoot(FileObject sourceRoot, FileObject destinationRoot) {
            this.complete(sourceRoot, destinationRoot);
        }
    }

    public static enum Result {
        SKIP,
        UPDATE,
        ABORT;

    }
}

