/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.smbng;

import com.sshtools.vfs.smbng.SmbFileName;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.GenericURLFileNameParser;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;

public class SmbFileNameParser
extends GenericURLFileNameParser {
    private static final SmbFileNameParser INSTANCE = new SmbFileNameParser();
    private static final int SMB_PORT = 139;

    public SmbFileNameParser() {
        super(139);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String filename) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        HostFileNameParser.Authority auth = this.extractToPath(context, filename, name);
        String username = auth.getUserName();
        String domain = this.extractDomain(username);
        if (domain != null) {
            username = username.substring(domain.length() + 1);
        }
        UriParser.canonicalizePath((StringBuilder)name, (int)0, (int)name.length(), (FileNameParser)this);
        UriParser.fixSeparators((StringBuilder)name);
        String share = UriParser.extractFirstElement((StringBuilder)name);
        if (share == null || share.length() == 0) {
            throw new FileSystemException("vfs.provider.smb/missing-share-name.error", (Object)filename);
        }
        FileType fileType = UriParser.normalisePath((StringBuilder)name);
        String path = name.toString();
        return new SmbFileName(auth.getScheme(), auth.getHostName(), auth.getPort(), username, auth.getPassword(), domain, share, path, fileType);
    }

    private String extractDomain(String username) {
        if (username == null) {
            return null;
        }
        for (int i = 0; i < username.length(); ++i) {
            if (username.charAt(i) != '$') continue;
            return username.substring(0, i);
        }
        return null;
    }
}

