/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.smbng;

import com.sshtools.vfs.smbng.SmbFileName;
import com.sshtools.vfs.smbng.SmbFileProvider;
import com.sshtools.vfs.smbng.SmbFileSystem;
import com.sshtools.vfs.smbng.SmbFileSystemConfigBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import jcifs.CIFSContext;
import jcifs.CIFSException;
import jcifs.CloseableIterator;
import jcifs.Credentials;
import jcifs.SmbRandomAccess;
import jcifs.SmbResource;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileTypeHasNoContentException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.commons.vfs2.util.UserAuthenticatorUtils;

public class SmbFileObject
extends AbstractFileObject<SmbFileSystem> {
    private SmbResource file;

    protected SmbFileObject(AbstractFileName name, SmbFileSystem fileSystem) throws FileSystemException {
        super(name, (AbstractFileSystem)fileSystem);
    }

    protected void doAttach() throws Exception {
        if (this.file == null) {
            this.file = this.createSmbFile(this.getName());
        }
    }

    protected void doDetach() throws Exception {
        this.file = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SmbResource createSmbFile(FileName fileName) throws MalformedURLException, FileSystemException, CIFSException {
        SmbResource smbResource;
        SmbFileName smbFileName = (SmbFileName)fileName;
        String path = smbFileName.getUriWithoutAuth();
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate((FileSystemOptions)this.getFileSystem().getFileSystemOptions(), (UserAuthenticationData.Type[])SmbFileProvider.AUTHENTICATOR_TYPES);
            if (authData == null) {
                throw new IllegalStateException("Authentication cancelled.");
            }
            CIFSContext ctx = SmbFileSystemConfigBuilder.getInstance().getContext(this.getFileSystem().getFileSystemOptions());
            SmbResource file = (ctx = ctx.withCredentials((Credentials)new NtlmPasswordAuthentication(ctx, UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.DOMAIN, (char[])UserAuthenticatorUtils.toChar((String)smbFileName.getDomain()))), UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.USERNAME, (char[])UserAuthenticatorUtils.toChar((String)smbFileName.getUserName()))), UserAuthenticatorUtils.toString((char[])UserAuthenticatorUtils.getData((UserAuthenticationData)authData, (UserAuthenticationData.Type)UserAuthenticationData.PASSWORD, (char[])UserAuthenticatorUtils.toChar((String)smbFileName.getPassword())))))).get(path);
            if (file.isDirectory() && !file.toString().endsWith("/")) {
                file = ctx.get(path + "/");
            }
            smbResource = file;
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup((UserAuthenticationData)authData);
        return smbResource;
    }

    protected FileType doGetType() throws Exception {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        if (this.file.isFile()) {
            return FileType.FILE;
        }
        throw new FileSystemException("vfs.provider.smb/get-type.error", (Object)this.getName());
    }

    protected String[] doListChildren() throws Exception {
        if (!this.file.isDirectory()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        try (CloseableIterator s = this.file.children();){
            while (s.hasNext()) {
                l.add(((SmbResource)s.next()).getName());
            }
        }
        return UriParser.encode((String[])l.toArray(new String[0]));
    }

    protected boolean doIsHidden() throws Exception {
        return this.file.isHidden();
    }

    protected void doDelete() throws Exception {
        this.file.delete();
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.file.renameTo(this.createSmbFile(newfile.getName()));
    }

    protected void doCreateFolder() throws Exception {
        this.file.mkdir();
        this.file = this.createSmbFile(this.getName());
    }

    protected long doGetContentSize() throws Exception {
        return this.file.length();
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.file.lastModified();
    }

    protected InputStream doGetInputStream() throws Exception {
        try {
            return this.file.openInputStream();
        }
        catch (SmbException e) {
            if (e.getNtStatus() == -1073741809) {
                throw new FileNotFoundException((Object)this.getName());
            }
            if (this.file.isDirectory()) {
                throw new FileTypeHasNoContentException((Object)this.getName());
            }
            throw e;
        }
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return this.file.openOutputStream(bAppend);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        final SmbRandomAccess smb = this.openRandom(mode);
        return new RandomAccessContent(){

            public int skipBytes(int n) throws IOException {
                return smb.skipBytes(n);
            }

            public int readUnsignedShort() throws IOException {
                return smb.readUnsignedShort();
            }

            public int readUnsignedByte() throws IOException {
                return smb.readUnsignedByte();
            }

            public String readUTF() throws IOException {
                return smb.readUTF();
            }

            public short readShort() throws IOException {
                return smb.readShort();
            }

            public long readLong() throws IOException {
                return smb.readLong();
            }

            public String readLine() throws IOException {
                return smb.readLine();
            }

            public int readInt() throws IOException {
                return smb.readInt();
            }

            public void readFully(byte[] b, int off, int len) throws IOException {
                smb.readFully(b, off, len);
            }

            public void readFully(byte[] b) throws IOException {
                smb.readFully(b);
            }

            public float readFloat() throws IOException {
                return smb.readFloat();
            }

            public double readDouble() throws IOException {
                return smb.readDouble();
            }

            public char readChar() throws IOException {
                return smb.readChar();
            }

            public byte readByte() throws IOException {
                return smb.readByte();
            }

            public boolean readBoolean() throws IOException {
                return smb.readBoolean();
            }

            public void writeUTF(String s) throws IOException {
                smb.writeUTF(s);
            }

            public void writeShort(int v) throws IOException {
                smb.writeShort(v);
            }

            public void writeLong(long v) throws IOException {
                smb.writeLong(v);
            }

            public void writeInt(int v) throws IOException {
                smb.writeInt(v);
            }

            public void writeFloat(float v) throws IOException {
                smb.writeFloat(v);
            }

            public void writeDouble(double v) throws IOException {
                smb.writeDouble(v);
            }

            public void writeChars(String s) throws IOException {
                smb.writeChars(s);
            }

            public void writeChar(int v) throws IOException {
                smb.writeChar(v);
            }

            public void writeBytes(String s) throws IOException {
                smb.writeBytes(s);
            }

            public void writeByte(int v) throws IOException {
                smb.writeByte(v);
            }

            public void writeBoolean(boolean v) throws IOException {
                smb.writeBoolean(v);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                smb.write(b, off, len);
            }

            public void write(byte[] b) throws IOException {
                smb.write(b);
            }

            public void write(int b) throws IOException {
                smb.write(b);
            }

            public void setLength(long newLength) throws IOException {
                smb.setLength(newLength);
            }

            public void seek(long pos) throws IOException {
                smb.seek(pos);
            }

            public long length() throws IOException {
                return smb.length();
            }

            public InputStream getInputStream() throws IOException {
                throw new UnsupportedOperationException();
            }

            public long getFilePointer() throws IOException {
                return smb.getFilePointer();
            }

            public void close() throws IOException {
                smb.close();
            }
        };
    }

    private SmbRandomAccess openRandom(RandomAccessMode mode) throws CIFSException {
        switch (mode) {
            case READWRITE: {
                return this.file.openRandomAccess("rw");
            }
        }
        return this.file.openRandomAccess("r");
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.file.setLastModified(modtime);
        return true;
    }
}

