/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.smbng;

import com.sshtools.vfs.smbng.SmbFileNameParser;
import com.sshtools.vfs.smbng.SmbFileSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import jcifs.CIFSContext;
import jcifs.context.SingletonContext;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs2.provider.FileProvider;

public class SmbFileProvider
extends AbstractOriginatingFileProvider
implements FileProvider {
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD, UserAuthenticationData.DOMAIN};
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE));
    private CIFSContext context;

    public SmbFileProvider() {
        this.setFileNameParser(SmbFileNameParser.getInstance());
        this.context = SingletonContext.getInstance();
    }

    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new SmbFileSystem(name, fileSystemOptions);
    }

    public CIFSContext getCIFSContext() {
        return this.context;
    }

    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

