/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.vfs.smbng;

import java.io.IOException;
import java.io.InputStream;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbRandomAccessFile;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

class SmbFileRandomAccessContent
extends AbstractRandomAccessContent {
    private final SmbRandomAccessFile raf;
    private final InputStream rafis;

    SmbFileRandomAccessContent(SmbFile smbFile, RandomAccessMode mode) throws FileSystemException {
        super(mode);
        try {
            this.raf = new SmbRandomAccessFile(smbFile, mode.getModeString());
            this.rafis = new InputStream(){

                @Override
                public int available() throws IOException {
                    long available = SmbFileRandomAccessContent.this.raf.length() - SmbFileRandomAccessContent.this.raf.getFilePointer();
                    if (available > Integer.MAX_VALUE) {
                        return Integer.MAX_VALUE;
                    }
                    return (int)available;
                }

                @Override
                public void close() throws IOException {
                    SmbFileRandomAccessContent.this.raf.close();
                }

                @Override
                public int read() throws IOException {
                    return SmbFileRandomAccessContent.this.raf.readByte();
                }

                @Override
                public int read(byte[] b) throws IOException {
                    return SmbFileRandomAccessContent.this.raf.read(b);
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    return SmbFileRandomAccessContent.this.raf.read(b, off, len);
                }

                @Override
                public long skip(long n) throws IOException {
                    SmbFileRandomAccessContent.this.raf.seek(SmbFileRandomAccessContent.this.raf.getFilePointer() + n);
                    return n;
                }
            };
        }
        catch (SmbException e) {
            throw new FileSystemException("vfs.provider/random-access-open-failed.error", (Object)smbFile, (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.raf.close();
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public InputStream getInputStream() throws IOException {
        return this.rafis;
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public boolean readBoolean() throws IOException {
        return this.raf.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.raf.readByte();
    }

    public char readChar() throws IOException {
        return this.raf.readChar();
    }

    public double readDouble() throws IOException {
        return this.raf.readDouble();
    }

    public float readFloat() throws IOException {
        return this.raf.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        this.raf.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.raf.readFully(b, off, len);
    }

    public int readInt() throws IOException {
        return this.raf.readInt();
    }

    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    public short readShort() throws IOException {
        return this.raf.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.raf.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.raf.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        this.raf.setLength(newLength);
    }

    public int skipBytes(int n) throws IOException {
        return this.raf.skipBytes(n);
    }

    public void write(byte[] b) throws IOException {
        this.raf.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.raf.write(b);
    }

    public void writeBoolean(boolean v) throws IOException {
        this.raf.writeBoolean(v);
    }

    public void writeByte(int v) throws IOException {
        this.raf.writeByte(v);
    }

    public void writeBytes(String s) throws IOException {
        this.raf.writeBytes(s);
    }

    public void writeChar(int v) throws IOException {
        this.raf.writeChar(v);
    }

    public void writeChars(String s) throws IOException {
        this.raf.writeChars(s);
    }

    public void writeDouble(double v) throws IOException {
        this.raf.writeDouble(v);
    }

    public void writeFloat(float v) throws IOException {
        this.raf.writeFloat(v);
    }

    public void writeInt(int v) throws IOException {
        this.raf.writeInt(v);
    }

    public void writeLong(long v) throws IOException {
        this.raf.writeLong(v);
    }

    public void writeShort(int v) throws IOException {
        this.raf.writeShort(v);
    }

    public void writeUTF(String str) throws IOException {
        this.raf.writeUTF(str);
    }
}

