
package com.sta.mimages;

import java.util.Arrays;
import java.util.Vector;
import java.util.Hashtable;

import java.io.File;

import java.awt.Color;

import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;

import com.sta.mlogger.MLogger;

import com.sta.cts.UniTypeConv;
import com.sta.cts.XMLTag;
import com.sta.cts.XMLScanner;

/**
 * <p>Name: MImagesTPM</p>
 * <p>Description: Bilder fr TPM.</p>
 * <p>Copyright: Copyright (c) 2011, 2012, 2014, 2016, 2017, 2019, 2021</p>
 * <p>Company: &gt;StA-Soft&lt;</p>
 * @author StA
 * @version 1.0
 */

public class MImagesTPM extends MImages
{

  /**
   * Mapping fr groe Icons fr PL's und PLP's.
   * Key: PL- bzw. PLP-Typname
   * Value: das zugehrige groe Icon
   */

  private static Hashtable statImageIconsLarge = new Hashtable();

  /**
   * Mapping fr kleine Icons fr PL's und PLP's.
   * Key: PL- bzw. PLP-Typname
   * Value: das zugehrige kleine Icon
   */

  private static Hashtable statImageIconsSmall = new Hashtable();

  //===========================================================================

  /**
   * Allgemeine Routine um ein Icon fr PL's und PLP's zu ermitteln.
   * @param typename PL- bzw. PLP-Typname
   * @param check4large true: prfen, ob es ein groes Icon gibt und dieses
   * verwenden (falls vorhanden), false: nicht prfen, kleines Icon verwenden
   * @return das Icon, oder null, falls nicht mglich (kein Icon vorhanden)
   */

  public static ImageIcon getCellIcon4Type(String typename, boolean check4large)
  {
    ImageIcon icon = null;
    if (typename != null)
    {
      icon = (ImageIcon) (check4large ? statImageIconsLarge : statImageIconsSmall).get(typename);
      if (icon == null)
      {
        String iconname = null;
        if (typename.equals("Model") || typename.equals("Modul") || typename.equals("Table"))
        {
          iconname = "xmodels_techproc" + typename.toLowerCase();
        }
        else if (typename.equals("Cron"))
        {
          iconname = "cronentry";
        }
        else if (typename.endsWith("PL"))
        {
          iconname = "xmodels_techprocline_" + typename.replaceFirst("PL", "").toLowerCase();
        }
        else
        {
          iconname = "xmodels_techprocpart_" + typename.toLowerCase();
        }
        if (check4large)
        {
          icon = loadImageIcon("resources/icons/" + iconname + "_large.png");
          if (icon == null)
          {
            icon = loadImageIcon("../gen/source/icons/" + iconname + "_large.png");
          }
        }
        if (icon == null)
        {
          icon = loadImageIcon("resources/icons/" + iconname + ".png");
          if (icon == null)
          {
            icon = loadImageIcon("../gen/source/icons/" + iconname + ".png");
          }
        }
        (check4large ? statImageIconsLarge : statImageIconsSmall).put(typename, icon);
      }
    }
    return icon;
  }

  //===========================================================================

  // --- Globale Vorgaben ---

  /**
   * Simple-Frame-Left.
   */

  private static int statSimpleFrameLeft = 20;

  /**
   * Simple-Frame-Right.
   */

  private static int statSimpleFrameRight = 20;

  /**
   * Simple-Frame-Top.
   */

  private static int statSimpleFrameTop = 20;

  /**
   * Simple-Frame-Bottom.
   */

  private static int statSimpleFrameBottom = 20;

  /**
   * Multi-Frame-Left.
   */

  private static int statMultiFrameLeft = 20;

  /**
   * Multi-Frame-Right.
   */

  private static int statMultiFrameRight = 20;

  /**
   * Multi-Frame-Top.
   */

  private static int statMultiFrameTop = 10;

  /**
   * Multi-Frame-Bottom.
   */

  private static int statMultiFrameBottom = 10;

  /**
   * Inset-Frame-Left.
   */

  private static int statInsetFrameLeft = 10;

  /**
   * Inset-Frame-Right.
   */

  private static int statInsetFrameRight = 10;

  /**
   * Inset-Frame-Top.
   */

  private static int statInsetFrameTop = 10;

  /**
   * Inset-Frame-Bottom.
   */

  private static int statInsetFrameBottom = 10;

  /**
   * Pointer-Width.
   */

  private static int statPointerWidth = 3;

  /**
   * Pointer-Length.
   */

  private static int statPointerLength = 8;

  /**
   * Name-Gap.
   */

  private static int statNameGap = 5;

  // private static int statShadowColor = 0x808080;

  // private static int statModelFrameShadowSize = 2;
  // private static int statModulFrameShadowSize = 2;

  /**
   * Table-Frame-Shadow-Size.
   */

  private static int statTableFrameShadowSize = 2;

  /**
   * PL-Frame-Shadow-Size.
   */

  private static int statPLFrameShadowSize = 2;

  /**
   * PLP-Frame-Shadow-Size.
   */

  private static int statPLPFrameShadowSize = 2;

  // private static int statOtherFrameShadowSize = 2;
  // private static int statIconShadowSize = 2;
  // private static int statTextShadowSize = 2;
  // private static int statLineShadowSize = 2;

  /**
   * Image-Prefix.
   */

  private static String statImagePrefix = "app_";

  /**
   * Image-Type.
   */

  private static String statImageType = "PNG";

  /**
   * Expand-Assign.
   */

  private static boolean statExpandAssign = true;

  //===========================================================================

  /**
   * Basisklasse fr TPM-Images.
   */

  public static class TPMImageBase
  {

    // fields

    /**
     * X.
     */

    protected int myX = -1;

    /**
     * Y.
     */

    protected int myY = -1;

    /**
     * Size-X.
     */

    protected int mySizeX;

    /**
     * Size-Y.
     */

    protected int mySizeY;

    /**
     * Check4Large.
     */

    protected boolean check4large = true;

    // ImageBuffer

    /**
     * Image-Buffer.
     */

    protected ImageBuffer myImageBuffer = new ImageBuffer();

    // get/set

    /**
     * X ermitteln.
     * @return X
     */

    public int getX()
    {
      return myX;
    }

    /**
     * X vorgeben.
     * @param x X
     */

    public void setX(int x)
    {
      myX = x;
    }

    /**
     * Y ermitteln.
     * @return Y
     */

    public int getY()
    {
      return myY;
    }

    /**
     * Y vorgeben.
     * @param y Y
     */

    public void setY(int y)
    {
      myY = y;
    }

    /**
     * Size-X ermitteln.
     * @return Size-X
     */

    public int getSizeX()
    {
      return mySizeX;
    }

    /**
     * Size-Y ermitteln.
     * @return Size-Y
     */

    public int getSizeY()
    {
      return mySizeY;
    }

    /**
     * Image-Buffer ermitteln.
     * @return Image-Buffer
     */

    public ImageBuffer getImageBuffer()
    {
      return myImageBuffer;
    }

    /**
     * Image-Buffer zurcksetzen.
     */

    public void resImageBuffer()
    {
      myImageBuffer = null;
    }

    /**
     * Check4Large ermitteln.
     * @return Check4Large
     */

    public boolean getCheck4Large()
    {
      return check4large;
    }

    /**
     * Check4Large vorgeben.
     * @param b Check4Large
     */

    public void setCheck4Large(boolean b)
    {
      check4large = b;
    }

    // add

    // load

    /**
     * ICD berlesen.
     * @param xs XML-Scanner
     * @throws Exception im Fehlerfall
     */

    public void overreadICD(XMLScanner xs) throws Exception
    {
      XMLTag t;
      while ((t = xs.getLeafStart("info")) != null)
      {
        xs.getLeafEnd("info");
      }
      while ((t = xs.getLeafStart("comment")) != null)
      {
        xs.getLeafEnd("comment");
      }
      while ((t = xs.getLeafStart("description")) != null)
      {
        xs.getLeafEnd("description");
      }
    }

    // run

    /**
     * Schatten zeichnen.
     * @param x X
     * @param y Y
     * @param width Breite
     * @param height Hhe
     */

    protected void drawShadow(int x, int y, int width, int height)
    {
      myImageBuffer.drawShadowWH(x, y, width, height);
    }

    /**
     * Rechteck mit Schatten zeichnen.
     * @param x X
     * @param y Y
     * @param width Breite
     * @param height Hhe
     * @param shadowsize Schattengre
     */

    protected void drawRectWH(int x, int y, int width, int height, int shadowsize)
    {
      myImageBuffer.drawRectWH(x, y, width, height);
      if (shadowsize > 0)
      {
        drawShadow(x + shadowsize, y + height, width, shadowsize); // waagerecht
        drawShadow(x + width, y + shadowsize, shadowsize, height); // senkrecht
      }
    }

    /**
     * Textbreite ermitteln.
     * @param name Name
     * @param text Text
     * @return Breite
     */

    protected int getWidthX(String name, String text)
    {
      int w1 = name != null ? myImageBuffer.getWidth(name) : 0;
      int w2 = text != null ? myImageBuffer.getWidth(text) : 0;
      return Math.max(w1, w2);
    }

    /**
     * Icon + Name + Text (falls vorhanden) zeichnen.
     * @param icon Icon
     * @param iconx Icon-X
     * @param icony Icon-Y
     * @param iconwidth Icon-Breite
     * @param iconheight Icon-Hhe
     * @param name Name
     * @param text Text
     * @param text2 weiterer Text
     * @param state Status
     */

    protected void drawIconX(ImageIcon icon, int iconx, int icony, int iconwidth, int iconheight, String name, String text, String text2, Integer state)
    {
      // Icon zeichnen
      if (icon != null)
      {
        myImageBuffer.drawImage(icon.getImage(), iconx, icony);
      }
      else
      {
        myImageBuffer.drawRectWH(iconx, icony, iconwidth, iconheight);
      }
      // Text neben Icon
      try
      {
        int x = iconx + iconwidth + statNameGap;
        int y = icony;
        int fs = myImageBuffer.getFontSize();
        int lines = iconheight / fs;
        Color c = null;
        if (state != null)
        {
          if ((state == 0) || (state == 2))
          {
            // Fehler
            c = myImageBuffer.getColor();
            myImageBuffer.setColor(state == 2 ? Color.RED : Color.GREEN);
            // oder:
            int w = myImageBuffer.getWidth(name);
            myImageBuffer.fillRect(x - 2, y + 1, w + 3, fs + 3);
            myImageBuffer.setColor(c);
          }
        }
        if (name != null)
        {
          myImageBuffer.printat(x, y, name);
          y += fs;
          lines--;
        }
        if ((lines > 0) && (text != null))
        {
          myImageBuffer.printat(x, y, text);
          y += fs;
          lines--;
        }
        if ((lines > 0) && (text2 != null))
        {
          myImageBuffer.printat(x, y, text2);
          y += fs;
          lines--;
        }
      }
      catch (Exception e)
      {
      }
    }

    // save

  }

  /**
   * Basisklasse fr PL- und PLP-Images.
   */

  public static class TPMImagePLx extends TPMImageBase
  {

    // fields

    /**
     * PLP's.
     */

    protected Vector myPLPs = new Vector();

    /**
     * Ende-Icon zeichnen, falls PL.
     */

    protected boolean myDrawEndIconIfPL = true;

    // get/set

    // add

    /**
     * PLP hinzufgen.
     * @param plp PLP
     */

    public void addPLP(TPMImagePLP plp)
    {
      myPLPs.add(plp);
    }

    // load

    /**
     * Laden.
     * @param t XML-Tag
     * @param xs XML-Scanner
     * @throws Exception im Fehlerfall
     */

    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      overreadICD(xs);
      while ((t = xs.getLeafStart("plp")) != null)
      {
        TPMImagePLP tpmplp = new TPMImagePLP();
        tpmplp.load(t, xs);
        myPLPs.add(tpmplp);
        xs.getLeafEnd("plp");
      }
    }

    // run

    /**
     * Run-Methode.
     */

    public void run()
    {
      // super.run(ir);
      int plpcnt = myPLPs.size();
      for (int i = 0; i < plpcnt; i++)
      {
        ((TPMImagePLP) myPLPs.get(i)).run();
      }
    }

    /**
     * Pfeil nach oben zeichnen (x/y = Pfeilspitze).
     * @param x X
     * @param y Y
     */

    protected void drawPointerUp(int x, int y)
    {
      for (int i = 1; i <= statPointerWidth; i++)
      {
        myImageBuffer.drawLine(x - i, y + statPointerLength - 1, x, y);
        myImageBuffer.drawLine(x + i, y + statPointerLength - 1, x, y);
      }
    }

    /**
     * Pfeil nach unten zeichnen (x/y = Pfeilspitze).
     * @param x X
     * @param y Y
     */

    protected void drawPointerDown(int x, int y)
    {
      for (int i = 1; i <= statPointerWidth; i++)
      {
        myImageBuffer.drawLine(x - i, y - statPointerLength, x, y - 1);
        myImageBuffer.drawLine(x + i, y - statPointerLength, x, y - 1);
      }
    }

    /**
     * Pfeil nach rechts zeichnen (x/y = Pfeilspitze).
     * @param x Y
     * @param y Y
     */

    protected void drawPointerRight(int x, int y)
    {
      for (int i = 1; i <= statPointerWidth; i++)
      {
        myImageBuffer.drawLine(x - statPointerLength, y - i, x - 1, y);
        myImageBuffer.drawLine(x - statPointerLength, y + i, x - 1, y);
      }
    }

    /**
     * Pfeil nach links zeichnen (x/y = Pfeilspitze).
     * @param x X
     * @param y Y
     */

    protected void drawPointerLeft(int x, int y)
    {
      for (int i = 1; i <= statPointerWidth; i++)
      {
        myImageBuffer.drawLine(x + statPointerLength - 1, y - i, x, y);
        myImageBuffer.drawLine(x + statPointerLength - 1, y + i, x, y);
      }
    }

    /**
     * Verarbeitung (einfach).
     * @param typename Typname
     * @param name Name
     * @param text Text
     * @param text2 zustzlicher Text
     * @param state Status
     * @return Connect-X
     */

    protected int runSimple(String typename, String name, String text, String text2, Integer state)
    {
      MLogger.deb(" PLP(simple): " + typename + "/" + name);
      if (myPLPs.size() != 0)
      {
        MLogger.wrn("There are PLP's under a leaf PLP (" + typename + ": " + name + ").");
      }
      ImageIcon icon = getCellIcon4Type(typename, check4large);
      int iconwidth = icon != null ? icon.getIconWidth() : 16;
      int iconheight = icon != null ? icon.getIconHeight() : 16;
      int textwidth = getWidthX(name, text);
      mySizeX = statSimpleFrameLeft + iconwidth + statNameGap + textwidth + statSimpleFrameRight;
      mySizeY = statSimpleFrameTop + iconheight + statSimpleFrameBottom;
      myImageBuffer.newImage(mySizeX, mySizeY, new Color(255, 255, 255, 255));
      drawIconX(icon, statSimpleFrameLeft, statSimpleFrameTop, iconwidth, iconheight, name, text, text2, state);
      int locConnectX = statSimpleFrameLeft + iconwidth / 2;
      myImageBuffer.drawLine(locConnectX, 0, locConnectX, statSimpleFrameTop - 1);
      drawPointerDown(locConnectX, statSimpleFrameTop);
      myImageBuffer.drawLine(locConnectX, statSimpleFrameTop + iconheight, locConnectX, mySizeY);
      return locConnectX;
    }

    /**
     * Delta.
     */

    private int addsizescnt = 4;

    /**
     * Vertikale Gre ermitteln.
     * @param pConnectX Connect-X
     * @param addSizeX Add-Size-X
     * @param addPositionsY Add-Positions-Y
     * @return neues Connect-X
     */

    protected int calcSizeVertical(int pConnectX, int[] addSizeX, int[] addPositionsY)
    {
      int[] addSizesX = new int[addsizescnt];
      int[] addSizesY = new int[addsizescnt];
      for (int i = 0; i < addsizescnt; i++)
      {
        addSizesX[i] = 0;
        addSizesY[i] = 0;
        addPositionsY[i] = 0;
      }
      boolean drawplp = false;
      boolean addplp = false;
      int plpcnt = myPLPs.size();
      /*
      if (plpcnt > 0)
      {
        // mySizeY++;
      }
      */
      for (int i = 0; i < plpcnt; i++)
      {
        TPMImagePLP plp = (TPMImagePLP) myPLPs.get(i);
        int sizex = plp.getSizeX();
        int sizey = plp.getSizeY();
        int conx = plp.getConnectX();
        int cony = plp.getConnectY();
        if (cony == -1)
        {
          // Normalfall, untereinander
          if (conx > pConnectX)
          {
            mySizeX += conx - pConnectX;
            pConnectX = conx;
          }
          if (mySizeX < pConnectX + (sizex - conx))
          {
            mySizeX = pConnectX + (sizex - conx);
          }
          mySizeY += sizey;
          drawplp = true;
        }
        else
        {
          // Sonderfall, rechts daneben
          if (cony < addsizescnt - 1)
          {
            addSizesX[cony] += sizex;
            if (sizey > addSizesY[cony])
            {
              addSizesY[cony] = sizey;
            }
          }
          else
          {
            if (sizex > addSizesX[addsizescnt - 1])
            {
              addSizesX[addsizescnt - 1] = sizex;
            }
            addSizesY[addsizescnt - 1] += sizey + statMultiFrameBottom;
          }
          addplp = true;
        }
      }
      /*
      if (drawplp)
      {
        // mySizeY++;
      }
      else
      */
      if (!drawplp)
      {
        mySizeY += statInsetFrameTop + statInsetFrameBottom;
      }
      addSizeX[0] = 0; // x
      if (addplp)
      {
        int addSizeY = 3 * statMultiFrameTop; // y
        for (int i = 0; i < addsizescnt; i++)
        {
          addPositionsY[i] = addSizeY;
          if (addSizesX[i] > addSizeX[0])
          {
            addSizeX[0] = addSizesX[i];
          }
          if (addSizesY[i] > 0)
          {
            addSizeY += addSizesY[i];
            addSizeY += 3 * statMultiFrameBottom;
          }
        }
        if (addSizeY > mySizeY)
        {
          mySizeY = addSizeY;
        }
        if (addSizeX[0] > statMultiFrameRight)
        {
          addSizeX[0] -= statMultiFrameRight;
        }
      }
      return pConnectX;
    }

    /**
     * PLP's vertikal zeichnen.
     * @param pConnectX Connect-X
     * @param y Y
     * @param addpositionsy Add-Positions-Y
     * @param isPL PL
     * @return neues Y
     */

    protected int drawPLPsVertical(int pConnectX, int y, int[] addpositionsy, boolean isPL)
    {
      int[] addpositionsx = new int[addsizescnt];
      for (int i = 0; i < addsizescnt; i++)
      {
        addpositionsx[i] = 0;
      }
      boolean drawplp = false;
      int plpcnt = myPLPs.size();
      /*
      if (plpcnt > 0)
      {
        // y++;
      }
      */
      for (int i = 0; i < plpcnt; i++)
      {
        TPMImagePLP plp = (TPMImagePLP) myPLPs.get(i);
        int cony = plp.getConnectY();
        if (cony == -1)
        {
          myImageBuffer.drawImageBuffer(plp.getImageBuffer(), pConnectX - plp.getConnectX(), y);
          String type = plp.getPLPType();
          if (isPL && ("PreEP".equals(type) || "EP".equals(type) || "PreMain".equals(type) || "Main".equals(type) || "PstMain".equals(type) || "CR".equals(type) || "PstCR".equals(type)))
          {
            // Rahmen nach links ausweiten
            int x1 = statMultiFrameLeft + statInsetFrameLeft + statMultiFrameLeft;
            int x2 = pConnectX - plp.getConnectX() + statMultiFrameLeft;
            if (x2 > x1)
            {
              int y1 = y + statMultiFrameTop;
              int y2 = y + plp.getSizeY() - statMultiFrameBottom - 1;
              Color c = myImageBuffer.getColor();
              myImageBuffer.setColor(Color.WHITE);
              myImageBuffer.drawLine(x2, y1, x2, y2); // alte senkrechte Linie lschen
              myImageBuffer.setColor(c);
              myImageBuffer.drawLine(x1, y1, x2, y1); // obere Linie
              myImageBuffer.drawLine(x1, y1, x1, y2); // neue senkrechte Linie
              // ib.drawLine(x1, y2, x2, y2); // untere Linie
              drawRectWH(x1, y2, x2 - x1 + 1, 1, statPLFrameShadowSize); // untere Linie
              int subimgwidth = plp.getConnectX() - statMultiFrameLeft - statInsetFrameLeft;
              int subimgheight = getCellIcon4Type("BasePL", check4large).getIconHeight();
              // ???
              // BufferedImage subimg = plp.getImage().getSubimage(statMultiFrameLeft + statInsetFrameLeft, statMultiFrameTop + statInsetFrameTop, subimgwidth, subimgheight);
              // myImageBuffer.drawImage(subimg, x1 + statInsetFrameLeft, y1 + statInsetFrameTop);
              myImageBuffer.copyImageWH(pConnectX - plp.getConnectX() + statMultiFrameLeft + statInsetFrameLeft, y + statMultiFrameTop + statInsetFrameTop, subimgwidth, subimgheight, x1 + statInsetFrameLeft, y1 + statInsetFrameTop);
              int fillimgx = x1 + statInsetFrameLeft + subimgwidth;
              int fillimgy = y1 + statInsetFrameTop;
              myImageBuffer.setColor(Color.WHITE);
              myImageBuffer.fillRect(fillimgx, fillimgy, pConnectX - fillimgx, subimgheight);
              myImageBuffer.setColor(c);
            }
          }
          plp.resImageBuffer();
          y += plp.getSizeY();
          drawplp = true;
        }
        else
        {
          // Sonderfall, rechts daneben
          if (cony < addsizescnt - 1)
          {
            int xx = mySizeX - statMultiFrameRight + addpositionsx[cony];
            int yy = addpositionsy[cony];
            myImageBuffer.drawImageBuffer(plp.getImageBuffer(), xx, yy);
            plp.resImageBuffer();
            int dx = plp.getSizeX();
            myImageBuffer.drawLine(xx, yy - 1, xx + dx, yy - 1);
            int xx2 = xx + plp.getConnectX();
            int yy2 = addpositionsy[cony + 1] - 2 * statMultiFrameBottom;
            myImageBuffer.drawLine(xx, yy2, xx + dx, yy2);
            myImageBuffer.drawLine(xx2, yy + plp.getSizeY(), xx2, yy2);
            drawPointerDown(xx + plp.getConnectX(), yy2);
            addpositionsx[cony] += dx;
          }
          else
          {
            myImageBuffer.drawImageBuffer(plp.getImageBuffer(), mySizeX - statMultiFrameRight + addpositionsx[addsizescnt - 1], addpositionsy[addsizescnt - 1]);
            plp.resImageBuffer();
            addpositionsy[addsizescnt - 1] += plp.getSizeY() + statMultiFrameBottom;
          }
        }
      }
      /*
      if (drawplp)
      {
        // y++;
      }
      else
      */
      if (!drawplp)
      {
        int ye = y + statInsetFrameTop + statInsetFrameBottom;
        myImageBuffer.drawLine(pConnectX, y, pConnectX, ye);
        y = ye;
      }
      return y;
    }

    /**
     * Mehrfach vertikal.
     * @param typename Typname
     * @param name Name
     * @param text Text
     * @param text2 zustzlicher Text
     * @param state Status
     * @param isIconLeft falls Icon links
     * @param isPL falls PL
     * @param isPointerAboveIcon falls Pfeil ber Icon
     * @param isLineUnderIcon falls Linie unter Icon
     * @param isPointerFromLeft falls Pfeil von links
     * @return Connect-X
     */

    protected int runMultiVertical(String typename, String name, String text, String text2, Integer state, boolean isIconLeft, boolean isPL, boolean isPointerAboveIcon, boolean isLineUnderIcon, boolean isPointerFromLeft)
    {
      // Konsistenzprfung
      if (!isIconLeft && isPL)
      {
        MLogger.wrn("Invalid flag combination (*).");
      }
      if (isIconLeft && (isPointerAboveIcon || isLineUnderIcon || isPointerFromLeft))
      {
        MLogger.wrn("Invalid flag combination (**).");
      }
      if (isPointerAboveIcon && isPointerFromLeft)
      {
        MLogger.wrn("Invalid flag combination (***).");
      }
      // Master-Icon ermitteln
      ImageIcon icon = getCellIcon4Type(typename, check4large);
      int iconwidth = icon != null ? icon.getIconWidth() : 16;
      int iconheight = icon != null ? icon.getIconHeight() : 16;
      int textwidth = getWidthX(name, text);
      // PL-Start- und PL-End-Icon ermitteln, falls ntig
      ImageIcon starticon = isPL ? getCellIcon4Type("StartPL", check4large) : null;
      int starticonwidth = starticon != null ? starticon.getIconWidth() : 16;
      int starticonheight = starticon != null ? starticon.getIconHeight() : 16;
      ImageIcon endicon = isPL ? getCellIcon4Type("EndPL", check4large) : null;
      int endiconwidth = endicon != null ? endicon.getIconWidth() : 16;
      int endiconheight = endicon != null ? endicon.getIconHeight() : 16;
      // Startwerte
      mySizeX = iconwidth + statNameGap + textwidth + statNameGap + (isPL ? Math.max(starticonwidth, endiconwidth) : 0);
      int locConnectX = isIconLeft ? iconwidth + statNameGap + textwidth + statNameGap + (isPL ? Math.max(starticonwidth / 2, endiconwidth / 2) : 0) : iconwidth / 2;
      mySizeY = (isIconLeft ? statMultiFrameTop + statInsetFrameTop + (isPL ? Math.max(iconheight, starticonheight) : iconheight) /* + statInsetFrameBottom */ :
                              (isPointerAboveIcon ? statMultiFrameTop + statInsetFrameTop : 0) + iconheight + (isLineUnderIcon ? statInsetFrameBottom : 0));
      int yy = mySizeY;
      // Gre der untergeordneten PLP's ermitteln und daraus locConnectX berechnen, dabei die Bildgre korrigieren
      int[] addsizex = new int[1];
      int[] addpositionsy = new int[addsizescnt];
      locConnectX = calcSizeVertical(locConnectX, addsizex, addpositionsy);
      // Gre korrigieren
      mySizeX += statMultiFrameLeft + statInsetFrameLeft + statInsetFrameRight + statMultiFrameRight;
      mySizeY += (isPL ? 2 * statInsetFrameBottom + endiconheight + statInsetFrameBottom : 0) + statMultiFrameBottom + (isPointerFromLeft ? 2 * statMultiFrameBottom : 0);
      locConnectX += statMultiFrameLeft + statInsetFrameLeft;
      // Bild erzeugen
      myImageBuffer.newImage(mySizeX + addsizex[0], mySizeY);
      // Icon-Position berechnen
      int iconx = isIconLeft ? statMultiFrameLeft + statInsetFrameLeft : locConnectX - iconwidth / 2;
      int icony = isIconLeft ? statMultiFrameTop + statInsetFrameTop : isPointerAboveIcon ? statMultiFrameTop + statInsetFrameTop : 0;
      // Icon(s) zeichnen
      drawIconX(icon, iconx, icony, iconwidth, iconheight, name, text, text2, state);
      if (isPL)
      {
        int starticonx = locConnectX - starticonwidth / 2;
        int starticony = statMultiFrameTop + statInsetFrameTop;
        if (starticon != null)
        {
          myImageBuffer.drawImage(starticon.getImage(), starticonx, starticony);
        }
        else
        {
          myImageBuffer.drawRectWH(starticonx, starticony, starticonwidth, starticonheight);
        }
        int endiconx = locConnectX - endiconwidth / 2;
        int endicony = mySizeY - statMultiFrameBottom - statInsetFrameBottom - endiconheight;
        if (endicon != null)
        {
          if (myDrawEndIconIfPL)
          {
            myImageBuffer.drawImage(endicon.getImage(), endiconx, endicony);
          }
        }
        else
        {
          myImageBuffer.drawRectWH(endiconx, endicony, endiconwidth, endiconheight);
        }
      }
      // Pfeil(e) und Verbindung(en) oben zeichnen
      if (isIconLeft)
      {
        myImageBuffer.drawLine(locConnectX, isPL ? statMultiFrameTop + statInsetFrameTop + starticonheight : 0, locConnectX, yy);
      }
      else
      {
        if (isPointerAboveIcon)
        {
          myImageBuffer.drawLine(locConnectX, 0, locConnectX, statMultiFrameTop + statInsetFrameTop - 1);
          drawPointerDown(locConnectX, statMultiFrameTop + statInsetFrameTop);
        }
        if (isPointerFromLeft)
        {
          int yp = icony + iconheight / 2;
          myImageBuffer.drawLine(0, yp, iconx - 1, yp);
          drawPointerRight(iconx, yp);
        }
        if (isLineUnderIcon)
        {
          myImageBuffer.drawLine(locConnectX, (isPointerAboveIcon ? statMultiFrameTop + statInsetFrameTop : 0) + iconheight, locConnectX, yy);
        }
      }
      // Untergeordnete PLP's zeichnen
      yy = drawPLPsVertical(locConnectX, yy, addpositionsy, isPL);
      // Pfeil(e) und Verbindung(en) unten zeichnen
      if (isPL)
      {
        int endy = mySizeY - statMultiFrameBottom - statInsetFrameBottom - endiconheight; // = endicony
        myImageBuffer.drawLine(locConnectX, yy, locConnectX, endy - 1);
        if (myDrawEndIconIfPL)
        {
          drawPointerDown(locConnectX, endy);
        }
      }
      else
      {
        myImageBuffer.drawLine(locConnectX, yy, locConnectX, mySizeY - (isPointerFromLeft ? statMultiFrameBottom : 0));
      }
      // Rahmen
      if (isIconLeft)
      {
        // Rahmen um alles
        drawRectWH(statMultiFrameLeft, statMultiFrameTop, mySizeX - statMultiFrameLeft - statMultiFrameRight, mySizeY - statMultiFrameTop - statMultiFrameBottom, isPL ? statPLFrameShadowSize : statPLPFrameShadowSize);
      }
      else
      {
        if (!isLineUnderIcon)
        {
          // Rahmen um PLP's, falls direkt am Icon
          myImageBuffer.drawRectWH(statMultiFrameLeft, icony + iconheight, mySizeX - statMultiFrameLeft - statMultiFrameRight, mySizeY - (isPointerFromLeft ? 2 * statMultiFrameBottom : 0) - icony - iconheight - statMultiFrameBottom);
        }
        else
        {
          myImageBuffer.drawRectWH(statMultiFrameLeft,
                                   icony + iconheight + statInsetFrameTop,
                                   mySizeX - statMultiFrameLeft - statMultiFrameRight,
                                   mySizeY - (isPointerFromLeft ? 2 * statMultiFrameBottom : 0) - icony - iconheight - statInsetFrameTop - statMultiFrameBottom);
        }
        if (isPointerFromLeft)
        {
          myImageBuffer.drawLine(0, mySizeY - statMultiFrameBottom, locConnectX, mySizeY - statMultiFrameBottom);
          drawPointerLeft(0, mySizeY - statMultiFrameBottom);
        }
      }
      // Ergebnis
      mySizeX += addsizex[0];
      return locConnectX;
    }

    /**
     * Mehrfach horizontal.
     * @param typename Typname
     * @param name Name
     * @param text Text
     * @param text2 zustzlicher Text
     * @param state Status
     * @return Connect-X
     */

    protected int runMultiHorizontal(String typename, String name, String text, String text2, Integer state)
    {
      // Startwerte
      ImageIcon icon = getCellIcon4Type(typename, check4large);
      int iconwidth = icon != null ? icon.getIconWidth() : 16;
      int iconheight = icon != null ? icon.getIconHeight() : 16;
      int textwidth = getWidthX(name, text);
      mySizeX = iconwidth + statNameGap + textwidth + statNameGap;
      mySizeY = statSimpleFrameTop + /* statInsetFrameTop + */ iconheight /* + statInsetFrameBottom*/;
      int locConnectX = iconwidth / 2; // mySizeX;
      int width = 0;
      mySizeY++; // waagerechte Linie
      int y = mySizeY;
      // Gre berechnen
      int plpcnt = myPLPs.size();
      for (int i = 0; i < plpcnt; i++)
      {
        TPMImagePLP plp = (TPMImagePLP) myPLPs.get(i);
        int sizex = plp.getSizeX();
        int sizey = plp.getSizeY();
        // int conx = plp.getConnectX();
        int cony = plp.getConnectY();
        if (cony == -1)
        {
          // Normalfall, untereinander
          width += sizex;
          if (y + sizey > mySizeY)
          {
            mySizeY = y + sizey;
          }
        }
        /*
        else
        {
          // Sonderfall, rechts daneben
        }
        */
      }
      if (width / 2 > locConnectX)
      {
        mySizeX += width / 2 - locConnectX;
        locConnectX = width / 2;
      }
      if (width > mySizeX)
      {
        mySizeX = width;
      }
      // Gre korrigieren
      mySizeX += statSimpleFrameLeft + statInsetFrameLeft + statInsetFrameRight + statSimpleFrameRight;
      mySizeY += (plpcnt > 0 ? statInsetFrameBottom : 0) + statSimpleFrameBottom;
      locConnectX += statSimpleFrameLeft + statInsetFrameLeft;
      // Bild erzeugen
      myImageBuffer.newImage(mySizeX, mySizeY);
      myImageBuffer.drawLine(locConnectX, 0, locConnectX, statSimpleFrameTop);
      drawPointerDown(locConnectX, statSimpleFrameTop);
      drawIconX(icon, locConnectX - iconwidth / 2, statSimpleFrameTop, iconwidth, iconheight, name, text, text2, state);
      myImageBuffer.drawLine(statSimpleFrameLeft, y - 1, statSimpleFrameLeft + statInsetFrameLeft + width + statInsetFrameRight, y - 1);
      int x = statSimpleFrameLeft + statInsetFrameLeft;
      for (int i = 0; i < plpcnt; i++)
      {
        TPMImagePLP plp = (TPMImagePLP) myPLPs.get(i);
        myImageBuffer.drawImageBuffer(plp.getImageBuffer(), x, y);
        plp.resImageBuffer();
        myImageBuffer.drawLine(x + plp.getConnectX(), y + plp.getSizeY(), x + plp.getConnectX(), mySizeY - statSimpleFrameBottom);
        drawPointerDown(x + plp.getConnectX(), mySizeY - statSimpleFrameBottom);
        x += plp.getSizeX();
      }
      y = mySizeY - statSimpleFrameBottom;
      myImageBuffer.drawLine(statSimpleFrameLeft, y, statSimpleFrameLeft + statInsetFrameLeft + width + statInsetFrameRight, y);
      myImageBuffer.drawLine(locConnectX, y, locConnectX, mySizeY);
      return locConnectX;
    }

    // save

    /**
     * Bild(er) speichern.
     * @param dst Ziel
     * @throws Exception im Exception
     */

    public void save(String dst) throws Exception
    {
      // super.save(dst, ir);
      int plpcnt = myPLPs.size();
      for (int i = 0; i < plpcnt; i++)
      {
        ((TPMImagePLP) myPLPs.get(i)).save(dst);
      }
    }

  }

  /**
   * PLP-Images.
   */

  public static class TPMImagePLP extends TPMImagePLx
  {

    // fields

    /**
     * PLP-Type.
     */

    protected String myPLPType;

    /**
     * PLP-Name.
     */

    protected String myPLPName;

    /**
     * PLP-Super.
     */

    protected String myPLPSuper;

    /**
     * Text.
     */

    protected String myText;

    /**
     * Zustzlicher Text.
     */

    protected String myText2;

    /**
     * Status.
     */

    protected Integer myState;

    /**
     * Connect-X.
     */

    protected int myConnectX = -1;

    /**
     * Connect-Y.
     */

    protected int myConnectY = -1;

    // constructors

    /**
     * Standard-Constructor.
     */

    public TPMImagePLP()
    {
    }

    /**
     * Constructor mit diversen Werten.
     * @param plptype PLP-Type
     * @param plpname PLP-Name
     * @param plpsuper PLP-Super
     * @param state Status
     */

    public TPMImagePLP(String plptype, String plpname, String plpsuper, Integer state)
    {
      myPLPType = plptype;
      myPLPName = plpname;
      myPLPSuper = plpsuper;
      myState = state;
    }

    /**
     * Constructor mit diversen Werten.
     * @param plptype PLP-Type
     * @param plpname PLP-Name
     * @param plpsuper PLP-Super
     * @param text Text
     * @param text2 zustzlicher Text
     * @param state Status
     */

    public TPMImagePLP(String plptype, String plpname, String plpsuper, String text, String text2, Integer state)
    {
      myPLPType = plptype;
      myPLPName = plpname;
      myPLPSuper = plpsuper;
      myText = text;
      myText2 = text2;
      myState = state;
    }

    // get/set

    /**
     * PLP-Type ermitteln.
     * @return PLP-Type
     */

    public String getPLPType()
    {
      return myPLPType;
    }

    /**
     * PLP-Name ermitteln.
     * @return PLP-Name
     */

    public String getPLPName()
    {
      return myPLPName;
    }

    /**
     * PLP-Super ermitteln.
     * @return PLP-Super
     */

    public String getPLPSuper()
    {
      return myPLPSuper;
    }

    /**
     * Connect-X ermitteln.
     * @return Connect-X
     */

    public int getConnectX()
    {
      return myConnectX;
    }

    /**
     * Connect-Y ermitteln.
     * @return Connect-Y
     */

    public int getConnectY()
    {
      return myConnectY;
    }

    // add

    // load

    @Override
    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      myPLPType = t.getAttr("plptype");
      myPLPName = t.getAttr("plpname");
      myState = UniTypeConv.convString2Int(t.getAttr("plpstate"));
      super.load(t, xs);
    }

    // helper

    /**
     * Prfen, ob das aktuelle PLP in Typ-Menge enthalten ist.
     * @param typenames Typ-Menge
     * @return true: ja, false: nein
     */

    protected boolean isPLPTypeIn(String... typenames)
    {
      for (int i = 0; i < typenames.length; i++)
      {
        if (typenames[i].equals(myPLPType))
        {
          return true;
        }
      }
      return false;
    }

    // run

    @Override
    public void run()
    {
      super.run();
      if ((!statExpandAssign && "Assign".equals(myPLPType)) ||
           isPLPTypeIn(/* "Assign", */ "AssignAdd", "AssignCopy", "AssignMove", "AssignRemove", "AssignLoad", "AssignSave", "BeanShell", "Call", "Empty", "HumanTask", "Invoke", "Java", "Receive", "Reply", "Terminate", "Throw", "Transform", "Wait"))
      {
        myConnectX = runSimple(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState);
      }
      else if ((statExpandAssign && "Assign".equals(myPLPType)) || isPLPTypeIn(/* "Assign", */ "PreEP", "EP", "PreMain", "Main", "PstMain", "CR", "PstCR", "Scope", "Sequence"))
      {
        myConnectX = runMultiVertical(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState, true, false, false, false, false);
      }
      else if (isPLPTypeIn("Case", "Otherwise"))
      {
        myConnectX = runMultiVertical(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState, false, false, false, true, false);
      }
      else if (isPLPTypeIn("ForEach", "While"))
      {
        myConnectX = runMultiVertical(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState, false, false, true, false, false);
      }
      else if (isPLPTypeIn("Catch", "CatchAll"))
      {
        myConnectX = runMultiVertical(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState, false, false, true, true, false);
        myConnectY = 2; // irgendwas != -1
      }
      else if (isPLPTypeIn("Finally"))
      {
        myConnectX = runMultiVertical(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState, false, false, false, true, true);
        myConnectY = 3; // irgendwas != -1
      }
      else if (isPLPTypeIn("Switch", "Flow"))
      {
        myConnectX = runMultiHorizontal(myPLPType, myPLPName + (myPLPSuper != null ? " (" + myPLPSuper + ")" : ""), myText, myText2, myState);
      }
      else
      {
        MLogger.deb(" PLP(unknown): " + myPLPType + "/" + myPLPName);
      }
    }

    // save

    @Override
    public void save(String dst) throws Exception
    {
      super.save(dst);
    }

  }

  /**
   * PL-Images.
   */

  public static class TPMImagePL extends TPMImagePLx
  {

    // fields

    /**
     * PL-Type.
     */

    protected String myPLType;

    /**
     * PL-Name.
     */

    protected String myPLName;

    /**
     * PL-Super.
     */

    protected String myPLSuper;

    /**
     * PL-Base-Name.
     */

    protected String myPLBaseName;

    /**
     * Text.
     */

    protected String myText;

    /**
     * Zustzlicher Text.
     */

    protected String myText2;

    /**
     * Status.
     */

    protected Integer myState;

    // get/set

    /**
     * Draw-End-Icon vorgeben.
     * @param b Draw-End-Icon
     */

    public void setDrawEndIcon(boolean b)
    {
      myDrawEndIconIfPL = b;
    }

    // constructors

    /**
     * Standard-Constructor.
     */

    public TPMImagePL()
    {
    }

    /**
     * Constructor mit diversen Werten.
     * @param pltype PL-Type
     * @param plname PL-Name
     * @param plsuper PL-Super
     * @param plbasename PL-Base-Name
     * @param state Status
     */

    public TPMImagePL(String pltype, String plname, String plsuper, String plbasename, Integer state)
    {
      myPLType = pltype;
      myPLName = plname;
      myPLSuper = plsuper;
      myPLBaseName = plbasename;
      myState = state;
    }

    /**
     * Constructor mit diversen Werten.
     * @param pltype PL-Type
     * @param plname PL-Name
     * @param plsuper PL-Super
     * @param plbasename PL-Base-Name
     * @param text Text
     * @param text2 zustzlicher Text
     * @param state Status
     */

    public TPMImagePL(String pltype, String plname, String plsuper, String plbasename, String text, String text2, Integer state)
    {
      myPLType = pltype;
      myPLName = plname;
      myPLSuper = plsuper;
      myPLBaseName = plbasename;
      myText = text;
      myText2 = text2;
      myState = state;
    }

    // get/set

    /**
     * PL-Type ermitteln.
     * @return PL-Type
     */

    public String getPLType()
    {
      return myPLType;
    }

    /**
     * PL-Name ermitteln.
     * @return PL-Name
     */

    public String getPLName()
    {
      return myPLName;
    }

    // add

    // load

    @Override
    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      myPLType = t.getAttr("pltype");
      myPLName = t.getAttr("plname");
      myPLSuper = t.getAttr("plsuper");
      myPLBaseName = t.getAttr("plbasename");
      myState = UniTypeConv.convString2Int(t.getAttr("plstate"));
      super.load(t, xs);
    }

    // run

    /**
     * PLP hinzufgen.
     * @param i Index
     * @param pPLPType PLP-Type
     * @param state Status
     */

    private void addPLP(int i, String pPLPType, Integer state)
    {
      TPMImagePLP plp = new TPMImagePLP(pPLPType, myPLBaseName + ("Main".equals(pPLPType) ? "" : pPLPType), null, state);
      myPLPs.add(i, plp);
    }

    @Override
    public void run()
    {
      if ("BasePL".equals(myPLType) && (myPLSuper == null))
      {
        boolean hasEP = false;
        boolean hasMain = false;
        boolean hasCR = false;
        int plpcnt = myPLPs.size();
        for (int i = 0; i < plpcnt; i++)
        {
          TPMImagePLP plp = (TPMImagePLP) myPLPs.get(i);
          String plptype = plp.getPLPType();
          if ("EP".equals(plptype))
          {
            hasEP = true;
          }
          else if (!hasEP && !"PreEP".equals(plptype))
          {
            addPLP(i, "EP", null);
            hasEP = true;
            plpcnt++;
            i++;
          }
          if ("Main".equals(plptype))
          {
            hasMain = true;
          }
          else if (!hasMain && ("PstMain".equals(plptype) || "PreCR".equals(plptype) || "CR".equals(plptype) || "PstCR".equals(plptype)))
          {
            addPLP(i, "Main", null);
            hasMain = true;
            plpcnt++;
            i++;
          }
          if ("CR".equals(plptype))
          {
            hasCR = true;
          }
          else if (!hasCR && "PstCR".equals(plptype))
          {
            addPLP(i, "CR", null);
            hasCR = true;
            plpcnt++;
            i++;
          }
        }
        if (!hasEP)
        {
          addPLP(plpcnt, "EP", null);
          plpcnt++;
        }
        if (!hasMain)
        {
          addPLP(plpcnt, "Main", null);
          plpcnt++;
        }
        if (!hasCR)
        {
          addPLP(plpcnt, "CR", null);
          plpcnt++;
        }
      }
      super.run();
      // runMultiVertical(ir, myPLType, myPLName + (myPLSuper != null ? "(" + myPLSuper + ")" : ""), myText, myText2, true, true, false, false, false);
      runMultiVertical(myPLType, myPLName, myPLSuper != null ? "(" + myPLSuper + ")" : myText, myText2, myState, true, true, false, false, false);
    }

    // save

    @Override
    public void save(String dst) throws Exception
    {
      String name = myPLName.toLowerCase();
      super.save(dst);
      if (myImageBuffer != null)
      {
        ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), myImageBuffer.getImage());
        resImageBuffer();
      }
    }

  }

  /**
   * Table-Images.
   */

  public static class TPMImageTable extends TPMImageBase
  {

    // fields

    /**
     * Table-Name.
     */

    protected String myTableName;

    /**
     * PL's.
     */

    protected Vector myPLs = new Vector();

    // constructors

    /**
     * Standard-Constructor.
     */

    public TPMImageTable()
    {
    }

    /**
     * Constructor mit Table-Name.
     * @param tablename Table-Name
     */

    public TPMImageTable(String tablename)
    {
      myTableName = tablename;
    }

    // get/set

    /**
     * Table-Name ermitteln.
     * @return Table-Name
     */

    public String getTableName()
    {
      return myTableName;
    }

    // add

    /**
     * PL hinzufgen.
     * @param pl PL
     */

    public void addPL(TPMImagePL pl)
    {
      myPLs.add(pl);
    }

    // load

    /**
     * Laden.
     * @param t XML-Tag
     * @param xs XML-Scanner
     * @throws Exception im Fehlerfall
     */

    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      myTableName = t.getAttr("tablename");
      overreadICD(xs);
      while ((t = xs.getLeafStart("pl")) != null)
      {
        String pltype = t.getAttr("pltype");
        TPMImagePL tpmpl = new TPMImagePL();
        tpmpl.load(t, xs);
        if (!"DelPL".equals(pltype))
        {
          myPLs.add(tpmpl);
        }
        xs.getLeafEnd("pl");
      }
    }

    // run

    /**
     * Run-Methode.
     * @param genimg Bild erzeugen ja/nein
     * @param onlythisimg nur dieses Bild (ja/nein)
     */

    public void run(boolean genimg, boolean onlythisimg)
    {
      MLogger.deb("Table: " + myTableName);
      // super.run(ir);
      int plcnt = myPLs.size();
      for (int i = 0; i < plcnt; i++)
      {
        // parallel?
        ((TPMImagePL) myPLs.get(i)).run();
      }
      if (genimg)
      {
        //
        // Das Bild fr eine technische Tabelle wird wie folgt zusammengebaut:
        //
        // (a)
        //
        // * Alle PL's vom Typ BasePL und DelPL werden ganz oben nebeneinander angeordnet
        // * Alle weiteren PL's werden darunter bis zur Breite der BasePL's/DelPL's bzw. bis zu 2000 (?) Pixeln (Maximum aus beiden) angeordnet
        // * Falls eine PL alleine breiter ist als die zuvor angenommene Breite, wird die Breite dieser PL weiterverwendet
        //
        // (b)
        //
        // * Es werden alle PL's unabhngig vom Typ bis zu einer Breite von 2000 (?) Pixeln angeordnet
        // * Falls eine PL alleine breiter ist als die zuvor angenommene Breite, wird die Breite dieser PL weiterverwendet
        //
        // Startwerte
        ImageIcon icon = getCellIcon4Type("Table", check4large);
        int iconwidth = icon != null ? icon.getIconWidth() : 16;
        int iconheight = icon != null ? icon.getIconHeight() : 16;
        int textwidth = getWidthX(myTableName, null);
        mySizeX = iconwidth + statNameGap + textwidth;
        mySizeY = statMultiFrameTop + statInsetFrameTop + iconheight /* + statInsetFrameTop */;
        int y0 = mySizeY;
        int sizex0 = 0;
        int sizey0 = 0;
        for (int i = 0; i < plcnt; i++)
        {
          TPMImagePL pl = (TPMImagePL) myPLs.get(i);
          ImageBuffer img = pl.getImageBuffer();
          if (img != null)
          {
            int sizex = pl.getSizeX();
            int sizey = pl.getSizeY();
            String pltype = pl.getPLType();
            if ("BasePL".equals(pltype) || "DelPL".equals(pltype))
            {
              sizex0 += sizex;
              if (sizey > sizey0)
              {
                sizey0 = sizey;
              }
              if (sizex0 > mySizeX)
              {
                mySizeX = sizex0;
              }
              if (y0 + sizey0 > mySizeY)
              {
                mySizeY = y0 + sizey0;
              }
            }
            else
            {
              if (sizex > mySizeX)
              {
                mySizeX = sizex;
              }
              mySizeY += sizey;
            }
          }
        }
        // Korrektur
        mySizeX += statMultiFrameLeft + statInsetFrameLeft + statInsetFrameRight + statMultiFrameRight;
        mySizeY += statInsetFrameBottom + statMultiFrameBottom;
        // Bild erzeugen
        myImageBuffer.newImage(mySizeX, mySizeY);
        // Icon
        int x = statMultiFrameLeft + statInsetFrameLeft;
        int y = statMultiFrameTop + statInsetFrameTop;
        drawIconX(icon, x, y, iconwidth, iconheight, myTableName, null, null, null);
        y += iconheight /* + statInsetFrameTop */;
        int x0 = x;
        y0 = y;
        for (int i = 0; i < plcnt; i++)
        {
          TPMImagePL pl = (TPMImagePL) myPLs.get(i);
          ImageBuffer img = pl.getImageBuffer();
          if (img != null)
          {
            String pltype = pl.getPLType();
            if ("BasePL".equals(pltype) || "DelPL".equals(pltype))
            {
              myImageBuffer.drawImageBuffer(pl.getImageBuffer(), x0, y0);
              x0 += pl.getSizeX();
              if (y0 + pl.getSizeY() > y)
              {
                y = y0 + pl.getSizeY();
              }
            }
            else
            {
              myImageBuffer.drawImageBuffer(pl.getImageBuffer(), x, y);
              y += pl.getSizeY();
            }
            if (onlythisimg)
            {
              pl.resImageBuffer();
            }
          }
        }
        // Rahmen
        drawRectWH(statMultiFrameLeft, statMultiFrameTop, mySizeX - statMultiFrameLeft - statMultiFrameRight, mySizeY - statMultiFrameTop - statMultiFrameBottom, statTableFrameShadowSize);
        // Ergebnis
      }
    }

    // save

    /**
     * Bild(er) speichern.
     * @param dst Ziel
     * @throws Exception im Fehlerfall
     */

    public void save(String dst) throws Exception
    {
      MLogger.deb("Table: " + myTableName);
      String name = myTableName.toLowerCase();
      // super.save(dst, ir);
      int plcnt = myPLs.size();
      for (int i = 0; i < plcnt; i++)
      {
        ((TPMImagePL) myPLs.get(i)).save(dst);
      }
      BufferedImage img = myImageBuffer.getImage();
      if (img != null)
      {
        MLogger.deb("Table: " + myTableName + " (*)");
        ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), img);
        resImageBuffer();
      }
    }
  }

  /**
   * Basisklasse fr Modul- und Model-Images.
   */

  public static class TPMImageModBase extends TPMImageBase
  {

    // fields

    /**
     * Module.
     */

    protected Vector myModuls = new Vector();

    /**
     * Tabellen.
     */

    protected Vector myTables = new Vector();

    /**
     * PL's.
     */

    protected Vector myPLs = new Vector();

    // filter

    /**
     * Filter.
     * @param params Parameter
     */

    public void filter(Vector params)
    {
      if ((params != null) && (params.size() > 0))
      {
        String name = getNextParam(params);
        if (name != null)
        {
          boolean neg = false;
          if (name.startsWith("!"))
          {
            neg = true;
            name = name.substring(1);
          }
          int mcnt = myModuls.size();
          for (int i = 0; i < mcnt; i++)
          {
            TPMImageModul modul = (TPMImageModul) myModuls.get(i);
            String mname = modul.getModulName();
            if ((!neg && name.equals(mname)) ||
                (neg && !name.equals(mname)))
            {
              modul.filter(params);
            }
            else
            {
              myModuls.remove(i);
              i--;
              mcnt--;
            }
          }
          int tcnt = myTables.size();
          for (int i = 0; i < tcnt; i++)
          {
            TPMImageTable table = (TPMImageTable) myTables.get(i);
            String tname = table.getTableName();
            /*
            if ((!neg && name.equals(tname)) || (neg && !name.equals(tname)))
            {
              // table.filter(params);
            }
            else
            */
            if (!((!neg && name.equals(tname)) || (neg && !name.equals(tname))))
            {
              myTables.remove(i);
              i--;
              tcnt--;
            }
          }
          int plcnt = myPLs.size();
          for (int i = 0; i < plcnt; i++)
          {
            TPMImagePL pl = (TPMImagePL) myPLs.get(i);
            String plname = pl.getPLName();
            /*
            if ((!neg && name.equals(plname)) || (neg && !name.equals(plname)))
            {
              // pl.filter(params);
            }
            else
            */
            if (!((!neg && name.equals(plname)) || (neg && !name.equals(plname))))
            {
              myPLs.remove(i);
              i--;
              plcnt--;
            }
          }
        }
      }
    }

    // get/set

    // add

    /**
     * Modul hinzufgen.
     * @param modul Modul
     */

    public void addModul(TPMImageModul modul)
    {
      myModuls.add(modul);
    }

    /**
     * Table hinzufgen.
     * @param table Table
     */

    public void addTable(TPMImageTable table)
    {
      myTables.add(table);
    }

    /**
     * PL hinzufgen.
     * @param pl PL
     */

    public void addPL(TPMImagePL pl)
    {
      myPLs.add(pl);
    }

    // load

    /**
     * Laden.
     * @param t XML-Tag
     * @param xs XML-Scanner
     * @throws Exception im Fehlerfall
     */

    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      overreadICD(xs);
      while ((t = xs.getLeafStart("modul")) != null)
      {
        String modulop = t.getAttr("modulop");
        TPMImageModul tpmmodul = new TPMImageModul();
        tpmmodul.load(t, xs);
        if (!"del".equals(modulop))
        {
          myModuls.add(tpmmodul);
        }
        xs.getLeafEnd("modul");
      }
      while ((t = xs.getLeafStart("table")) != null)
      {
        String tableop = t.getAttr("tableop");
        TPMImageTable tpmtable = new TPMImageTable();
        tpmtable.load(t, xs);
        if (!"del".equals(tableop))
        {
          myTables.add(tpmtable);
        }
        xs.getLeafEnd("table");
      }
      while ((t = xs.getLeafStart("pl")) != null)
      {
        String pltype = t.getAttr("pltype");
        TPMImagePL tpmpl = new TPMImagePL();
        tpmpl.load(t, xs);
        if (!"DelPL".equals(pltype))
        {
          myPLs.add(tpmpl);
        }
        xs.getLeafEnd("pl");
      }
    }

    // run

    /**
     * Run-Methode.
     * @param genimg Bild erzeugen ja/nein
     * @param onlythisimg nur dieses Bild (ja/nein)
     * @param name Name
     */

    public void run(boolean genimg, boolean onlythisimg, String name)
    {
      // super.run(ir);
      int mcnt = myModuls.size();
      for (int i = 0; i < mcnt; i++)
      {
        // parallel?
        ((TPMImageModul) myModuls.get(i)).run(genimg, onlythisimg);
      }
      int tcnt = myTables.size();
      for (int i = 0; i < tcnt; i++)
      {
        // parallel?
        ((TPMImageTable) myTables.get(i)).run(genimg, onlythisimg);
      }
      int plcnt = myPLs.size();
      for (int i = 0; i < plcnt; i++)
      {
        // parallel?
        ((TPMImagePL) myPLs.get(i)).run();
      }
      if (genimg)
      {
        // Startwerte
        ImageIcon icon = getCellIcon4Type(this instanceof TPMImageModel ? "Model" : "Modul", check4large);
        int iconwidth = icon != null ? icon.getIconWidth() : 16;
        int iconheight = icon != null ? icon.getIconHeight() : 16;
        int textwidth = getWidthX(name, null);
        mySizeX = iconwidth + statNameGap + textwidth;
        mySizeY = statMultiFrameTop + statInsetFrameTop + iconheight /* + statInsetFrameTop */;
        for (int i = 0; i < mcnt; i++)
        {
          TPMImageModul modul = (TPMImageModul) myModuls.get(i);
          ImageBuffer img = modul.getImageBuffer();
          if (img != null)
          {
            int sizex = modul.getSizeX();
            int sizey = modul.getSizeY();
            if (sizex > mySizeX)
            {
              mySizeX = sizex;
            }
            mySizeY += sizey;
          }
        }
        for (int i = 0; i < tcnt; i++)
        {
          TPMImageTable table = (TPMImageTable) myTables.get(i);
          ImageBuffer img = table.getImageBuffer();
          if (img != null)
          {
            int sizex = table.getSizeX();
            int sizey = table.getSizeY();
            if (sizex > mySizeX)
            {
              mySizeX = sizex;
            }
            mySizeY += sizey;
          }
        }
        for (int i = 0; i < plcnt; i++)
        {
          TPMImagePL pl = (TPMImagePL) myPLs.get(i);
          ImageBuffer img = pl.getImageBuffer();
          if (img != null)
          {
            int sizex = pl.getSizeX();
            int sizey = pl.getSizeY();
            if (sizex > mySizeX)
            {
              mySizeX = sizex;
            }
            mySizeY += sizey;
          }
        }
        // Korrektur
        mySizeX += statMultiFrameLeft + statInsetFrameLeft + statInsetFrameRight + statMultiFrameRight;
        mySizeY += statInsetFrameBottom + statMultiFrameBottom;
        // Bild erzeugen
        myImageBuffer.newImage(mySizeX, mySizeY);
        // Icon
        int x = statMultiFrameLeft + statInsetFrameLeft;
        int y = statMultiFrameTop + statInsetFrameTop;
        drawIconX(icon, x, y, iconwidth, iconheight, name, null, null, null);
        y += iconheight /* + statInsetFrameTop */;
        for (int i = 0; i < mcnt; i++)
        {
          TPMImageModul modul = (TPMImageModul) myModuls.get(i);
          ImageBuffer img = modul.getImageBuffer();
          if (img != null)
          {
            myImageBuffer.drawImageBuffer(modul.getImageBuffer(), x, y);
            if (onlythisimg)
            {
              modul.resImageBuffer();
            }
            y += modul.getSizeY();
          }
        }
        for (int i = 0; i < tcnt; i++)
        {
          TPMImageTable table = (TPMImageTable) myTables.get(i);
          ImageBuffer img = table.getImageBuffer();
          if (img != null)
          {
            myImageBuffer.drawImageBuffer(table.getImageBuffer(), x, y);
            if (onlythisimg)
            {
              table.resImageBuffer();
            }
            y += table.getSizeY();
          }
        }
        for (int i = 0; i < plcnt; i++)
        {
          TPMImagePL pl = (TPMImagePL) myPLs.get(i);
          ImageBuffer img = pl.getImageBuffer();
          if (img != null)
          {
            myImageBuffer.drawImageBuffer(pl.getImageBuffer(), x, y);
            if (onlythisimg)
            {
              pl.resImageBuffer();
            }
            y += pl.getSizeY();
          }
        }
        // Rahmen
        drawRectWH(statMultiFrameLeft, statMultiFrameTop, mySizeX - statMultiFrameLeft - statMultiFrameRight, mySizeY - statMultiFrameTop - statMultiFrameBottom, statTableFrameShadowSize);
        // Ergebnis
      }
    }

    // save

    /**
     * Bild(er) speichern.
     * @param dst Ziel
     * @throws Exception im Fehlerfall
     */

    public void save(String dst) throws Exception
    {
      // super.save(dst, ir);
      int mcnt = myModuls.size();
      for (int i = 0; i < mcnt; i++)
      {
        ((TPMImageModul) myModuls.get(i)).save(dst);
      }
      int tcnt = myTables.size();
      for (int i = 0; i < tcnt; i++)
      {
        ((TPMImageTable) myTables.get(i)).save(dst);
      }
      int plcnt = myPLs.size();
      for (int i = 0; i < plcnt; i++)
      {
        ((TPMImagePL) myPLs.get(i)).save(dst);
      }
    }
  }

  /**
   * Modul-Images.
   */

  public static class TPMImageModul extends TPMImageModBase
  {

    // fields

    /**
     * Modulname.
     */

    protected String myModulName;

    // constructors

    /**
     * Standard-Constructor.
     */

    public TPMImageModul()
    {
    }

    /**
     * Constructor mit Modulname.
     * @param modulname Modulname
     */

    public TPMImageModul(String modulname)
    {
      myModulName = modulname;
    }

    // get/set

    /**
     * Modulname ermitteln.
     * @return Modulname
     */

    public String getModulName()
    {
      return myModulName;
    }

    // add

    // load

    @Override
    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      myModulName = t.getAttr("modulname");
      super.load(t, xs);
    }

    // run

    /**
     * Run-Methode.
     * @param genimg Bild erzeugen ja/nein
     * @param onlythisimg nur dieses Bild (ja/nein)
     */

    public void run(boolean genimg, boolean onlythisimg)
    {
      MLogger.deb("Modul: " + myModulName);
      super.run(genimg, onlythisimg, myModulName);
    }

    // save

    @Override
    public void save(String dst) throws Exception
    {
      String name = myModulName.toLowerCase();
      String dir = dst + File.separator + name;
      new File(dir).mkdirs();
      MLogger.deb("Modul: " + myModulName + " --> " + dir);
      super.save(dir);
      BufferedImage img = myImageBuffer.getImage();
      if (img != null)
      {
        MLogger.deb("Modul: " + myModulName + " (*)");
        ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), img);
        resImageBuffer();
      }
    }

  }

  /**
   * Model-Images.
   */

  public static class TPMImageModel extends TPMImageModBase
  {

    // fields

    /**
     * Modellname.
     */

    protected String myModelName;

    // constructors

    /**
     * Standard-Constructor.
     */

    public TPMImageModel()
    {
    }

    /**
     * Constructor mit Modellname.
     * @param modelname Modellname
     */

    public TPMImageModel(String modelname)
    {
      myModelName = modelname;
    }

    // get/set

    /**
     * Modellname ermitteln.
     * @return Modellname
     */

    public String getModelName()
    {
      return myModelName;
    }

    // add

    // load

    @Override
    public void load(XMLTag t, XMLScanner xs) throws Exception
    {
      myModelName = t.getAttr("techprocmodelname");
      super.load(t, xs);
    }

    // run

    /**
     * Run-Methode.
     * @param genimg Bild erzeugen ja/nein
     * @param onlythisimg nur dieses Bild (ja/nein)
     */

    public void run(boolean genimg, boolean onlythisimg)
    {
      MLogger.deb("Model: " + myModelName);
      super.run(genimg, onlythisimg, myModelName);
    }

    // save

    @Override
    public void save(String dst) throws Exception
    {
      String name = myModelName.toLowerCase();
      String dir = dst + File.separator + name;
      new File(dir).mkdirs();
      MLogger.deb("Model: " + myModelName + " --> " + dir);
      super.save(dir);
      BufferedImage img = myImageBuffer.getImage();
      if (img != null)
      {
        MLogger.deb("Model: " + myModelName + " (*)");
        ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), img);
        resImageBuffer();
      }
    }

  }


  //===========================================================================

  /**
   * Liste der gelesenen und zu verarbeitenden Modelle (PDM's).
   */

  private static Vector statTPMImageModels = new Vector();

  /**
   * Projektname.
   */

  private static String statPrjName;

  //===========================================================================

  /**
   * XML-Datei lesen und Struktur der bentigten Daten im Speicher aufbauen.
   * @param fn Name der Quell-XML-Datei
   * @throws Exception im Fehlerfall
   */

  public static void load(String fn) throws Exception
  {
    XMLScanner xs = new XMLScanner();
    xs.init(fn);
    try
    {
      xs.initH(null);
      XMLTag t;
      t = xs.getLeafStart("root");
      if (t == null)
      {
        throw new Exception("Missing <root>.");
      }
      statPrjName = t.getAttr("prjname");
      MLogger.deb("Project: " + statPrjName);
      while ((t = xs.getLeafStart("model")) != null)
      {
        TPMImageModel tpmmodel = new TPMImageModel();
        tpmmodel.load(t, xs);
        statTPMImageModels.add(tpmmodel);
        t = xs.getLeafEnd("model");
        if (t == null)
        {
          throw new Exception("Missing </model>.");
        }
      }
      t = xs.getLeafEnd("root");
      if (t == null)
      {
        throw new Exception("Missing </root>.");
      }
    }
    finally
    {
      xs.done();
    }
  }
/*
  public static void initIR(ImageRenderer ir)
  {
    ir.setAntialiasing(false);
    ir.setBorderBottom(0);
    ir.setBorderLeft(0);
    ir.setBorderRight(0);
    ir.setBorderTop(0);
    ir.setFontName("Arial");
    ir.setFontSize(12);
    ir.setFontStyleIndex(1);
    ir.setImageTypeIndex(2);
    // ir.setImageType(BufferedImage.TYPE_INT_RGB);
  }
*/
  /**
   * Run-Methode zum Erzeugen der Bilder.
   * @throws Exception im Fehlerfall
   */

  public static void run() throws Exception
  {
    int mcnt = statTPMImageModels.size();
    for (int i = 0; i < mcnt; i++)
    {
      // parallel?
      TPMImageModel tpmmodel = (TPMImageModel) statTPMImageModels.get(i);
      tpmmodel.run(false, false);
    }
  }

  /**
   * Save-Methode zum Speichern der Bilder.
   * @param dst Ziel-Basispfad fr erzeugte Bilder
   * @param pre Prfix fr Bilddateinamen, z. B. "tpm_"
   * @throws Exception im Fehlerfall
   */

  public static void save(String dst, String pre) throws Exception
  {
    if (pre != null)
    {
      statImagePrefix = pre;
    }
    int mcnt = statTPMImageModels.size();
    for (int i = 0; i < mcnt; i++)
    {
      TPMImageModel tpmmodel = (TPMImageModel) statTPMImageModels.get(i);
      tpmmodel.save(dst);
    }
  }

  //===========================================================================

  /**
   * Spezielle Run-Methode.
   * @param fn Name der Quell-XML-Datei
   * @param dst Ziel-Basispfad fr erzeugte Bilder
   * @param pre Prfix fr Bilddateinamen, z. B. "tpm_"
   * @param params ggf. noch zustzliche Parameter
   * @throws Exception im Fehlerfall
   */

  public static void run(String fn, String dst, String pre, Vector params) throws Exception
  {
    MLogger.deb("***** load *****");
    load(fn);
    if ((params != null) && (params.size() > 0))
    {
      MLogger.deb("***** filter *****");
      int mcnt = statTPMImageModels.size();
      for (int i = 0; i < mcnt; i++)
      {
        TPMImageModel tpmmodel = (TPMImageModel) statTPMImageModels.get(i);
        tpmmodel.filter(params);
      }
    }
    MLogger.deb("***** run *****");
    run();
    MLogger.deb("***** save *****");
    save(dst, pre);
    MLogger.deb("***** ok *****");
  }

  /**
   * Spezielle Run-Methode.
   * @param fn Name der Quell-XML-Datei
   * @param dst Ziel-Basispfad fr erzeugte Bilder
   * @param pre Prfix fr Bilddateinamen, z. B. "tpm_"
   * @throws Exception im Fehlerfall
   */

  public static void run(String fn, String dst, String pre) throws Exception
  {
    run(fn, dst, pre, null);
  }

  /**
   * Expand-Assign prfen.
   * @param params Parameter-Vector
   */

  protected static void checkExpandAssign(Vector params)
  {
    String s = getNextParam(params);
    if ("-expandassign".equals(s))
    {
      statExpandAssign = false;
    }
    else if (s != null)
    {
      params.add(0, s);
    }
  }

  /**
   * Zentrale Run-Methode, mit Fehlerbehandlung.
   * @param params Kommandozeilenargumente
   */

  public static void run(Vector params)
  {
    String fn = getNextParam(params);
    if (fn == null)
    {
      MLogger.err("Missing file name.");
      return;
    }
    String dst = getNextParam(params);
    if (dst == null)
    {
      dst = ".";
    }
    if (dst.endsWith("/") || dst.endsWith("\\"))
    {
      dst = dst.substring(0, dst.length() - 1);
    }
    String pre = getNextParam(params);
    try
    {
      checkExpandAssign(params);
      run(fn, dst, pre, params);
    }
    catch (Exception e)
    {
      MLogger.err("While processing: " + e.getMessage(), e);
    }
  }

  /**
   * Main-Methode.
   * @param args Kommandozeilenargumente
   */

  public static void main(String[] args)
  {
    MLogger.msg("MImagesTPM  Version " + VERSION + "  Copyright (c) " + COPYRIGHT + " " + COMPANY);
    Vector params = new Vector(Arrays.asList(args));
    checkLogLevel(params);
    run(params);
    System.exit(0);
  }

}
