
package com.sta.mimages;

import java.util.Iterator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.BufferedOutputStream;

import java.awt.image.SampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;

import javax.imageio.ImageIO;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriter;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageTypeSpecifier;

import javax.imageio.metadata.IIOMetadata;

import javax.imageio.stream.ImageOutputStream;

import com.sun.media.imageio.plugins.tiff.TIFFTag;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageWriter;

import org.w3c.dom.Node;

import com.sta.mlogger.MLogger;

/**
 * <p>Name: OldImageHandler</p>
 * <p>Description: Alte Variante, Bilder zu speichern.
 *
 * Verwendet wird ein Bibliotheks-Mix aus ImageIO-Varianten und ehemals sogar noch
 * JAI. Gedacht war (ist) dies speziell dafr, TIF-Bilder in einem konkreten
 * Format zu speichern.
 *
 * </p>
 * <p>Copyright: Copyright (c) 2014, 2016-2019, 2021</p>
 * <p>Company: &gt;StA-Soft&lt;</p>
 * @author StA
 * @version 1.0
 */

public class OldImageHandler
{

  /**
   * Keine Ahnung was das soll, ist aber auf jeden Fall sehr, sehr notwendig.
   * @param ifd Node
   * @param type int
   * @param num long
   * @param den long
   */

  private static void ifdAppendRational(Node ifd, int type, long num, long den)
  {
    TIFFTagSet tagSet = BaselineTIFFTagSet.getInstance();
    TIFFTag tag = tagSet.getTag(type);
    long[][] arr = new long[1][];
    arr[0] = new long[2];
    arr[0][0] = num;
    arr[0][1] = den;
    TIFFField field = new TIFFField(tag, TIFFTag.TIFF_RATIONAL, 1, arr);
    ifd.appendChild(field.getAsNativeNode());
  }

  /**
   * Schreibt ein Bild in dem angegebenen Format in den Stream.<br>
   * Fr TIFF erfolgt eine Spezialbehandlung: bei Schwarzweibildern wird
   * als Ausgabeformat CCITT T.6 (group 4 Fax) und fr Farbbilder PackBits
   * eingestellt.
   * @param ri das Bild
   * @param os der Ausgabestrom
   * @param format das Ausgabeformat, z.B. 'jpeg' oder 'tiff'
   * @param resolution Auflsung in DPI
   * @throws IOException falls kein passender Encoder gefunden wird oder ein E/A-Fehler auftritt
   */

  private static void writeImageToStream(RenderedImage ri, OutputStream os, String format, int resolution) throws IOException
  {

    ImageWriter iw;
    Iterator writers;
    if (format.toLowerCase().startsWith("image/"))
    {
      writers = ImageIO.getImageWritersByMIMEType(format);
    }
    else
    {
      writers = ImageIO.getImageWritersByFormatName(format);
    }
    if (writers.hasNext())
    {
      iw = (ImageWriter) writers.next();
    }
    else if ("tiff".equalsIgnoreCase(format))
    {
      MLogger.deb("Special ImageWriter for TIFF.");
      iw = new TIFFImageWriter(null);
    }
    else
    {
      throw new IOException("No image writer found to encode format '" + format + "'.");
    }

    // Sonderbehandlung fr schwarzweie Bilder
    if (ri instanceof BufferedImage)
    {
      if (BufferedImage.TYPE_BYTE_BINARY == ((BufferedImage) ri).getType())
      {
        SampleModel sm = ri.getSampleModel();
        if ((sm.getNumBands() > 1) || (sm.getSampleSize(0) > 1))
        {
          MLogger.wrn("???");
          // ri = convertToBlackWhite(ri); //Konvertierung in Schwarzweiss
        }
      }
    }
    ImageWriteParam iwp = iw.getDefaultWriteParam();
    if ("tiff".equalsIgnoreCase(format))
    {

      // Ausgabeformat setzen. Weiterfuehrende Informationen zu den
      // Ausgabeformaten des TIFF-Codec findet man unter:
      // http://java.sun.com/products/java-media/jai/forDevelopers/jai-imageio-1_0-rc-docs/com/sun/media/imageio/plugins/tiff/TIFFImageWriteParam.html
      iwp.setCompressionMode(ImageWriteParam.MODE_EXPLICIT);

      // Komprimierung unterschiedlich je nach Farbtiefe
      SampleModel sm = ri.getSampleModel();
      if (sm.getNumBands() == 1 && sm.getSampleSize(0) == 1)
      {
        MLogger.deb("CCITT T.6");
        iwp.setCompressionType("CCITT T.6");  //CCITT T.6 bilevel encoding/Group 4 facsimile compression
      }
      else
      {
        MLogger.deb("PackBits");
        iwp.setCompressionType("PackBits");
      }
    }

    // spezielles Imageformat erzeugen
    IIOMetadata meta = iw.getDefaultImageMetadata(new ImageTypeSpecifier(ri), iwp);

    // neu...
    if ("tiff" .equals(format))
    {
      String nmfn = meta.getNativeMetadataFormatName();
      Node root = meta.getAsTree(nmfn);
      Node ifd = root.getChildNodes().item(0);
      int xdpi = resolution;
      int ydpi = resolution;
      ifdAppendRational(ifd, BaselineTIFFTagSet.TAG_X_RESOLUTION, xdpi, 1);
      ifdAppendRational(ifd, BaselineTIFFTagSet.TAG_Y_RESOLUTION, ydpi, 1);
      try
      {
        meta.mergeTree(nmfn, root);
      }
      catch (Exception e)
      {
        throw new RuntimeException("Unable to merge tree.");
      }
    }
    // ...neu

    IIOImage iioimg = new IIOImage(ri, null, meta);

    // Ausgabe des Writers setzen
    ImageOutputStream ios = ImageIO.createImageOutputStream(os);
    iw.setOutput(ios);

    // Finaler Schritt: ins Zielformat schreiben
    iw.write(null, iioimg, iwp);
    iw.dispose();
    ios.close();

  }

//---

  /**
   * Bild speichern.
   * @param fn Dateiname
   * @param img das Bild
   * @param resolution Auflsung in DPI
   * @throws Exception im Fehlerfall
   */

  public static void saveImage(String fn, BufferedImage img, int resolution) throws Exception
  {
    String aFN = fn.toUpperCase();
    // wird nur noch fr TIF(F) aufgerufen, trotzdem eine Sicherheitsprfung
    if (!aFN.endsWith(".TIF") && !aFN.endsWith(".TIFF") && !aFN.endsWith(".GIF") && !aFN.endsWith(".PNG")) // kein TIF(F)
    {
      throw new Exception("Invalid file type: " + fn);
    }
    else // TIF(F)
    {
      //
      // ImageIO
      //
      OutputStream os = new BufferedOutputStream(new FileOutputStream(fn));
      try
      {
        String s = "Save image (" + img.getWidth() + "/" + img.getHeight() + ") to " + fn;
        try
        {
          MLogger.deb(s + "...");
          writeImageToStream(img, os, aFN.endsWith(".GIF") ? "gif" : aFN.endsWith(".PNG") ? "png" : "tiff", resolution);
          MLogger.deb(s + ": Ok.");
        }
        catch (Exception e)
        {
          MLogger.err(s + ": Error.", e);
          throw e;
        }
      }
      finally
      {
        os.close();
      }
    }
  }

  //===========================================================================

  /**
   * Dummy-Constructor.
   */

  protected OldImageHandler()
  {
  }

}
