/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.mimages.ImageRenderer;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Vector;

public class ImageBuffer {
    private Vector<Operation> myOperations = new Vector();
    private int mySizeX;
    private int mySizeY;
    private Color myColor = new Color(0, 0, 0, 255);
    private int myFontSize = 12;
    private FontMetrics myFM = null;

    public void newImage(int sizex, int sizey) {
        this.mySizeX = sizex;
        this.mySizeY = sizey;
    }

    public void newImage(int sizex, int sizey, Color c) {
        this.mySizeX = sizex;
        this.mySizeY = sizey;
        this.setBackground(c);
        this.clearRect(0, 0, sizex, sizey);
    }

    public void setColor(Color c) {
        this.myOperations.add(new OpSetColor(c));
        this.myColor = c;
    }

    public Color getColor() {
        return this.myColor;
    }

    public void setBackground(Color c) {
        this.myOperations.add(new OpSetBackground(c));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.myOperations.add(new OpDrawLine(x1, y1, x2, y2));
    }

    public void drawRectWH(int x, int y, int width, int height) {
        this.myOperations.add(new OpDrawRectWH(x, y, width, height));
    }

    public void fillRect(int x, int y, int dx, int dy) {
        this.myOperations.add(new OpFillRect(x, y, dx, dy));
    }

    public void clearRect(int x, int y, int dx, int dy) {
        this.myOperations.add(new OpClearRect(x, y, dx, dy));
    }

    public void drawPolygon(int[] xx, int[] yy, int n) {
        this.myOperations.add(new OpDrawPolygon(xx, yy, n));
    }

    public void fillPolygon(int[] xx, int[] yy, int n) {
        this.myOperations.add(new OpFillPolygon(xx, yy, n));
    }

    public void drawOval(int x, int y, int dx, int dy) {
        this.myOperations.add(new OpDrawOval(x, y, dx, dy));
    }

    public void fillOval(int x, int y, int dx, int dy) {
        this.myOperations.add(new OpFillOval(x, y, dx, dy));
    }

    public void drawImage(Image img, int x, int y) {
        this.myOperations.add(new OpDrawImage(img, x, y));
    }

    public void drawImageCenter(Image img, int x, int y, int dx, int dy) {
        this.myOperations.add(new OpDrawImageCenter(img, x, y, dx, dy));
    }

    public void drawImageZoom(Image img, int x, int y, int dx, int dy) {
        this.myOperations.add(new OpDrawImageZoom(img, x, y, dx, dy));
    }

    public void drawImageBuffer(ImageBuffer ib, int x, int y) {
        this.myOperations.add(new OpDrawImageBuffer(ib, x, y));
    }

    public void copyImage(int x1, int y1, int x2, int y2, int x, int y) {
        this.myOperations.add(new OpCopyImage(x1, y1, x2, y2, x, y));
    }

    public void copyImageWH(int x1, int y1, int w, int h, int x, int y) {
        this.myOperations.add(new OpCopyImage(x1, y1, x1 + w, y1 + h, x, y));
    }

    public void printat(int x, int y, String text) {
        this.myOperations.add(new OpPrintAt(x, y, text));
    }

    public void drawShadowWH(int x, int y, int width, int height) {
        this.myOperations.add(new OpDrawShadowWH(x, y, width, height));
    }

    public int getFontSize() {
        return this.myFontSize;
    }

    public int getWidth(String text) {
        if (this.myFM == null) {
            BufferedImage bi = new BufferedImage(10, 10, 2);
            Graphics2D myG2D = (Graphics2D)bi.getGraphics();
            Font font = new Font("Arial", 1, this.myFontSize);
            myG2D.setFont(font);
            this.myFM = myG2D.getFontMetrics();
        }
        return this.myFM.stringWidth(text);
    }

    public int getHeight() {
        if (this.myFM == null) {
            BufferedImage bi = new BufferedImage(10, 10, 2);
            Graphics2D myG2D = (Graphics2D)bi.getGraphics();
            Font font = new Font("Arial", 1, this.myFontSize);
            myG2D.setFont(font);
            this.myFM = myG2D.getFontMetrics();
        }
        return this.myFM.getHeight();
    }

    protected void renderImage(ImageRenderer ir, int x, int y) {
        for (Operation op : this.myOperations) {
            op.draw(ir, x, y);
        }
    }

    public BufferedImage getImage(int imagetype) {
        ImageRenderer ir = new ImageRenderer();
        ir.setAntialiasing(false);
        ir.setBorderBottom(0);
        ir.setBorderLeft(0);
        ir.setBorderRight(0);
        ir.setBorderTop(0);
        ir.setFontName("Arial");
        ir.setFontSize(12);
        ir.setFontStyleIndex(1);
        ir.setImageType(imagetype);
        ir.resetImage();
        ir.setImageWidth(this.mySizeX);
        ir.setImageHeight(this.mySizeY);
        this.renderImage(ir, 0, 0);
        BufferedImage bi = ir.getImage();
        return bi;
    }

    public BufferedImage getImage() {
        return this.getImage(1);
    }

    public static void main(String[] args) {
        ImageBuffer ib1 = new ImageBuffer();
        ib1.newImage(200, 100, new Color(255, 255, 255, 255));
        ib1.drawLine(0, 0, 199, 0);
        ib1.drawLine(0, 0, 0, 99);
        ib1.drawLine(0, 99, 199, 99);
        ib1.drawLine(199, 0, 199, 99);
        ib1.drawLine(20, 10, 180, 80);
        ImageBuffer ib2 = new ImageBuffer();
        ib2.newImage(200, 100, new Color(255, 255, 255, 255));
        ib2.drawLine(0, 0, 199, 0);
        ib2.drawLine(0, 0, 0, 99);
        ib2.drawLine(0, 99, 199, 99);
        ib2.drawLine(199, 0, 199, 99);
        ib2.drawLine(180, 10, 20, 80);
        ImageBuffer ib3 = new ImageBuffer();
        ib3.newImage(200, 100, new Color(255, 0, 0, 255));
        ib3.drawLine(0, 0, 199, 0);
        ib3.drawLine(0, 0, 0, 99);
        ib3.drawLine(0, 99, 199, 99);
        ib3.drawLine(199, 0, 199, 99);
        ib3.drawLine(20, 10, 180, 80);
        ib3.drawLine(180, 10, 20, 80);
        ImageBuffer ib4 = new ImageBuffer();
        ib4.newImage(200, 100);
        ib4.setColor(new Color(0, 255, 0, 128));
        ib4.fillRect(0, 0, 200, 100);
        ib4.setColor(new Color(0, 0, 0, 255));
        ib4.drawLine(0, 0, 199, 0);
        ib4.drawLine(0, 0, 0, 99);
        ib4.drawLine(0, 99, 199, 99);
        ib4.drawLine(199, 0, 199, 99);
        ib4.drawLine(20, 10, 180, 80);
        ib4.drawLine(180, 10, 20, 80);
        ImageBuffer ib = new ImageBuffer();
        ib.newImage(2000, 1000, new Color(255, 255, 255, 255));
        ib.drawLine(0, 0, 1999, 0);
        ib.drawLine(0, 0, 0, 999);
        ib.drawLine(0, 999, 1999, 999);
        ib.drawLine(1999, 0, 1999, 999);
        ib.drawImageBuffer(ib1, 100, 100);
        ib.drawImageBuffer(ib2, 400, 100);
        ib.drawImageBuffer(ib3, 250, 300);
        ib.drawImageBuffer(ib4, 350, 350);
        BufferedImage bi = ib.getImage();
        try {
            ImageRenderer.saveImage("test.png", bi);
        }
        catch (Exception ex) {
            MLogger.err((String)"", (Throwable)ex);
        }
    }

    public class OpDrawShadowWH
    extends Operation {
        private int myShadowColor;
        private int myX;
        private int myY;
        private int myW;
        private int myH;

        public OpDrawShadowWH(int x, int y, int w, int h) {
            this.myShadowColor = 0x808080;
            this.myX = x;
            this.myY = y;
            this.myW = w;
            this.myH = h;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            BufferedImage img = ir.getImage();
            int[] rgbArray = img.getRGB(x + this.myX, y + this.myY, this.myW, this.myH, null, 0, this.myW);
            for (int i = 0; i < rgbArray.length; ++i) {
                int rgb = rgbArray[i];
                if ((rgb & 0xFFFFFF) != 0xFFFFFF) continue;
                rgbArray[i] = rgb & 0xFF000000 | this.myShadowColor;
            }
            img.setRGB(x + this.myX, y + this.myY, this.myW, this.myH, rgbArray, 0, this.myW);
        }
    }

    public class OpPrintAt
    extends Operation {
        private int myX;
        private int myY;
        private String myText;

        public OpPrintAt(int x, int y, String text) {
            this.myX = x;
            this.myY = y;
            this.myText = text;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.setCurX(x + this.myX);
            ir.setCurY(y + this.myY);
            try {
                ir.print(this.myText);
            }
            catch (Exception ex) {
                MLogger.err((String)"", (Throwable)ex);
            }
        }
    }

    public class OpCopyImage
    extends Operation {
        private int myX1;
        private int myY1;
        private int myX2;
        private int myY2;
        private int myX;
        private int myY;

        public OpCopyImage(int x1, int y1, int x2, int y2, int x, int y) {
            this.myX1 = x1;
            this.myY1 = y1;
            this.myX2 = x2;
            this.myY2 = y2;
            this.myX = x;
            this.myY = y;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            BufferedImage img = ir.getImage();
            int w = this.myX2 - this.myX1;
            int h = this.myY2 - this.myY1;
            int[] ia = img.getRGB(x + this.myX1, y + this.myY1, w, h, null, 0, w);
            img.setRGB(x + this.myX, y + this.myY, w, h, ia, 0, w);
        }
    }

    public class OpDrawImageBuffer
    extends Operation {
        private int myX;
        private int myY;
        private ImageBuffer myImageBuffer;

        public OpDrawImageBuffer(ImageBuffer ib, int x, int y) {
            this.myX = x;
            this.myY = y;
            this.myImageBuffer = ib;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            this.myImageBuffer.renderImage(ir, x + this.myX, y + this.myY);
        }
    }

    public class OpDrawImageZoom
    extends Operation {
        private int myX;
        private int myY;
        private int myDX;
        private int myDY;
        private Image myImage;

        public OpDrawImageZoom(Image img, int x, int y, int dx, int dy) {
            this.myX = x;
            this.myY = y;
            this.myDX = dx;
            this.myDY = dy;
            this.myImage = img;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.drawImageZoom(this.myImage, x + this.myX, y + this.myY, this.myDX, this.myDY);
        }
    }

    public class OpDrawImageCenter
    extends Operation {
        private int myX;
        private int myY;
        private int myDX;
        private int myDY;
        private Image myImage;

        public OpDrawImageCenter(Image img, int x, int y, int dx, int dy) {
            this.myX = x;
            this.myY = y;
            this.myDX = dx;
            this.myDY = dy;
            this.myImage = img;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.drawImageCenter(this.myImage, x + this.myX, y + this.myY, this.myDX, this.myDY);
        }
    }

    public class OpDrawImage
    extends Operation {
        private int myX;
        private int myY;
        private Image myImage;

        public OpDrawImage(Image img, int x, int y) {
            this.myX = x;
            this.myY = y;
            this.myImage = img;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.drawImage(this.myImage, x + this.myX, y + this.myY);
        }
    }

    public class OpFillOval
    extends Operation {
        private int myX;
        private int myY;
        private int myDX;
        private int myDY;

        public OpFillOval(int x, int y, int dx, int dy) {
            this.myX = x;
            this.myY = y;
            this.myDX = dx;
            this.myDY = dy;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.fillOval(x + this.myX, y + this.myY, this.myDX, this.myDY);
        }
    }

    public class OpDrawOval
    extends Operation {
        private int myX;
        private int myY;
        private int myDX;
        private int myDY;

        public OpDrawOval(int x, int y, int dx, int dy) {
            this.myX = x;
            this.myY = y;
            this.myDX = dx;
            this.myDY = dy;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.drawOval(x + this.myX, y + this.myY, this.myDX, this.myDY);
        }
    }

    public class OpFillPolygon
    extends Operation {
        private int[] myXX;
        private int[] myYY;
        private int myN;

        public OpFillPolygon(int[] xx, int[] yy, int n) {
            this.myXX = xx;
            this.myYY = yy;
            this.myN = n;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            int i;
            int sizexx = this.myXX.length;
            int sizeyy = this.myYY.length;
            int[] xx = new int[sizexx];
            int[] yy = new int[sizeyy];
            for (i = 0; i < sizexx; ++i) {
                xx[i] = x + this.myXX[i];
            }
            for (i = 0; i < sizeyy; ++i) {
                yy[i] = y + this.myYY[i];
            }
            ir.fillPolygon(xx, yy, this.myN);
        }
    }

    public class OpDrawPolygon
    extends Operation {
        private int[] myXX;
        private int[] myYY;
        private int myN;

        public OpDrawPolygon(int[] xx, int[] yy, int n) {
            this.myXX = xx;
            this.myYY = yy;
            this.myN = n;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            int i;
            int sizexx = this.myXX.length;
            int sizeyy = this.myYY.length;
            int[] xx = new int[sizexx];
            int[] yy = new int[sizeyy];
            for (i = 0; i < sizexx; ++i) {
                xx[i] = x + this.myXX[i];
            }
            for (i = 0; i < sizeyy; ++i) {
                yy[i] = y + this.myYY[i];
            }
            ir.drawPolygon(xx, yy, this.myN);
        }
    }

    public class OpClearRect
    extends Operation {
        private int myX;
        private int myY;
        private int myDX;
        private int myDY;

        public OpClearRect(int x, int y, int dx, int dy) {
            this.myX = x;
            this.myY = y;
            this.myDX = dx;
            this.myDY = dy;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.clearRect(x + this.myX, y + this.myY, this.myDX, this.myDY);
        }
    }

    public class OpFillRect
    extends Operation {
        private int myX;
        private int myY;
        private int myDX;
        private int myDY;

        public OpFillRect(int x, int y, int dx, int dy) {
            this.myX = x;
            this.myY = y;
            this.myDX = dx;
            this.myDY = dy;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.fillRect(x + this.myX, y + this.myY, this.myDX, this.myDY);
        }
    }

    public class OpDrawRectWH
    extends Operation {
        private int myX;
        private int myY;
        private int myW;
        private int myH;

        public OpDrawRectWH(int x, int y, int w, int h) {
            this.myX = x;
            this.myY = y;
            this.myW = w;
            this.myH = h;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.drawRectWH(x + this.myX, y + this.myY, this.myW, this.myH);
        }
    }

    public class OpDrawLine
    extends Operation {
        private int myX1;
        private int myY1;
        private int myX2;
        private int myY2;

        public OpDrawLine(int x1, int y1, int x2, int y2) {
            this.myX1 = x1;
            this.myY1 = y1;
            this.myX2 = x2;
            this.myY2 = y2;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.drawLine(x + this.myX1, y + this.myY1, x + this.myX2, y + this.myY2);
        }
    }

    public class OpSetBackground
    extends Operation {
        private Color myColor;

        public OpSetBackground(Color color) {
            this.myColor = color;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.setBackground(this.myColor);
        }
    }

    public class OpSetColor
    extends Operation {
        private Color myColor;

        public OpSetColor(Color color) {
            this.myColor = color;
        }

        @Override
        public void draw(ImageRenderer ir, int x, int y) {
            ir.setColor(this.myColor);
        }
    }

    public abstract class Operation {
        public abstract void draw(ImageRenderer var1, int var2, int var3);
    }
}

