/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.mimages.OldImageHandler;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Vector;
import javax.imageio.ImageIO;

public class ImageRenderer
implements Cloneable {
    private static final int STDIMAGEWIDTH = 2480;
    private static final int STDIMAGEHEIGHT = 3508;
    private static final int STDBORDERLEFT = 248;
    private static final int STDBORDERRIGHT = 248;
    private static final int STDBORDERTOP = 233;
    private static final int STDBORDERBOTTOM = 233;
    private static final int STDIMAGETYPE = 10;
    private static final String STDFONTNAME = "Courier";
    private static final int STDFONTSTYLE = 0;
    private static final int STDFONTSIZE = 35;
    private static final boolean STDANTIALIASING = true;
    protected static final String STDFILENAME = "image_%d.png";
    private static final int[] IMG_TYPES = new int[]{12, 10, 1, 2};
    private static final int[] FNT_STYLES = new int[]{0, 1, 2, 3};
    private static final int STDRESOLUTION = 300;
    protected BufferedImage myImage = null;
    private int myImageWidth = 2480;
    private int myImageHeight = 3508;
    private int myBorderLeft = 248;
    private int myBorderRight = 248;
    private int myBorderTop = 233;
    private int myBorderBottom = 233;
    private int myImageType = 10;
    private String myFontName = "Courier";
    private int myFontStyle = 0;
    private int myFontSize = 35;
    private boolean myAntialiasing = true;
    private Graphics2D myG2D = null;
    private FontMetrics myFM = null;
    private int myPage = 0;
    private int myCurX;
    private int myCurY;
    private String myFileName = "image_%d.png";
    private Vector myImages = new Vector();
    private int myResolution = 300;

    protected ImageRenderer() {
    }

    public ImageRenderer(String fn) {
        this.setFileName(fn);
    }

    public ImageRenderer cloneIR() {
        try {
            return (ImageRenderer)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setImageWidth(int width) {
        this.myImageWidth = width;
    }

    public int getImageWidth() {
        return this.myImageWidth;
    }

    public void setImageHeight(int height) {
        this.myImageHeight = height;
    }

    public int getImageHeight() {
        return this.myImageHeight;
    }

    public void setBorderLeft(int left) {
        this.myBorderLeft = left;
    }

    public int getBorderLeft() {
        return this.myBorderLeft;
    }

    public void setBorderRight(int right) {
        this.myBorderRight = right;
    }

    public int getBorderRight() {
        return this.myBorderRight;
    }

    public void setBorderTop(int top) {
        this.myBorderTop = top;
    }

    public int getBorderTop() {
        return this.myBorderTop;
    }

    public void setBorderBottom(int bottom) {
        this.myBorderBottom = bottom;
    }

    public int getBorderBottom() {
        return this.myBorderBottom;
    }

    public void setImageType(int imagetype) {
        this.myImageType = imagetype;
    }

    public int getImageType() {
        return this.myImageType;
    }

    public void setImageTypeIndex(int i) {
        int it = 10;
        if (i >= 0 && i < IMG_TYPES.length) {
            it = IMG_TYPES[i];
        }
        this.setImageType(it);
    }

    public int getImageTypeIndex() {
        int it = this.getImageType();
        for (int i = 0; i < IMG_TYPES.length; ++i) {
            if (it != IMG_TYPES[i]) continue;
            return i;
        }
        return -1;
    }

    public void setFontName(String fontname) {
        this.myFontName = fontname;
    }

    public String getFontName() {
        return this.myFontName;
    }

    public void setFontStyle(int fontstyle) {
        this.myFontStyle = fontstyle;
    }

    public int getFontStyle() {
        return this.myFontStyle;
    }

    public void setFontStyleIndex(int i) {
        if (i >= 0 && i < FNT_STYLES.length) {
            this.setFontStyle(FNT_STYLES[i]);
        }
    }

    public int getFontStyleIndex() {
        int fs = this.getFontStyle();
        for (int i = 0; i < FNT_STYLES.length; ++i) {
            if (fs != FNT_STYLES[i]) continue;
            return i;
        }
        return -1;
    }

    public void setFontSize(int fontsize) {
        this.myFontSize = fontsize;
    }

    public int getFontSize() {
        return this.myFontSize;
    }

    public void setAntialiasing(boolean antialiasing) {
        this.myAntialiasing = antialiasing;
    }

    public boolean getAntialiasing() {
        return this.myAntialiasing;
    }

    public void setFileName(String fn) {
        if (fn == null) {
            throw new NullPointerException("Can't set filename to null. Need a filename to save images.");
        }
        this.myFileName = fn;
    }

    public String getFileName() {
        return this.myFileName;
    }

    public void setPage(int page) {
        this.myPage = page;
    }

    public void setCurX(int x) {
        this.myCurX = x;
    }

    public int getCurX() {
        return this.myCurX;
    }

    public void setCurY(int y) {
        this.myCurY = y;
    }

    public int getCurY() {
        return this.myCurY;
    }

    public int getPage() {
        return this.myPage;
    }

    public BufferedImage getImage() {
        return this.myImage;
    }

    public Vector getImages() {
        return this.myImages;
    }

    public int getResolution() {
        return this.myResolution;
    }

    public void setResolution(int res) {
        this.myResolution = res;
    }

    public void refreshFont() {
        if (this.myG2D != null) {
            if (this.myAntialiasing) {
                this.myG2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                this.myG2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.myG2D.setFont(new Font(this.myFontName, this.myFontStyle, this.myFontSize));
            this.myFM = this.myG2D.getFontMetrics();
        }
    }

    public void resetImage() {
        this.myImage = null;
    }

    public void resetImages() {
        this.myImages.clear();
        this.myPage = 0;
        this.resetImage();
    }

    private void checkImage() {
        if (this.myImage == null) {
            this.myImage = new BufferedImage(this.myImageWidth, this.myImageHeight, this.myImageType);
            this.myCurX = this.myBorderLeft;
            this.myCurY = this.myBorderTop;
            this.myG2D = (Graphics2D)this.myImage.getGraphics();
            this.myG2D.setBackground(Color.white);
            this.myG2D.setColor(Color.black);
            this.myG2D.clearRect(0, 0, this.myImageWidth, this.myImageHeight);
            this.refreshFont();
        }
    }

    public void setImage(BufferedImage img) {
        this.myImage = img;
        this.myImageWidth = img.getWidth();
        this.myImageHeight = img.getHeight();
        this.myCurX = this.myBorderLeft;
        this.myCurY = this.myBorderTop;
        this.myG2D = (Graphics2D)this.myImage.getGraphics();
        this.myG2D.setBackground(Color.white);
        this.myG2D.setColor(Color.black);
        this.refreshFont();
    }

    protected static void saveImage(String fn, BufferedImage img, int resolution) throws Exception {
        if (fn.endsWith(".png")) {
            ImageIO.write((RenderedImage)img, "png", new File(fn));
        } else if (fn.endsWith(".jpg")) {
            if (img.getType() != 1) {
                BufferedImage img2save = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
                img2save.getGraphics().drawImage(img, 0, 0, null);
                img = img2save;
            }
            ImageIO.write((RenderedImage)img, "jpg", new File(fn));
        } else if (fn.endsWith(".gif")) {
            ImageIO.write((RenderedImage)img, "gif", new File(fn));
        } else {
            OldImageHandler.saveImage(fn, img, resolution);
        }
    }

    public static void saveImage(String fn, BufferedImage img) throws Exception {
        ImageRenderer.saveImage(fn, img, 300);
    }

    protected void saveImage(String fn) throws Exception {
        ImageRenderer.saveImage(fn, this.myImage, this.myResolution);
    }

    public void saveImage() throws Exception {
        String fn = this.myFileName;
        int fni = fn.indexOf("%d");
        if (fni >= 0) {
            fn = fn.substring(0, fni) + ("" + (10000 + this.myPage)).substring(1) + (fni < fn.length() ? fn.substring(fni + 2) : "");
        }
        try {
            MLogger.deb((String)("Saving picture(" + this.myPage + ")... "));
            this.saveImage(fn);
            MLogger.deb((String)"Picture saved okay!");
        }
        catch (Exception e) {
            MLogger.err((String)("Picture(" + this.myPage + ") save failed: " + e.getMessage()), (Throwable)e);
            throw e;
        }
        this.myImages.add(fn);
        ++this.myPage;
        this.myImage = null;
        this.myG2D = null;
        this.myFM = null;
    }

    public void flush() throws Exception {
        if (this.myImage != null && (this.myCurX != this.myBorderLeft || this.myCurY != this.myBorderTop)) {
            this.saveImage();
        }
    }

    public void println() throws Exception {
        this.checkImage();
        this.myCurX = this.myBorderLeft;
        this.myCurY += this.myFM.getHeight();
        if (this.myCurY >= this.myImageHeight - this.myBorderBottom - this.myFM.getHeight()) {
            this.saveImage();
        }
    }

    public void print(String s) throws Exception {
        int lenss;
        int w;
        this.checkImage();
        int space = this.myImageWidth - this.myBorderRight - this.myCurX;
        String ss = s;
        while ((w = this.myFM.stringWidth(ss)) > space) {
            int li;
            for (li = ss.lastIndexOf(32); li > 1 && ss.charAt(li - 1) == ' '; --li) {
            }
            if (li > 0) {
                ss = ss.substring(0, li);
                continue;
            }
            String ss1 = ss;
            int cnt = 0;
            while (this.myFM.stringWidth(ss = ss1.substring(0, ++cnt)) <= space) {
            }
            ss = ss.substring(0, ss.length() - 1);
        }
        this.myG2D.drawString(ss, this.myCurX, this.myCurY + this.myFM.getAscent());
        this.myCurX += w;
        int lens = s.length();
        if (lenss != lens) {
            for (lenss = ss.length(); lenss < lens && s.charAt(lenss) == ' '; ++lenss) {
            }
            if (lenss != lens) {
                ss = s.substring(lenss);
                this.println();
                this.print(ss);
            }
        }
    }

    public void println(String s) throws Exception {
        this.print(s);
        this.println();
    }

    public int getWidth(String s) {
        this.checkImage();
        return this.myFM.stringWidth(s);
    }

    public int getHeight() {
        this.checkImage();
        return this.myFM.getHeight();
    }

    public int getAscent() {
        this.checkImage();
        return this.myFM.getAscent();
    }

    public Color getColor() {
        this.checkImage();
        return this.myG2D.getColor();
    }

    public void setColor(Color c) {
        this.checkImage();
        this.myG2D.setColor(c);
    }

    public Color getBackground() {
        this.checkImage();
        return this.myG2D.getBackground();
    }

    public void setBackground(Color c) {
        this.checkImage();
        this.myG2D.setBackground(c);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkImage();
        this.myG2D.drawLine(x1, y1, x2, y2);
    }

    public void drawRectWH(int x, int y, int width, int height) {
        this.checkImage();
        this.myG2D.drawRect(x, y, width - 1, height - 1);
    }

    public void fillRect(int x, int y, int dx, int dy) {
        this.checkImage();
        this.myG2D.fillRect(x, y, dx, dy);
    }

    public void clearRect(int x, int y, int dx, int dy) {
        this.checkImage();
        this.myG2D.clearRect(x, y, dx, dy);
    }

    public void drawPolygon(int[] xx, int[] yy, int n) {
        this.checkImage();
        this.myG2D.drawPolygon(xx, yy, n);
    }

    public void fillPolygon(int[] xx, int[] yy, int n) {
        this.checkImage();
        this.myG2D.fillPolygon(xx, yy, n);
    }

    public void drawOval(int x, int y, int dx, int dy) {
        this.checkImage();
        this.myG2D.drawOval(x - dx, y - dy, 2 * dx - 1 + 1, 2 * dy - 1 + 1);
    }

    public void fillOval(int x, int y, int dx, int dy) {
        this.checkImage();
        this.myG2D.fillOval(x - dx, y - dy, 2 * dx + 1, 2 * dy + 1);
    }

    public void drawImage(Image img, int x, int y) {
        this.checkImage();
        if (img instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)img;
            int w = bi.getWidth();
            int h = bi.getHeight();
            int[] ia = bi.getRGB(0, 0, w, h, null, 0, w);
            this.myImage.setRGB(x, y, w, h, ia, 0, w);
        } else {
            this.myG2D.drawImage(img, x, y, null);
        }
    }

    public void drawImageCenter(Image img, int x, int y, int dx, int dy) {
        this.checkImage();
        int w = img.getWidth(null);
        int h = img.getHeight(null);
        this.myG2D.drawImage(img, x += (dx - w) / 2, y += (dy - h) / 2, null);
    }

    public void drawImageZoom(Image img, int x, int y, int dx, int dy) {
        this.checkImage();
        this.myG2D.drawImage(img, x, y, x + dx, y + dy, 0, 0, img.getWidth(null), img.getHeight(null), null);
    }

    public static void main(String[] args) {
        try {
            ImageRenderer ir = new ImageRenderer("test.tif");
            ir.setImageType(12);
            ir.setCurX(10);
            ir.setCurY(10);
            ir.println("Test");
            ir.flush();
        }
        catch (Exception ex) {
            MLogger.err((String)"", (Throwable)ex);
        }
    }
}

