/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.cts.UniTypeConv;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static BufferedImage loadImage(InputStream is) throws IOException {
        return ImageIO.read(is);
    }

    public static BufferedImage loadImage(byte[] imagedata) throws IOException {
        return ImageUtils.loadImage(new ByteArrayInputStream(imagedata));
    }

    public static BufferedImage loadImage(File f) throws IOException {
        return ImageUtils.loadImage(new BufferedInputStream(new FileInputStream(f)));
    }

    public static BufferedImage loadImage(String fn) throws IOException {
        return ImageUtils.loadImage(new File(fn));
    }

    public static void saveImage(OutputStream os, BufferedImage img, String format) throws IOException {
        if ("png".equals(format)) {
            ImageIO.write((RenderedImage)img, "png", os);
        } else if ("jpg".equals(format)) {
            if (img.getType() != 1) {
                BufferedImage img2save = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
                img2save.getGraphics().drawImage(img, 0, 0, null);
                img = img2save;
            }
            ImageIO.write((RenderedImage)img, "jpg", os);
        } else if ("gif".equals(format)) {
            ImageIO.write((RenderedImage)img, "gif", os);
        }
    }

    public static byte[] saveImage(BufferedImage img, String format) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageUtils.saveImage(baos, img, format);
        return baos.toByteArray();
    }

    public static void saveImage(File f, BufferedImage img) throws IOException {
        File dir = f.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        String format = null;
        String name = f.getName();
        int i = name.lastIndexOf(".");
        if (i >= 0) {
            format = name.substring(i + 1).toLowerCase();
        }
        ImageUtils.saveImage(new BufferedOutputStream(new FileOutputStream(f)), img, format);
    }

    public static void saveImage(String fn, BufferedImage img) throws IOException {
        ImageUtils.saveImage(new File(fn), img);
    }

    public static BufferedImage newImage(int x, int y, Long cc) {
        BufferedImage img = new BufferedImage(x, y, 2);
        if (cc != null) {
            Graphics g = img.getGraphics();
            g.setColor(new Color(cc.intValue(), true));
            g.fillRect(0, 0, x, y);
        }
        return img;
    }

    public static BufferedImage zoomImage(BufferedImage img, int x, int y) {
        Image scaledimg = img.getScaledInstance(x, y, 4);
        if (!(scaledimg instanceof BufferedImage)) {
            img = new BufferedImage(scaledimg.getWidth(null), scaledimg.getHeight(null), 2);
            img.getGraphics().drawImage(scaledimg, 0, 0, null);
        } else {
            img = (BufferedImage)scaledimg;
        }
        return img;
    }

    public static BufferedImage zoomImage(BufferedImage img, String sx, String sy) {
        Integer xx = null;
        Integer yy = null;
        if (!"*".equals(sx) && !"*".equals(sy)) {
            xx = UniTypeConv.convString2Int((String)sx);
            yy = UniTypeConv.convString2Int((String)sy);
        } else if (!"*".equals(sx) && "*".equals(sy)) {
            xx = UniTypeConv.convString2Int((String)sx);
            yy = img.getHeight() * xx / img.getWidth();
        } else if ("*".equals(sx) && !"*".equals(sy)) {
            yy = UniTypeConv.convString2Int((String)sy);
            xx = img.getWidth() * yy / img.getHeight();
        }
        int x = xx != null ? xx : 1;
        int y = yy != null ? yy : 1;
        return ImageUtils.zoomImage(img, x, y);
    }

    public static BufferedImage combine(BufferedImage background, BufferedImage foreground, int x, int y) {
        BufferedImage img = new BufferedImage(background.getWidth(null), background.getHeight(null), 2);
        img.getGraphics().drawImage(background, 0, 0, null);
        img.getGraphics().drawImage(foreground, x, y, null);
        return img;
    }

    public static BufferedImage mboxImage(BufferedImage img, int x, int y, Long cc) {
        int ximg = img.getWidth();
        int yimg = img.getHeight();
        double dimg = 1.0 * (double)ximg / (double)yimg;
        BufferedImage box = ImageUtils.newImage(x, y, cc);
        int xbox = box.getWidth();
        int ybox = box.getHeight();
        double dbox = 1.0 * (double)xbox / (double)ybox;
        BufferedImage res = null;
        if (dimg > dbox) {
            BufferedImage n = ImageUtils.zoomImage(img, "" + xbox, "*");
            res = ImageUtils.combine(box, n, 0, (ybox - n.getHeight()) / 2);
        } else if (dimg < dbox) {
            BufferedImage n = ImageUtils.zoomImage(img, "*", "" + ybox);
            res = ImageUtils.combine(box, n, (xbox - n.getWidth()) / 2, 0);
        } else {
            BufferedImage n = ImageUtils.zoomImage(img, "" + xbox, "" + ybox);
            res = ImageUtils.combine(box, n, 0, 0);
        }
        return res;
    }

    public static BufferedImage addBorder(BufferedImage orgimg, int x1, int y1, int x2, int y2, Long cc) {
        int color = cc != null ? cc.intValue() : 0;
        int width = x1 + orgimg.getWidth() + x2;
        int height = y1 + orgimg.getHeight() + y2;
        BufferedImage newimg = new BufferedImage(width, height, 2);
        Graphics g = newimg.getGraphics();
        g.setColor(new Color(color, true));
        if (x1 != 0) {
            g.fillRect(0, 0, x1, height);
        }
        if (y1 != 0) {
            g.fillRect(0, 0, width, y1);
        }
        if (x2 != 0) {
            g.fillRect(width - x2, 0, x2, height);
        }
        if (y2 != 0) {
            g.fillRect(0, height - y2, width, y2);
        }
        g.drawImage(orgimg, x1, y1, null);
        return newimg;
    }

    public static void scale(BufferedImage img, int ff) {
        int blue = ff & 0xFF;
        int green = ff >> 8 & 0xFF;
        int red = ff >> 16 & 0xFF;
        int alpha = ff >> 24 & 0xFF;
        MLogger.deb(() -> "argb = " + alpha + " / " + red + " / " + green + " / " + blue);
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.getRGB(x, y);
                int b = argb & 0xFF;
                int g = argb >> 8 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int a = argb >> 24 & 0xFF;
                a = a * alpha / 255;
                r = r * red / 255;
                g = g * green / 255;
                b = b * blue / 255;
                argb = (a << 24) + (r << 16) + (g << 8) + b;
                img.setRGB(x, y, argb);
            }
        }
    }

    public static BufferedImage scale4(BufferedImage orgimg, int alpha, int red, int green, int blue) {
        BufferedImage img = new BufferedImage(orgimg.getWidth(null), orgimg.getHeight(null), 2);
        img.getGraphics().drawImage(orgimg, 0, 0, null);
        MLogger.deb(() -> "argb = " + alpha + " / " + red + " / " + green + " / " + blue);
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.getRGB(x, y);
                int b = argb & 0xFF;
                int g = argb >> 8 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int a = argb >> 24 & 0xFF;
                a = a * alpha / 255;
                r = r * red / 255;
                g = g * green / 255;
                b = b * blue / 255;
                argb = ((a <= 255 ? a : 255) << 24) + ((r <= 255 ? r : 255) << 16) + ((g <= 255 ? g : 255) << 8) + (b <= 255 ? b : 255);
                img.setRGB(x, y, argb);
            }
        }
        return img;
    }

    protected ImageUtils() {
    }
}

