/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.mlogger.MLogger;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PerspectiveTransform;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.WarpPerspective;

public class ImageWarper {
    public WarpResult execWarpToRect(BufferedImage bufImage, Point p0, Point p1, Point p2, Point p3, int destRectWidth, int destRectHeight) {
        WarpResult result = new WarpResult();
        Point[] srcImageEdgePoints = new Point[]{p0, p1, p2, p3};
        Point[] destSizePoints = new Point[]{new Point(0, 0), new Point(destRectWidth, 0), new Point(destRectWidth, destRectHeight), new Point(0, destRectHeight)};
        PerspectiveTransform perspectiveTransform = this.getWarpTransform(srcImageEdgePoints, destSizePoints);
        Point offset = new Point(0, 0);
        Point[] bufImagePoints = new Point[]{new Point(0, 0), new Point(bufImage.getWidth(), 0), new Point(bufImage.getWidth(), bufImage.getHeight()), new Point(0, bufImage.getHeight())};
        Point bufImageTopLeft = this.getUpperLeftPointOf(bufImage, bufImagePoints, perspectiveTransform);
        offset.x = -bufImageTopLeft.x;
        offset.y = -bufImageTopLeft.y;
        BufferedImage warpedBufferedImage = this.warpImage(bufImage, perspectiveTransform);
        result.offset = offset;
        result.bufImage = warpedBufferedImage;
        return result;
    }

    public WarpResult execWarpFromRect(BufferedImage bufImage, Point p0, Point p1, Point p2, Point p3) {
        WarpResult result = new WarpResult();
        Point[] srcImageEdgePoints = this.getCornerPointsOfImage(bufImage);
        Point[] moveToEdgePointsOnBackgroundImage = new Point[]{p0, p1, p2, p3};
        PerspectiveTransform perspectiveTransform = this.getWarpTransform(srcImageEdgePoints, moveToEdgePointsOnBackgroundImage);
        Point topLeft = this.getUpperLeftPointOf(bufImage, srcImageEdgePoints, perspectiveTransform);
        BufferedImage warpedBufferedImage = this.warpImage(bufImage, perspectiveTransform);
        result.offset = topLeft;
        result.bufImage = warpedBufferedImage;
        return result;
    }

    private BufferedImage warpImage(BufferedImage bufImage, PerspectiveTransform perspectiveTransform) {
        PerspectiveTransform inverseTransform = null;
        try {
            inverseTransform = perspectiveTransform.createInverse();
        }
        catch (NoninvertibleTransformException e1) {
            MLogger.err((String)"", (Throwable)e1);
            return null;
        }
        catch (CloneNotSupportedException e1) {
            MLogger.err((String)"", (Throwable)e1);
            return null;
        }
        WarpPerspective warpPerspective = new WarpPerspective(inverseTransform);
        if (warpPerspective == null) {
            return null;
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        PlanarImage planarImage = PlanarImage.wrapRenderedImage((RenderedImage)bufImage);
        parameterBlock.addSource(planarImage);
        parameterBlock.add(warpPerspective);
        parameterBlock.add(Interpolation.getInstance((int)2));
        String OP_NAME = "warp";
        RenderedOp warpedPlanarImage = JAI.create((String)"warp", (ParameterBlock)parameterBlock);
        BufferedImage wapedBufferedImage = warpedPlanarImage.getAsBufferedImage();
        return wapedBufferedImage;
    }

    private Point[] getCornerPointsOfImage(BufferedImage bufImage) {
        int srcWidth = bufImage.getWidth();
        int srcHeight = bufImage.getHeight();
        Point[] srcImageEdgePoints = new Point[]{new Point(0, 0), new Point(srcWidth, 0), new Point(srcWidth, srcHeight), new Point(0, srcHeight)};
        return srcImageEdgePoints;
    }

    private Point getUpperLeftPointOf(BufferedImage boundedIm, Point[] points, PerspectiveTransform persTF) {
        int numOfPoints = 4;
        Point[] transformedPoints = new Point[4];
        for (int i = 0; i < 4; ++i) {
            transformedPoints[i] = new Point();
            persTF.transform((Point2D)points[i], (Point2D)transformedPoints[i]);
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        for (int i = 0; i < points.length; ++i) {
            if (transformedPoints[i].x < minX) {
                minX = transformedPoints[i].x;
            }
            if (points[i].y >= minY) continue;
            minY = transformedPoints[i].y;
        }
        return new Point(minX, minY);
    }

    private PerspectiveTransform getWarpTransform(Point[] srcImageEdgePoints, Point[] moveToEdgePoints) {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.getQuadToQuad((float)srcImageEdgePoints[0].x, (float)srcImageEdgePoints[0].y, (float)srcImageEdgePoints[1].x, (float)srcImageEdgePoints[1].y, (float)srcImageEdgePoints[2].x, (float)srcImageEdgePoints[2].y, (float)srcImageEdgePoints[3].x, (float)srcImageEdgePoints[3].y, (float)moveToEdgePoints[0].x, (float)moveToEdgePoints[0].y, (float)moveToEdgePoints[1].x, (float)moveToEdgePoints[1].y, (float)moveToEdgePoints[2].x, (float)moveToEdgePoints[2].y, (float)moveToEdgePoints[3].x, (float)moveToEdgePoints[3].y);
        return perspectiveTransform;
    }

    static class WarpResult {
        private BufferedImage bufImage;
        private Point offset;

        WarpResult() {
        }

        public BufferedImage getImage() {
            return this.bufImage;
        }

        public Point getOffset() {
            return this.offset;
        }
    }
}

