/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.mimages.ImageRenderer;
import com.sta.mimages.MImagesPDM;
import com.sta.mimages.MImagesTPM;
import com.sta.mimages.MImagesUML;
import com.sta.mimages.MImgProc;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class MImages {
    public static final String VERSION = "1.44";
    public static final String COPYRIGHT = "2005-2023";
    public static final String COMPANY = ">StA-Soft<";

    public static String getVersion() {
        return VERSION;
    }

    public static String getCopyright() {
        return COPYRIGHT;
    }

    public static String getCompany() {
        return COMPANY;
    }

    public static ImageIcon loadImageIcon(String pSrcFileName) {
        URL url;
        ImageIcon ii = null;
        Exception ex = null;
        try {
            if (new File(pSrcFileName).exists()) {
                ii = new ImageIcon(pSrcFileName);
            }
        }
        catch (Exception e) {
            ex = e;
        }
        if (ii == null && (url = MImages.class.getResource("/" + pSrcFileName)) != null) {
            MLogger.deb((String)("Resource found, load via URL (" + pSrcFileName + ")!"));
            ii = new ImageIcon(url);
        }
        if (ii == null) {
            if (ex != null) {
                MLogger.err((String)("Error loading image via file system: " + pSrcFileName), (Throwable)ex);
            } else {
                MLogger.err((String)("Error loading image via resources: " + pSrcFileName));
            }
        }
        return ii;
    }

    public static Point getImageSize(String pSrcFileName) {
        ImageIcon ii = MImages.loadImageIcon(pSrcFileName);
        if (ii == null) {
            MLogger.inf((String)("Problem loading image: " + pSrcFileName));
            return new Point(0, 0);
        }
        return new Point(ii.getIconWidth(), ii.getIconHeight());
    }

    public static void wait4Image(Image img) {
        MediaTracker tracker = new MediaTracker(new JPanel());
        tracker.addImage(img, 0);
        try {
            tracker.waitForID(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String getNextParam(Vector params) {
        if (params.size() == 0) {
            return null;
        }
        String s = (String)params.get(0);
        if (s.length() == 0) {
            return null;
        }
        params.remove(0);
        return s;
    }

    protected static void checkLogLevel(Vector params) {
        String s = MImages.getNextParam(params);
        if ("-err".equals(s) || "-error".equals(s)) {
            MLogger.getMLogEntry((int)0).setMaxLevel(0);
        } else if ("-wrn".equals(s) || "-warning".equals(s)) {
            MLogger.getMLogEntry((int)0).setMaxLevel(1);
        } else if ("-inf".equals(s) || "-info".equals(s)) {
            MLogger.getMLogEntry((int)0).setMaxLevel(2);
        } else if ("-msg".equals(s) || "-message".equals(s)) {
            MLogger.getMLogEntry((int)0).setMaxLevel(3);
        } else if ("-deb".equals(s) || "-debug".equals(s)) {
            MLogger.getMLogEntry((int)0).setMaxLevel(4);
        } else if ("-all".equals(s)) {
            MLogger.getMLogEntry((int)0).setMaxLevel(5);
        } else if (s != null) {
            params.add(0, s);
        }
    }

    public static void help() {
        MLogger.err((String)"Syntax Error.");
        MLogger.msg((String)"Usage: mimages ( PDM | TPM | TPM2 ) XMLFileName");
        MLogger.msg((String)"       mimages UML srcpng ClassName dstpng");
        MLogger.msg((String)"       mimages print filename fontname fontsize fontstyle color Test");
        MLogger.msg((String)"       mimages mimgproc filename");
        MLogger.msg((String)" PDM  ... Physical Data Model");
        MLogger.msg((String)" TPM  ... Technical Process Model");
        MLogger.msg((String)" UML  ... Extract one class diagramm");
        System.exit(1);
    }

    protected static BufferedImage print(String fontname, int fontsize, int fontstyleindex, Color color, int y, String text) throws Exception {
        ImageRenderer ir = new ImageRenderer();
        ir.setFontName(fontname);
        ir.setFontSize(fontsize);
        ir.setFontStyleIndex(fontstyleindex);
        ir.setImageTypeIndex(2);
        ir.setBorderBottom(0);
        ir.setBorderLeft(0);
        ir.setBorderRight(0);
        ir.setBorderTop(0);
        ir.setColor(color);
        ir.setAntialiasing(true);
        ir.setCurX(0);
        ir.setCurY(y);
        ir.print(text);
        int xx = ir.getCurX();
        ir.println();
        int yy = ir.getCurY();
        MLogger.deb((String)("X/Y: " + xx + " / " + yy));
        MLogger.deb((String)("w/h: " + ir.getWidth(text) + " / " + ir.getHeight()));
        int ya = MImages.search4nn(ir);
        int ye = MImages.search4nn_(ir);
        MLogger.deb((String)("ya/ye: " + ya + " / " + ye + " --> " + (ye - ya + 1)));
        BufferedImage img = ir.getImage();
        img = img.getSubimage(0, ya, xx, ye - ya + 1);
        int w = img.getWidth();
        int h = img.getHeight();
        BufferedImage img2 = new BufferedImage(w, h, 2);
        for (int yp = 0; yp < h; ++yp) {
            for (int xp = 0; xp < w; ++xp) {
                int rgb = img.getRGB(xp, yp);
                rgb = rgb & 0xFFFFFF | 255 - (rgb & 0xFF) << 24;
                img2.setRGB(xp, yp, rgb);
            }
        }
        return img2;
    }

    private static int search4nn(ImageRenderer ir) {
        int width = ir.getImageWidth();
        int height = ir.getImageHeight();
        int y = 0;
        boolean isnn = false;
        BufferedImage img = ir.getImage();
        while (!isnn && y < height) {
            int x;
            for (x = 0; x < width && (img.getRGB(x, y) & 0xFFFFFF) == 0xFFFFFF; ++x) {
            }
            isnn = x < width;
            if (isnn) continue;
            ++y;
        }
        return y;
    }

    private static int search4nn_(ImageRenderer ir) {
        int width = ir.getImageWidth();
        int height = ir.getImageHeight();
        int y = height - 1;
        boolean isnn = false;
        BufferedImage img = ir.getImage();
        while (!isnn && y >= 0) {
            int x;
            for (x = 0; x < width && (img.getRGB(x, y) & 0xFFFFFF) == 0xFFFFFF; ++x) {
            }
            isnn = x < width;
            if (isnn) continue;
            --y;
        }
        return y;
    }

    public static void main(String[] args) {
        MLogger.msg((String)"MImages  Version 1.44  Copyright (c) 2005-2023 >StA-Soft<");
        Vector<String> params = new Vector<String>(Arrays.asList(args));
        MImages.checkLogLevel(params);
        String s = MImages.getNextParam(params);
        if ("PDM".equals(s)) {
            new MImagesPDM();
            MImagesPDM.run(params);
        } else if ("TPM".equals(s)) {
            new MImagesTPM();
            MImagesTPM.run(params);
        } else if ("UML".equals(s)) {
            new MImagesUML().run(params);
        } else if ("print".equals(s)) {
            try {
                String filename = MImages.getNextParam(params);
                String fontname = MImages.getNextParam(params);
                int fontsize = new Integer(MImages.getNextParam(params));
                int fontstyleindex = new Integer(MImages.getNextParam(params));
                String c = MImages.getNextParam(params);
                Color color = c.startsWith("$") ? new Color(Integer.parseInt(c.substring(1), 16)) : new Color(Integer.parseInt(c));
                String text = MImages.getNextParam(params);
                MLogger.deb((String)("Text: " + text));
                BufferedImage img = MImages.print(fontname, fontsize, fontstyleindex, color, 0, text);
                ImageRenderer.saveImage(filename, img);
            }
            catch (Exception e) {
                MLogger.err((String)"", (Throwable)e);
            }
        } else if ("mimgproc".equals(s)) {
            try {
                String filename = MImages.getNextParam(params);
                if (filename == null) {
                    throw new NullPointerException("Missing file name.");
                }
                MImgProc mimgproc = new MImgProc();
                mimgproc.run(filename);
            }
            catch (Exception e) {
                MLogger.err((String)"", (Throwable)e);
            }
        } else if ("info".equals(s)) {
            String[] rfn = ImageIO.getReaderFormatNames();
            MLogger.deb((String)"Readers:");
            for (int i = 0; i < rfn.length; ++i) {
                MLogger.deb((String)("* " + rfn[i]));
            }
            String[] wfn = ImageIO.getWriterFormatNames();
            MLogger.deb((String)"Writer:");
            for (int i = 0; i < wfn.length; ++i) {
                MLogger.deb((String)("* " + wfn[i]));
            }
        } else {
            MImages.help();
        }
    }

    protected MImages() {
    }
}

