/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.cts.XMLScanner;
import com.sta.cts.XMLTag;
import com.sta.mimages.ImageBuffer;
import com.sta.mimages.ImageRenderer;
import com.sta.mimages.MImages;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MImagesPDM
extends MImages {
    private static Vector statDBModels = new Vector();
    private static String statPrjName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String fn, String pre) throws Exception {
        XMLScanner xs = new XMLScanner();
        xs.init(fn);
        try {
            xs.initH(null);
            XMLTag t = xs.getLeafStart("root");
            if (t == null) {
                throw new Exception("Missing <root>.");
            }
            statPrjName = t.getAttr("prjname");
            while ((t = xs.getLeafStart("model")) != null) {
                DBModel dbmodel = new DBModel(null, statPrjName);
                dbmodel.setImagePrefix(pre);
                dbmodel.load(t);
                statDBModels.add(dbmodel);
                dbmodel.load(xs);
                t = xs.getLeafEnd("model");
                if (t != null) continue;
                throw new Exception("Missing </model>.");
            }
            t = xs.getLeafEnd("root");
            if (t == null) {
                throw new Exception("Missing </root>.");
            }
        }
        finally {
            xs.done();
        }
    }

    public static void run() throws Exception {
        int mcnt = statDBModels.size();
        for (int i = 0; i < mcnt; ++i) {
            DBModel dbmodel = (DBModel)statDBModels.get(i);
            dbmodel.run();
        }
    }

    public static void save(String dst) throws Exception {
        int mcnt = statDBModels.size();
        for (int i = 0; i < mcnt; ++i) {
            DBModel dbmodel = (DBModel)statDBModels.get(i);
            dbmodel.save(dst);
        }
    }

    public static void run(String fn, String dst, String pre) throws Exception {
        MLogger.deb((String)"***** load *****");
        MImagesPDM.load(fn, pre);
        MLogger.deb((String)"***** run *****");
        MImagesPDM.run();
        MLogger.deb((String)"***** save *****");
        MImagesPDM.save(dst);
        MLogger.deb((String)"***** ok *****");
    }

    public static void run(Vector params) {
        String fn = MImagesPDM.getNextParam(params);
        if (fn == null) {
            MLogger.err((String)"Missing file name.");
            return;
        }
        String dst = MImagesPDM.getNextParam(params);
        if (dst == null) {
            dst = ".";
        }
        if (dst.endsWith("/") || dst.endsWith("\\")) {
            dst = dst.substring(0, dst.length() - 1);
        }
        String pre = MImagesPDM.getNextParam(params);
        try {
            MImagesPDM.run(fn, dst, pre);
        }
        catch (Exception e) {
            MLogger.err((String)("While processing: " + e.getMessage()), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        MLogger.msg((String)"MImagesPDM  Version 1.44  Copyright (c) 2005-2023 >StA-Soft<");
        Vector<String> params = new Vector<String>(Arrays.asList(args));
        MImagesPDM.checkLogLevel(params);
        MImagesPDM.run(params);
        System.exit(0);
    }

    public static class DBModel
    extends DBModBase {
        private String myDBModelName;
        private String myPrjName;
        private String myImageType = "PNG";
        private int myBorderLeft = 20;
        private int myBorderRight = 20;
        private int myBorderTop = 20;
        private int myBorderBottom = 20;
        private int myLineAdd = 0;
        private int myLineDelta = 0;
        private int myBlackBorder = 1;
        private int myWhiteBorder = 1;
        private int myShadowX = 8;
        private int myShadowY = 8;
        private int myMinWidth = 400;
        private int myRaster = 1;
        private int myFKRaster = 10;
        private Image myPKImage;
        private Image myPKImageZoom;
        private String myImagePrefix = "";

        public DBModel(String dbmodelname) {
            this.myDBModelName = dbmodelname;
        }

        public DBModel(String dbmodelname, String pPrjName) {
            this.myDBModelName = dbmodelname;
            this.myPrjName = pPrjName;
        }

        @Override
        protected String getName() {
            return this.myPrjName != null ? this.myPrjName : this.myDBModelName;
        }

        public String getImageType() {
            return this.myImageType;
        }

        public int getBorderLeft() {
            return this.myBorderLeft;
        }

        public int getBorderRight() {
            return this.myBorderRight;
        }

        public int getBorderTop() {
            return this.myBorderTop;
        }

        public int getBorderBottom() {
            return this.myBorderBottom;
        }

        public int getLineAdd() {
            return this.myLineAdd;
        }

        public int getLineDelta() {
            return this.myLineDelta;
        }

        public int getBlackBorder() {
            return this.myBlackBorder;
        }

        public int getWhiteBorder() {
            return this.myWhiteBorder;
        }

        public int getShadowX() {
            return this.myShadowX;
        }

        public int getShadowY() {
            return this.myShadowY;
        }

        public Image getPKImage() {
            if (this.myPKImage == null) {
                ImageIcon icon = MImages.loadImageIcon("resources/icons/pk13.png");
                if (icon == null) {
                    icon = MImages.loadImageIcon("../gen/source/icons/pk13.png");
                }
                if (icon != null) {
                    this.myPKImage = icon.getImage();
                }
                if (this.myPKImage == null) {
                    throw new NullPointerException("Can't find pk13.png.");
                }
            }
            return this.myPKImage;
        }

        public Image getPKImage(int x, int y) {
            Image pki;
            if (this.myPKImageZoom != null) {
                if (this.myPKImageZoom.getWidth(null) == x && this.myPKImageZoom.getHeight(null) == y) {
                    return this.myPKImageZoom;
                }
                this.myPKImageZoom = null;
            }
            if ((pki = this.getPKImage()) != null) {
                MLogger.deb((String)("Zoom to (x/y): " + x + "/" + y));
                this.myPKImageZoom = pki.getScaledInstance(x, y, 1);
                MImages.wait4Image(this.myPKImageZoom);
            }
            return this.myPKImageZoom;
        }

        public int getRaster() {
            return this.myRaster;
        }

        public int getFKRaster() {
            return this.myFKRaster;
        }

        public int getMinWidth() {
            return this.myMinWidth;
        }

        public String getImagePrefix() {
            return this.myImagePrefix;
        }

        public void setImagePrefix(String pre) {
            this.myImagePrefix = pre != null ? pre : "";
        }

        public void load(XMLTag t) {
            this.myDBModelName = this.loadString(t, "physdatamodelname", "???");
            MLogger.deb((String)("DBModel: " + this.myDBModelName));
        }

        public void load(XMLScanner xs) throws Exception {
            XMLTag t;
            while ((t = xs.getLeafStart("modul")) != null) {
                DBModul dbmodul = new DBModul();
                dbmodul.load(t, this);
                this.myModuls.add(dbmodul);
                dbmodul.load(xs, this);
                t = xs.getLeafEnd("modul");
                if (t != null) continue;
                throw new Exception("Missing </modul>.");
            }
            MLogger.deb((String)" DBModul: generated");
            while ((t = xs.getLeafStart("table")) != null) {
                DBTable dbtable = new DBTable();
                dbtable.load(t, this);
                this.myTables.add(dbtable);
                dbtable.load(xs);
                t = xs.getLeafEnd("table");
                if (t != null) continue;
                throw new Exception("Missing </table>.");
            }
        }

        public void run() {
            String name = this.myDBModelName.toLowerCase();
            MLogger.deb((String)("DBModel: " + this.myDBModelName));
            try {
                this.runsub(name, this);
            }
            catch (Exception e) {
                MLogger.err((String)("Error while creating image for model " + this.myDBModelName + ": " + e.getMessage()), (Throwable)e);
            }
        }

        public void save(String dst) {
            String name = this.myDBModelName.toLowerCase();
            String dir = dst + File.separator + name;
            new File(dir).mkdirs();
            MLogger.deb((String)("DBModel: " + this.myDBModelName + " --> " + dir));
            try {
                this.savesub(dst + File.separator, name, this);
            }
            catch (Exception e) {
                MLogger.err((String)("Error while saving image for model " + this.myDBModelName + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static class DBModul
    extends DBModBase {
        private String myDBModulName;

        public DBModul() {
        }

        public DBModul(String dbmodulname, int x, int y) {
            this.myDBModulName = dbmodulname;
            this.myX = x;
            this.myY = y;
        }

        @Override
        protected String getName() {
            return this.myDBModulName;
        }

        public void setName(String name) {
            this.myDBModulName = name;
        }

        public void load(XMLTag t, DBModel dbmodel) {
            this.myDBModulName = this.loadString(t, "dbmodulname", "???");
            MLogger.deb((String)(" DBModul: " + this.myDBModulName));
            this.myX = this.loadInt(t, "x", -1) * dbmodel.getRaster();
            this.myY = this.loadInt(t, "y", -1) * dbmodel.getRaster();
        }

        public void load(XMLScanner xs, DBModel dbmodel) throws Exception {
            XMLTag t;
            while ((t = xs.getLeafStart("modul")) != null) {
                DBModul dbmodul = new DBModul();
                dbmodul.load(t, dbmodel);
                this.myModuls.add(dbmodul);
                dbmodul.load(xs, dbmodel);
                t = xs.getLeafEnd("modul");
                if (t != null) continue;
                throw new Exception("Missing </modul>.");
            }
            while ((t = xs.getLeafStart("table")) != null) {
                DBTable dbtable = new DBTable();
                dbtable.load(t, dbmodel);
                this.myTables.add(dbtable);
                dbtable.load(xs);
                t = xs.getLeafEnd("table");
                if (t != null) continue;
                throw new Exception("Missing </table>.");
            }
        }

        public void run(DBModel dbmodel) {
            String name = this.myDBModulName.toLowerCase();
            MLogger.deb((String)(" DBModul: " + this.myDBModulName));
            try {
                this.runsub(name, dbmodel);
            }
            catch (Exception e) {
                MLogger.err((String)("Error while creating image for modul " + this.myDBModulName + ": " + e.getMessage()), (Throwable)e);
            }
        }

        public void save(String dst, DBModel dbmodel) {
            String name = this.myDBModulName.toLowerCase();
            String dir = dst + File.separator + name;
            new File(dir).mkdirs();
            MLogger.deb((String)(" DBModul: " + this.myDBModulName + " --> " + dir));
            try {
                this.savesub(dst + File.separator, name, dbmodel);
            }
            catch (Exception e) {
                MLogger.err((String)("Error while saving image for modul " + this.myDBModulName + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static abstract class DBModBase
    extends DBImgBase {
        protected Vector myModuls = new Vector();
        protected Vector myTables = new Vector();

        protected abstract String getName();

        public void addDBModul(DBModul dbmodul) {
            this.myModuls.add(dbmodul);
        }

        public void addDBTable(DBTable dbtable) {
            this.myTables.add(dbtable);
        }

        protected void runsub(String name, DBModel dbmodel) throws Exception {
            int i;
            int y;
            int x;
            int i2;
            int ye;
            int xe;
            int ys;
            int xs;
            int ya;
            int xa;
            DBModul dbmodul;
            int i3;
            int mcnt = this.myModuls.size();
            for (int i4 = 0; i4 < mcnt; ++i4) {
                DBModul dbmodul2 = (DBModul)this.myModuls.get(i4);
                dbmodul2.run(dbmodel);
            }
            int tcnt = this.myTables.size();
            for (int i5 = 0; i5 < tcnt; ++i5) {
                DBTable dbtable = (DBTable)this.myTables.get(i5);
                dbtable.run(dbmodel);
            }
            MLogger.deb((String)" Full picture...");
            this.mySizeX = 0;
            this.mySizeY = 0;
            int fontheight4name = this.myImageBuffer.getHeight();
            int blackborder = dbmodel.getBlackBorder();
            int borderleft = dbmodel.getBorderLeft();
            int borderright = dbmodel.getBorderRight();
            int bordertop = dbmodel.getBorderTop();
            int borderbottom = dbmodel.getBorderBottom();
            int shadowx = dbmodel.getShadowX();
            int shadowy = dbmodel.getShadowY();
            int fkraster = dbmodel.getFKRaster();
            boolean needadd = false;
            for (i3 = 0; i3 < mcnt; ++i3) {
                dbmodul = (DBModul)this.myModuls.get(i3);
                xa = dbmodul.getX();
                ya = dbmodul.getY();
                if (xa < 0 || ya < 0) continue;
                xs = dbmodul.getSizeX();
                ys = dbmodul.getSizeY();
                xe = xa + xs;
                ye = ya + ys;
                this.mySizeX = xe > this.mySizeX ? xe : this.mySizeX;
                this.mySizeY = ye > this.mySizeY ? ye : this.mySizeY;
                needadd = true;
            }
            for (i3 = 0; i3 < tcnt; ++i3) {
                DBTable dbtable = (DBTable)this.myTables.get(i3);
                xa = dbtable.getX();
                ya = dbtable.getY();
                if (xa < 0 || ya < 0) continue;
                xs = dbtable.getSizeX();
                ys = dbtable.getSizeY();
                int fkcnt = dbtable.getFKCount();
                int xe2 = xa + xs + fkcnt * fkraster + fkraster;
                int ye2 = ya + ys;
                this.mySizeX = xe2 > this.mySizeX ? xe2 : this.mySizeX;
                this.mySizeY = ye2 > this.mySizeY ? ye2 : this.mySizeY;
                needadd = true;
            }
            for (i3 = 0; i3 < mcnt; ++i3) {
                dbmodul = (DBModul)this.myModuls.get(i3);
                xa = dbmodul.getX();
                ya = dbmodul.getY();
                if (xa >= 0 && ya >= 0) continue;
                if (needadd) {
                    this.mySizeY += bordertop;
                }
                xa = 0;
                ya = this.mySizeY;
                dbmodul.setX(xa);
                dbmodul.setY(ya);
                xs = dbmodul.getSizeX();
                ys = dbmodul.getSizeY();
                xe = xa + xs;
                ye = ya + ys;
                this.mySizeX = xe > this.mySizeX ? xe : this.mySizeX;
                this.mySizeY = ye > this.mySizeY ? ye : this.mySizeY;
                needadd = true;
            }
            int orgxs = this.mySizeX;
            int xx = 0;
            int yy = this.mySizeY;
            for (int i6 = 0; i6 < tcnt; ++i6) {
                DBTable dbtable = (DBTable)this.myTables.get(i6);
                int xa2 = dbtable.getX();
                int ya2 = dbtable.getY();
                if (xa2 >= 0 && ya2 >= 0) continue;
                if (needadd) {
                    this.mySizeY += bordertop;
                    yy += bordertop;
                    needadd = false;
                }
                xa2 = xx;
                ya2 = yy;
                dbtable.setX(xa2);
                dbtable.setY(ya2);
                int xs2 = dbtable.getSizeX();
                int ys2 = dbtable.getSizeY();
                int fkcnt = dbtable.getFKCount();
                int xe3 = xa2 + xs2 + fkcnt * fkraster + fkraster;
                int ye3 = ya2 + ys2;
                xx = xe3;
                if (xa2 != 0 && xe3 > orgxs) {
                    this.mySizeY += bordertop;
                    xx = 0;
                    yy = this.mySizeY;
                    xa2 = xx;
                    ya2 = yy;
                    dbtable.setX(xa2);
                    dbtable.setY(ya2);
                    xe3 = xa2 + xs2 + fkcnt * fkraster + fkraster;
                    ye3 = ya2 + ys2;
                    xx = xe3;
                }
                this.mySizeX = xe3 > this.mySizeX ? xe3 : this.mySizeX;
                this.mySizeY = ye3 > this.mySizeY ? ye3 : this.mySizeY;
            }
            this.mySizeX += blackborder + borderleft + borderright + blackborder + shadowx;
            this.mySizeY += blackborder + bordertop + borderbottom + blackborder + shadowy + fontheight4name;
            int x0 = blackborder + borderleft;
            int y0 = blackborder + bordertop + fontheight4name;
            MLogger.deb((String)("  size: " + this.mySizeX + "/" + this.mySizeY));
            MLogger.deb((String)"  create...");
            this.myImageBuffer.newImage(this.mySizeX, this.mySizeY);
            this.myImageBuffer.setColor(Color.black);
            this.myImageBuffer.printat(0, 0 + dbmodel.getLineDelta(), this.getName());
            this.myImageBuffer.drawRectWH(0, fontheight4name + 0, this.mySizeX - shadowx, blackborder);
            this.myImageBuffer.drawRectWH(0, fontheight4name + 0, blackborder, this.mySizeY - shadowy - fontheight4name);
            this.myImageBuffer.drawRectWH(this.mySizeX - shadowx - blackborder, fontheight4name + 0, blackborder, this.mySizeY - shadowy - fontheight4name);
            this.myImageBuffer.drawRectWH(0, this.mySizeY - shadowy - blackborder, this.mySizeX - shadowx, blackborder);
            if (shadowx > 0 || shadowy > 0) {
                this.myImageBuffer.setColor(SHADOW);
                if (shadowx > 0) {
                    this.myImageBuffer.fillRect(this.mySizeX - shadowx, fontheight4name + shadowy, shadowx, this.mySizeY - shadowy - fontheight4name);
                }
                if (shadowy > 0) {
                    this.myImageBuffer.fillRect(shadowx, this.mySizeY - shadowy, this.mySizeX - shadowx, shadowy);
                }
                this.myImageBuffer.setColor(Color.black);
            }
            for (i2 = 0; i2 < mcnt; ++i2) {
                DBModul dbmodul3 = (DBModul)this.myModuls.get(i2);
                x = dbmodul3.getX();
                y = dbmodul3.getY();
                this.myImageBuffer.drawImageBuffer(dbmodul3.getImageBuffer(), x0 + x, y0 + y);
            }
            for (i2 = 0; i2 < tcnt; ++i2) {
                DBTable dbtable = (DBTable)this.myTables.get(i2);
                x = dbtable.getX();
                y = dbtable.getY();
                this.myImageBuffer.drawImageBuffer(dbtable.getImageBuffer(), x0 + x, y0 + y);
            }
            MLogger.deb((String)"  fk's...");
            this.calcAbs(x0, y0, fontheight4name, dbmodel);
            this.runFKs(this.myImageBuffer, this, dbmodel);
            MLogger.deb((String)" Full picture: Ok.");
            int size = mcnt + tcnt;
            DBImgBase[] ia = new DBImgBase[size];
            for (i = 0; i < mcnt; ++i) {
                DBModul dbmodul4 = (DBModul)this.myModuls.get(i);
                ia[i] = dbmodul4;
            }
            for (i = 0; i < tcnt; ++i) {
                DBTable dbtable = (DBTable)this.myTables.get(i);
                ia[i + mcnt] = dbtable;
            }
            for (i = 0; i < size; ++i) {
                DBImgBase ib = ia[i];
                String typeb = ib instanceof DBModul ? "Modul" : "Table";
                String nameb = ib instanceof DBModul ? ((DBModul)ib).getName() : ((DBTable)ib).getDBTableName();
                for (int j = i + 1; j < size; ++j) {
                    DBImgBase ic = ia[j];
                    if (!ib.intersects(ic)) continue;
                    String typec = ic instanceof DBModul ? "Modul" : "Table";
                    String namec = ic instanceof DBModul ? ((DBModul)ic).getName() : ((DBTable)ic).getDBTableName();
                    MLogger.wrn((String)(typeb + " " + nameb + " intersects " + typec + " " + namec));
                    Insets r = ib.intersection(ic);
                    this.myImageBuffer.setColor(Color.RED);
                    this.myImageBuffer.drawRectWH(x0 + r.left, y0 + r.top, r.right, r.bottom);
                    this.myImageBuffer.drawRectWH(x0 + r.left - 1, y0 + r.top - 1, r.right + 2, r.bottom + 2);
                }
            }
        }

        public void calcAbs(int x0, int y0, int fontheight4name, DBModel dbmodel) {
            int blackborder = dbmodel.getBlackBorder();
            int borderleft = dbmodel.getBorderLeft();
            int bordertop = dbmodel.getBorderTop();
            int mcnt = this.myModuls.size();
            for (int i = 0; i < mcnt; ++i) {
                DBModul dbmodul = (DBModul)this.myModuls.get(i);
                dbmodul.calcAbs(x0 + dbmodul.getX() + blackborder + borderleft, y0 + dbmodul.getY() + blackborder + bordertop + fontheight4name, fontheight4name, dbmodel);
            }
            int tcnt = this.myTables.size();
            for (int i = 0; i < tcnt; ++i) {
                DBTable dbtable = (DBTable)this.myTables.get(i);
                dbtable.calcAbs(x0 + dbtable.getX(), y0 + dbtable.getY(), dbmodel);
            }
        }

        protected void runFKs(ImageBuffer ib, DBModBase base, DBModel dbmodel) throws Exception {
            int mcnt = this.myModuls.size();
            for (int i = 0; i < mcnt; ++i) {
                DBModul dbmodul = (DBModul)this.myModuls.get(i);
                dbmodul.runFKs(ib, base, dbmodel);
            }
            int tcnt = this.myTables.size();
            for (int i = 0; i < tcnt; ++i) {
                DBTable dbtable = (DBTable)this.myTables.get(i);
                dbtable.runFKs(ib, base, dbmodel);
            }
        }

        protected DBTable findDBTable(String name) {
            DBTable dbtable;
            int mcnt = this.myModuls.size();
            for (int i = 0; i < mcnt; ++i) {
                DBModul dbmodul = (DBModul)this.myModuls.get(i);
                dbtable = dbmodul.findDBTable(name);
                if (dbtable == null) continue;
                return dbtable;
            }
            int tcnt = this.myTables.size();
            for (int i = 0; i < tcnt; ++i) {
                dbtable = (DBTable)this.myTables.get(i);
                if (!dbtable.getDBTableName().equals(name)) continue;
                return dbtable;
            }
            return null;
        }

        protected void savesub(String dst, String name, DBModel dbmodel) throws Exception {
            int mcnt = this.myModuls.size();
            for (int i = 0; i < mcnt; ++i) {
                DBModul dbmodul = (DBModul)this.myModuls.get(i);
                dbmodul.save(dst + name, dbmodel);
            }
            int tcnt = this.myTables.size();
            for (int i = 0; i < tcnt; ++i) {
                DBTable dbtable = (DBTable)this.myTables.get(i);
                dbtable.save(dst + name, dbmodel);
            }
            MLogger.deb((String)"  Save full picture...");
            ImageRenderer.saveImage(dst + dbmodel.getImagePrefix() + name + "." + dbmodel.getImageType().toLowerCase(), this.myImageBuffer.getImage());
            MLogger.deb((String)"  Save full picture: Ok.");
        }
    }

    public static class DBTable
    extends DBImgBase {
        protected int myAbsX = -1;
        protected int myAbsY = -1;
        private String myDBTableName;
        private Vector myFields = new Vector();

        public DBTable() {
        }

        public DBTable(String dbtablename, int x, int y) {
            this.myDBTableName = dbtablename;
            this.myX = x;
            this.myY = y;
        }

        public int getAbsX() {
            return this.myAbsX;
        }

        public int getAbsY() {
            return this.myAbsY;
        }

        public String getDBTableName() {
            return this.myDBTableName;
        }

        public void setDBTableName(String dbtablename) {
            this.myDBTableName = dbtablename;
        }

        public void addDBField(DBField dbfield) {
            this.myFields.add(dbfield);
        }

        public void addDBField(int i, DBField dbfield) {
            this.myFields.add(i, dbfield);
        }

        public void load(XMLTag t, DBModel dbmodel) {
            this.myDBTableName = this.loadString(t, "dbtablename", "???");
            MLogger.deb((String)("  DBTable: " + this.myDBTableName));
            this.myX = this.loadInt(t, "x", -1) * dbmodel.getRaster();
            this.myY = this.loadInt(t, "y", -1) * dbmodel.getRaster();
        }

        public void load(XMLScanner xs) throws Exception {
            XMLTag t;
            while ((t = xs.getLeafStart("field")) != null) {
                DBField dbfield = new DBField();
                dbfield.load(t);
                this.myFields.add(dbfield);
                t = xs.getLeafEnd("field");
                if (t != null) continue;
                throw new Exception("Missing </field>.");
            }
        }

        public int getFKCount() {
            int res = 0;
            int fcnt = this.myFields.size();
            for (int i = 0; i < fcnt; ++i) {
                DBField dbfield = (DBField)this.myFields.get(i);
                if (!dbfield.getDBFieldFK()) continue;
                ++res;
            }
            return res;
        }

        public void run(DBModel dbmodel) {
            MLogger.deb((String)("  DBTable: " + this.myDBTableName));
            int fcnt = this.myFields.size();
            int width = 0;
            int fontheight = this.myImageBuffer.getHeight();
            int fontwidth = this.myImageBuffer.getHeight();
            int blackborder = dbmodel.getBlackBorder();
            int whiteborder = dbmodel.getWhiteBorder();
            int shadowx = dbmodel.getShadowX();
            int shadowy = dbmodel.getShadowY();
            int lineadd = dbmodel.getLineAdd();
            int lineheight = fontheight + lineadd;
            int lineadd1 = lineadd / 2;
            int lineadd2 = lineheight - fontheight - lineadd1;
            int linedelta = dbmodel.getLineDelta();
            int pk = fontheight + lineadd;
            int xt = blackborder + whiteborder + pk + fontheight / 4;
            int yt = fontheight + blackborder + whiteborder;
            int x = xt;
            int y = yt;
            int x0 = 0;
            int y0 = fontheight;
            boolean wasPK = false;
            for (int i = 0; i < fcnt; ++i) {
                DBField dbfield = (DBField)this.myFields.get(i);
                boolean isPK = dbfield.getDBFieldPK();
                if (i != 0 && wasPK != isPK) {
                    y += whiteborder + blackborder + whiteborder;
                }
                wasPK = isPK;
                dbfield.setX(x);
                dbfield.setY(y);
                dbfield.calcSize(this.myImageBuffer);
                int dx = dbfield.getSizeX();
                int mw = dbmodel.getMinWidth();
                dx = dx > mw ? dx : mw;
                width = dx > width ? dx : width;
                y += lineheight;
            }
            this.mySizeX = x + width + fontwidth + whiteborder + blackborder + shadowx;
            this.mySizeY = y + whiteborder + blackborder + shadowy;
            this.myImageBuffer.newImage(this.mySizeX, this.mySizeY);
            try {
                this.myImageBuffer.setColor(Color.black);
                this.myImageBuffer.printat(0, 0 + linedelta, this.myDBTableName);
                int dx = this.mySizeX - shadowx;
                int dy = this.mySizeY - shadowy - y0;
                this.myImageBuffer.drawRectWH(x0, y0, dx, blackborder);
                this.myImageBuffer.drawRectWH(x0, y0, blackborder, dy);
                this.myImageBuffer.drawRectWH(dx - blackborder, y0, blackborder, dy);
                this.myImageBuffer.drawRectWH(x0, y0 + dy - blackborder, dx, blackborder);
                if (shadowx > 0 || shadowy > 0) {
                    this.myImageBuffer.setColor(SHADOW);
                    if (shadowx > 0) {
                        this.myImageBuffer.fillRect(dx, y0 + shadowy, shadowx, dy);
                    }
                    if (shadowy > 0) {
                        this.myImageBuffer.fillRect(x0 + shadowx, y0 + dy, dx, shadowy);
                    }
                    this.myImageBuffer.setColor(Color.black);
                }
                x = xt;
                y = yt;
                int xpk = blackborder + whiteborder;
                wasPK = false;
                for (int i = 0; i < fcnt; ++i) {
                    DBField dbfield = (DBField)this.myFields.get(i);
                    boolean isPK = dbfield.getDBFieldPK();
                    if (isPK) {
                        Image pki = dbmodel.getPKImage(pk - 2, pk - 2);
                        if (pki != null) {
                            this.myImageBuffer.drawImageCenter(pki, blackborder + whiteborder + 1, y + 1, pk - 2, pk - 2);
                        } else {
                            MLogger.wrn((String)"Missing PK-Image!");
                        }
                    }
                    if (i != 0 && wasPK != isPK) {
                        this.myImageBuffer.drawRectWH(blackborder + whiteborder, y += whiteborder, dx - 2 * blackborder - 2 * whiteborder, blackborder);
                        y += blackborder + whiteborder;
                    }
                    wasPK = isPK;
                    if (x != dbfield.getX() || y != dbfield.getY()) {
                        MLogger.wrn((String)("Coordinate missmatch (" + i + "): " + x + "/" + y + " <--> " + dbfield.getX() + "/" + dbfield.getY()));
                    }
                    this.myImageBuffer.printat(x, y + linedelta, dbfield.getDBFieldText());
                    y += lineheight;
                }
            }
            catch (Exception e) {
                MLogger.err((String)("Error while creating image for table " + this.myDBTableName + ": " + e.getMessage()), (Throwable)e);
            }
        }

        public void calcAbs(int x0, int y0, DBModel dbmodel) {
            this.myAbsX = x0;
            this.myAbsY = y0;
        }

        protected void drawPtr2Left(ImageBuffer ib, int xe, int ye, int ptrSize, int ptrWidth) throws Exception {
            for (int y = 1; y <= ptrWidth; ++y) {
                ib.drawLine(xe + 2 * y, ye - y, xe + ptrSize, ye - y);
                ib.drawLine(xe + 2 * y, ye + y, xe + ptrSize, ye + y);
            }
        }

        protected void drawPtr2Right(ImageBuffer ib, int xe, int ye, int ptrSize, int ptrWidth) throws Exception {
            for (int y = 1; y <= ptrWidth; ++y) {
                ib.drawLine(xe - 2 * y, ye - y, xe - ptrSize, ye - y);
                ib.drawLine(xe - 2 * y, ye + y, xe - ptrSize, ye + y);
            }
        }

        protected void drawPtr2Top(ImageBuffer ib, int xe, int ye, int ptrSize, int ptrWidth) throws Exception {
            for (int x = 1; x <= ptrWidth; ++x) {
                ib.drawLine(xe - x, ye + 2 * x, xe - x, ye + ptrSize);
                ib.drawLine(xe + x, ye + 2 * x, xe + x, ye + ptrSize);
            }
        }

        protected void drawPtr2Bottom(ImageBuffer ib, int xe, int ye, int ptrSize, int ptrWidth) throws Exception {
            for (int x = 1; x <= ptrWidth; ++x) {
                ib.drawLine(xe - x, ye - 2 * x, xe - x, ye - ptrSize);
                ib.drawLine(xe + x, ye - 2 * x, xe + x, ye - ptrSize);
            }
        }

        protected void drawLine2(ImageBuffer ib, int xa, int ya, int xe, int ye) throws Exception {
            int d = 4;
            int xx = xe > xa ? xe - d : xe + d;
            int yy = ye > ya ? ya + d : ya - d;
            ib.drawLine(xa, ya, xx, ya);
            ib.drawLine(xx, ya, xe, yy);
            ib.drawLine(xe, yy, xe, ye);
        }

        protected void drawLine3(ImageBuffer ib, int xa, int ya, int xe, int ye, int xm) throws Exception {
            int d = 4;
            int xx1 = xm > xa ? xm - d : xm + d;
            int xx2 = xe > xm ? xm + d : xm - d;
            int yy1 = ye > ya ? ya + d : ya - d;
            int yy2 = ye > ya ? ye - d : ye + d;
            ib.drawLine(xa, ya, xx1, ya);
            ib.drawLine(xx1, ya, xm, yy1);
            ib.drawLine(xm, yy1, xm, yy2);
            ib.drawLine(xm, yy2, xx2, ye);
            ib.drawLine(xx2, ye, xe, ye);
        }

        public void runFKs(ImageBuffer ib, DBModBase base, DBModel dbmodel) throws Exception {
            int shadowx = dbmodel.getShadowX();
            int shadowy = dbmodel.getShadowY();
            int fksright = 2;
            int fksleft = 2;
            int fcnt = this.myFields.size();
            for (int i = 0; i < fcnt; ++i) {
                int xm;
                int xe;
                int xa;
                DBField dbfield = (DBField)this.myFields.get(i);
                if (!dbfield.getDBFieldFK()) continue;
                String dbfieldfktablename = dbfield.getDBFieldFKTableName();
                String dbfieldfkfieldname = dbfield.getDBFieldFKFieldName();
                DBTable dbfieldfktable = base.findDBTable(dbfieldfktablename);
                if (dbfieldfktable == null) continue;
                int dstTableX0 = dbfieldfktable.getAbsX();
                int dstTableY0 = dbfieldfktable.getAbsY();
                int dstTableX1 = dstTableX0 + dbfieldfktable.getSizeX() - shadowx;
                int dstTableY1 = dstTableY0 + dbfieldfktable.getSizeY() - shadowy;
                int dstFieldY = dbfieldfktable.getFieldY(dbfieldfkfieldname);
                if (dstFieldY < 0) continue;
                dstFieldY += dstTableY0;
                int srcTableX0 = this.myAbsX;
                int srcTableY0 = this.myAbsY;
                int srcTableX1 = this.myAbsX + this.mySizeX - shadowx;
                int srcTableY1 = this.myAbsY + this.mySizeY - shadowy;
                int srcFieldY = srcTableY0 + dbfield.getY() + dbfield.getSizeY() / 2;
                int fkraster = dbmodel.getFKRaster();
                int deltax = 2 * fkraster;
                int deltay = 2 * fkraster;
                int fy = dbfield.getSizeY();
                int ptrSize = fy / 2;
                int ptrWidth = fy / 4;
                int dpk = fy / 3;
                int ya = srcFieldY;
                int ye = dstFieldY;
                if (dstTableX1 + shadowx + deltax <= srcTableX0) {
                    xa = srcTableX0;
                    xe = dstTableX1 - 1;
                    int n = srcFieldY > dstFieldY ? dpk : (srcFieldY < dstFieldY ? -dpk : 0);
                    xm = (xa + xe) / 2;
                    this.drawLine3(ib, xa, ya, xe, ye += n, xm);
                    this.drawPtr2Left(ib, xe, ye, ptrSize, ptrWidth);
                } else if (srcTableX1 + shadowx + deltax <= dstTableX0) {
                    xa = srcTableX1 - 1;
                    xe = dstTableX0;
                    int n = srcFieldY > dstFieldY ? dpk : (srcFieldY < dstFieldY ? -dpk : 0);
                    xm = (xa + xe) / 2;
                    this.drawLine3(ib, xa, ya, xe, ye += n, xm);
                    this.drawPtr2Right(ib, xe, ye, ptrSize, ptrWidth);
                } else if (dstTableY1 + shadowy + deltay <= srcFieldY && dstTableX0 + deltax <= srcTableX0) {
                    xa = srcTableX0;
                    xe = dstTableX0 + fkraster;
                    ye = dstTableY1 - 1;
                    this.drawLine2(ib, xa, ya, xe, ye);
                    this.drawPtr2Top(ib, xe, ye, ptrSize, ptrWidth);
                } else if (dstTableY1 + shadowy + deltay <= srcFieldY && srcTableX1 + shadowx + deltax <= dstTableX1) {
                    xa = srcTableX1 - 1;
                    xe = dstTableX1 - fkraster;
                    ye = dstTableY1 - 1;
                    this.drawLine2(ib, xa, ya, xe, ye);
                    this.drawPtr2Top(ib, xe, ye, ptrSize, ptrWidth);
                } else if (dstFieldY <= srcFieldY) {
                    xa = srcTableX1 - 1;
                    xe = dstTableX1 - 1;
                    int n = srcFieldY > dstFieldY ? dpk : (srcFieldY < dstFieldY ? -dpk : 0);
                    xm = Math.max(srcTableX1 + shadowx + fksright * fkraster, dstTableX1 + shadowx + fkraster);
                    ++fksright;
                    this.drawLine3(ib, xa, ya, xe, ye += n, xm);
                    this.drawPtr2Left(ib, xe, ye, ptrSize, ptrWidth);
                } else if (srcTableY1 + shadowy + deltay <= dstFieldY && srcTableX1 + shadowx + deltax <= dstTableX1) {
                    MLogger.deb((String)("     TopLeft: " + this.myDBTableName + "." + dbfield.getDBFieldName()));
                    xa = srcTableX1 - 1;
                    xe = dstTableX1 - fkraster;
                    ye = dstTableY0 + fy;
                    this.drawLine2(ib, xa, ya, xe, ye);
                    this.drawPtr2Bottom(ib, xe, ye, ptrSize, ptrWidth);
                } else if (srcFieldY <= dstFieldY) {
                    MLogger.deb((String)("     TopMiddle: " + this.myDBTableName + "." + dbfield.getDBFieldName()));
                    xa = srcTableX0;
                    xe = dstTableX0;
                    int n = srcFieldY > dstFieldY ? dpk : (srcFieldY < dstFieldY ? -dpk : 0);
                    xm = Math.min(srcTableX0 - fksleft * fkraster, dstTableX0 - fkraster);
                    ++fksleft;
                    this.drawLine3(ib, xa, ya, xe, ye += n, xm);
                    this.drawPtr2Right(ib, xe, ye, ptrSize, ptrWidth);
                } else {
                    MLogger.wrn((String)("      Can't route FK: " + this.myDBTableName + "." + dbfield.getDBFieldName()));
                    xa = srcTableX0;
                    xe = dstTableX0;
                    ib.drawLine(xa, ya, xe, ye);
                }
                if (dbfield.getDBFieldNull()) {
                    ib.drawLine(xa - 1, ya - 2, xa + 1, ya - 2);
                    ib.drawLine(xa - 1, ya + 2, xa + 1, ya + 2);
                    ib.drawLine(xa - 2, ya - 1, xa - 2, ya + 1);
                    ib.drawLine(xa + 2, ya - 1, xa + 2, ya + 1);
                    continue;
                }
                ib.drawLine(xa - 1, ya - 2, xa + 1, ya - 2);
                for (int y = -1; y <= 1; ++y) {
                    ib.drawLine(xa - 2, ya + y, xa + 2, ya + y);
                }
                ib.drawLine(xa - 1, ya + 2, xa + 1, ya + 2);
            }
        }

        public int getFieldY(String name) {
            int fcnt = this.myFields.size();
            for (int i = 0; i < fcnt; ++i) {
                DBField dbfield = (DBField)this.myFields.get(i);
                if (!dbfield.getDBFieldName().equals(name)) continue;
                return dbfield.getY() + dbfield.getSizeY() / 2;
            }
            return -1;
        }

        public void save(String dst, DBModel dbmodel) {
            dst = dst + File.separator + dbmodel.getImagePrefix() + this.myDBTableName.toLowerCase() + "." + dbmodel.getImageType().toLowerCase();
            MLogger.deb((String)("  DBTable: " + this.myDBTableName + " --> " + dst));
            try {
                ImageRenderer.saveImage(dst, this.myImageBuffer.getImage());
            }
            catch (Exception e) {
                MLogger.err((String)("Error while saving image for table " + this.myDBTableName + ": " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static class DBImgBase
    extends DBBase {
        protected static final Color SHADOW = new Color(136, 136, 136);
        protected ImageBuffer myImageBuffer = new ImageBuffer();

        public boolean intersects(DBImgBase r) {
            int tw = this.mySizeX;
            int th = this.mySizeY;
            int rw = r.mySizeX;
            int rh = r.mySizeY;
            if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
                return false;
            }
            int tx = this.myX;
            int ty = this.myY;
            int rx = r.myX;
            int ry = r.myY;
            rh += ry;
            tw += tx;
            th += ty;
            return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
        }

        public Insets intersection(DBImgBase r) {
            int tx1 = this.myX;
            int ty1 = this.myY;
            int rx1 = r.myX;
            int ry1 = r.myY;
            long tx2 = tx1;
            tx2 += (long)this.mySizeX;
            long ty2 = ty1;
            ty2 += (long)this.mySizeY;
            long rx2 = rx1;
            rx2 += (long)r.mySizeX;
            long ry2 = ry1;
            ry2 += (long)r.mySizeY;
            if (tx1 < rx1) {
                tx1 = rx1;
            }
            if (ty1 < ry1) {
                ty1 = ry1;
            }
            if (tx2 > rx2) {
                tx2 = rx2;
            }
            if (ty2 > ry2) {
                ty2 = ry2;
            }
            ty2 -= (long)ty1;
            if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
                tx2 = Integer.MIN_VALUE;
            }
            if (ty2 < Integer.MIN_VALUE) {
                ty2 = Integer.MIN_VALUE;
            }
            return new Insets(ty1, tx1, (int)ty2, (int)tx2);
        }

        public ImageBuffer getImageBuffer() {
            return this.myImageBuffer;
        }
    }

    public static class DBField
    extends DBBase {
        private String myDBFieldName;
        private String myDBFieldType;
        private String myDBFieldNull;
        private boolean myDBFieldPK;
        private boolean myDBFieldID;
        private boolean myDBFieldOCA;
        private boolean myDBFieldFK;
        private String myDBFieldFKTableName;
        private String myDBFieldFKFieldName;
        private String myDBFieldFKOnDelete;
        private String myDBFieldText;

        public DBField() {
        }

        public DBField(String dbfieldname, String dbfieldtype, String dbfieldnull, String dbfieldpk, String dbfieldid, String dbfieldoca, String dbfieldfk, String dbfieldfktablename, String dbfieldfkfieldname, String dbfieldfkondelete) {
            this.myDBFieldName = dbfieldname;
            this.myDBFieldType = dbfieldtype;
            this.myDBFieldNull = dbfieldnull;
            this.myDBFieldPK = "yes".equals(dbfieldpk);
            this.myDBFieldID = "yes".equals(dbfieldid);
            this.myDBFieldOCA = "yes".equals(dbfieldoca);
            this.myDBFieldFK = "yes".equals(dbfieldfk);
            this.myDBFieldFKTableName = dbfieldfktablename;
            this.myDBFieldFKFieldName = dbfieldfkfieldname;
            this.myDBFieldFKOnDelete = dbfieldfkondelete;
        }

        public String getDBFieldName() {
            return this.myDBFieldName;
        }

        public boolean getDBFieldNull() {
            return !"no".equals(this.myDBFieldNull);
        }

        public boolean getDBFieldPK() {
            return this.myDBFieldPK;
        }

        public boolean getDBFieldFK() {
            return this.myDBFieldFK;
        }

        public String getDBFieldFKTableName() {
            return this.myDBFieldFKTableName;
        }

        public String getDBFieldFKFieldName() {
            return this.myDBFieldFKFieldName;
        }

        public String getDBFieldText() {
            if (this.myDBFieldText == null) {
                this.myDBFieldText = this.myDBFieldName + ": " + this.myDBFieldType + ("no".equals(this.myDBFieldNull) ? " NOT" : "") + " NULL" + (this.myDBFieldPK ? " (PK)" : "") + (this.myDBFieldID ? " (ID)" : "") + (this.myDBFieldFK ? " (FK:" + (this.myDBFieldFKOnDelete != null ? this.myDBFieldFKOnDelete.toUpperCase() : "RESTRICT") + ")" : "") + (this.myDBFieldOCA ? " (OCA)" : "");
            }
            return this.myDBFieldText;
        }

        public void load(XMLTag t) {
            this.myDBFieldName = this.loadString(t, "dbfieldname", "???");
            this.myDBFieldType = this.loadString(t, "dbfieldtype", "???");
            this.myDBFieldNull = this.loadString(t, "dbfieldnull", "yes");
            this.myDBFieldPK = this.loadBoolean(t, "dbfieldpk", false);
            this.myDBFieldID = this.loadBoolean(t, "dbfieldid", false);
            this.myDBFieldOCA = this.loadBoolean(t, "dbfieldoca", false);
            this.myDBFieldFK = this.loadBoolean(t, "dbfieldfk", false);
            this.myDBFieldFKTableName = this.loadString(t, "dbfieldfktablename", null);
            this.myDBFieldFKFieldName = this.loadString(t, "dbfieldfkfieldname", null);
            this.myDBFieldFKOnDelete = this.loadString(t, "dbfieldfkondelete", null);
            this.myDBFieldText = this.loadString(t, "dbfieldtext", "???");
        }

        public void calcSize(ImageBuffer ib) {
            this.mySizeX = ib.getWidth(this.getDBFieldText());
            this.mySizeY = ib.getHeight();
        }
    }

    public static class DBBase {
        protected int myX = -1;
        protected int myY = -1;
        protected int mySizeX;
        protected int mySizeY;

        public int getX() {
            return this.myX;
        }

        public void setX(int x) {
            this.myX = x;
        }

        public int getY() {
            return this.myY;
        }

        public void setY(int y) {
            this.myY = y;
        }

        public int getSizeX() {
            return this.mySizeX;
        }

        public int getSizeY() {
            return this.mySizeY;
        }

        public boolean loadBoolean(XMLTag t, String name, boolean std) {
            String s = t.getAttr(name);
            if (s == null) {
                return std;
            }
            return s.equals("yes");
        }

        public String loadString(XMLTag t, String name, String std) {
            return t.getAttr(name, std);
        }

        public int loadInt(XMLTag t, String name, int std) {
            return new Integer(t.getAttr(name, "" + std));
        }
    }
}

