/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.cts.UniTypeConv;
import com.sta.cts.XMLScanner;
import com.sta.cts.XMLTag;
import com.sta.mimages.ImageBuffer;
import com.sta.mimages.ImageRenderer;
import com.sta.mimages.MImages;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;

public class MImagesTPM
extends MImages {
    private static Hashtable statImageIconsLarge = new Hashtable();
    private static Hashtable statImageIconsSmall = new Hashtable();
    private static int statSimpleFrameLeft = 20;
    private static int statSimpleFrameRight = 20;
    private static int statSimpleFrameTop = 20;
    private static int statSimpleFrameBottom = 20;
    private static int statMultiFrameLeft = 20;
    private static int statMultiFrameRight = 20;
    private static int statMultiFrameTop = 10;
    private static int statMultiFrameBottom = 10;
    private static int statInsetFrameLeft = 10;
    private static int statInsetFrameRight = 10;
    private static int statInsetFrameTop = 10;
    private static int statInsetFrameBottom = 10;
    private static int statPointerWidth = 3;
    private static int statPointerLength = 8;
    private static int statNameGap = 5;
    private static int statTableFrameShadowSize = 2;
    private static int statPLFrameShadowSize = 2;
    private static int statPLPFrameShadowSize = 2;
    private static String statImagePrefix = "app_";
    private static String statImageType = "PNG";
    private static boolean statExpandAssign = true;
    private static Vector statTPMImageModels = new Vector();
    private static String statPrjName;

    public static ImageIcon getCellIcon4Type(String typename, boolean check4large) {
        ImageIcon icon = null;
        if (typename != null && (icon = (ImageIcon)(check4large ? statImageIconsLarge : statImageIconsSmall).get(typename)) == null) {
            String iconname = null;
            iconname = typename.equals("Model") || typename.equals("Modul") || typename.equals("Table") ? "xmodels_techproc" + typename.toLowerCase() : (typename.equals("Cron") ? "cronentry" : (typename.endsWith("PL") ? "xmodels_techprocline_" + typename.replaceFirst("PL", "").toLowerCase() : "xmodels_techprocpart_" + typename.toLowerCase()));
            if (check4large && (icon = MImagesTPM.loadImageIcon("resources/icons/" + iconname + "_large.png")) == null) {
                icon = MImagesTPM.loadImageIcon("../gen/source/icons/" + iconname + "_large.png");
            }
            if (icon == null && (icon = MImagesTPM.loadImageIcon("resources/icons/" + iconname + ".png")) == null) {
                icon = MImagesTPM.loadImageIcon("../gen/source/icons/" + iconname + ".png");
            }
            (check4large ? statImageIconsLarge : statImageIconsSmall).put(typename, icon);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load(String fn) throws Exception {
        XMLScanner xs = new XMLScanner();
        xs.init(fn);
        try {
            xs.initH(null);
            XMLTag t = xs.getLeafStart("root");
            if (t == null) {
                throw new Exception("Missing <root>.");
            }
            statPrjName = t.getAttr("prjname");
            MLogger.deb((String)("Project: " + statPrjName));
            while ((t = xs.getLeafStart("model")) != null) {
                TPMImageModel tpmmodel = new TPMImageModel();
                tpmmodel.load(t, xs);
                statTPMImageModels.add(tpmmodel);
                t = xs.getLeafEnd("model");
                if (t != null) continue;
                throw new Exception("Missing </model>.");
            }
            t = xs.getLeafEnd("root");
            if (t == null) {
                throw new Exception("Missing </root>.");
            }
        }
        finally {
            xs.done();
        }
    }

    public static void run() throws Exception {
        int mcnt = statTPMImageModels.size();
        for (int i = 0; i < mcnt; ++i) {
            TPMImageModel tpmmodel = (TPMImageModel)statTPMImageModels.get(i);
            tpmmodel.run(false, false);
        }
    }

    public static void save(String dst, String pre) throws Exception {
        if (pre != null) {
            statImagePrefix = pre;
        }
        int mcnt = statTPMImageModels.size();
        for (int i = 0; i < mcnt; ++i) {
            TPMImageModel tpmmodel = (TPMImageModel)statTPMImageModels.get(i);
            tpmmodel.save(dst);
        }
    }

    public static void run(String fn, String dst, String pre, Vector params) throws Exception {
        MLogger.deb((String)"***** load *****");
        MImagesTPM.load(fn);
        if (params != null && params.size() > 0) {
            MLogger.deb((String)"***** filter *****");
            int mcnt = statTPMImageModels.size();
            for (int i = 0; i < mcnt; ++i) {
                TPMImageModel tpmmodel = (TPMImageModel)statTPMImageModels.get(i);
                tpmmodel.filter(params);
            }
        }
        MLogger.deb((String)"***** run *****");
        MImagesTPM.run();
        MLogger.deb((String)"***** save *****");
        MImagesTPM.save(dst, pre);
        MLogger.deb((String)"***** ok *****");
    }

    public static void run(String fn, String dst, String pre) throws Exception {
        MImagesTPM.run(fn, dst, pre, null);
    }

    protected static void checkExpandAssign(Vector params) {
        String s = MImagesTPM.getNextParam(params);
        if ("-expandassign".equals(s)) {
            statExpandAssign = false;
        } else if (s != null) {
            params.add(0, s);
        }
    }

    public static void run(Vector params) {
        String fn = MImagesTPM.getNextParam(params);
        if (fn == null) {
            MLogger.err((String)"Missing file name.");
            return;
        }
        String dst = MImagesTPM.getNextParam(params);
        if (dst == null) {
            dst = ".";
        }
        if (dst.endsWith("/") || dst.endsWith("\\")) {
            dst = dst.substring(0, dst.length() - 1);
        }
        String pre = MImagesTPM.getNextParam(params);
        try {
            MImagesTPM.checkExpandAssign(params);
            MImagesTPM.run(fn, dst, pre, params);
        }
        catch (Exception e) {
            MLogger.err((String)("While processing: " + e.getMessage()), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        MLogger.msg((String)"MImagesTPM  Version 1.44  Copyright (c) 2005-2023 >StA-Soft<");
        Vector<String> params = new Vector<String>(Arrays.asList(args));
        MImagesTPM.checkLogLevel(params);
        MImagesTPM.run(params);
        System.exit(0);
    }

    public static class TPMImageModel
    extends TPMImageModBase {
        protected String myModelName;

        public TPMImageModel() {
        }

        public TPMImageModel(String modelname) {
            this.myModelName = modelname;
        }

        public String getModelName() {
            return this.myModelName;
        }

        @Override
        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.myModelName = t.getAttr("techprocmodelname");
            super.load(t, xs);
        }

        public void run(boolean genimg, boolean onlythisimg) {
            MLogger.deb((String)("Model: " + this.myModelName));
            super.run(genimg, onlythisimg, this.myModelName);
        }

        @Override
        public void save(String dst) throws Exception {
            String name = this.myModelName.toLowerCase();
            String dir = dst + File.separator + name;
            new File(dir).mkdirs();
            MLogger.deb((String)("Model: " + this.myModelName + " --> " + dir));
            super.save(dir);
            BufferedImage img = this.myImageBuffer.getImage();
            if (img != null) {
                MLogger.deb((String)("Model: " + this.myModelName + " (*)"));
                ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), img);
                this.resImageBuffer();
            }
        }
    }

    public static class TPMImageModul
    extends TPMImageModBase {
        protected String myModulName;

        public TPMImageModul() {
        }

        public TPMImageModul(String modulname) {
            this.myModulName = modulname;
        }

        public String getModulName() {
            return this.myModulName;
        }

        @Override
        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.myModulName = t.getAttr("modulname");
            super.load(t, xs);
        }

        public void run(boolean genimg, boolean onlythisimg) {
            MLogger.deb((String)("Modul: " + this.myModulName));
            super.run(genimg, onlythisimg, this.myModulName);
        }

        @Override
        public void save(String dst) throws Exception {
            String name = this.myModulName.toLowerCase();
            String dir = dst + File.separator + name;
            new File(dir).mkdirs();
            MLogger.deb((String)("Modul: " + this.myModulName + " --> " + dir));
            super.save(dir);
            BufferedImage img = this.myImageBuffer.getImage();
            if (img != null) {
                MLogger.deb((String)("Modul: " + this.myModulName + " (*)"));
                ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), img);
                this.resImageBuffer();
            }
        }
    }

    public static class TPMImageModBase
    extends TPMImageBase {
        protected Vector myModuls = new Vector();
        protected Vector myTables = new Vector();
        protected Vector myPLs = new Vector();

        public void filter(Vector params) {
            String name;
            if (params != null && params.size() > 0 && (name = MImages.getNextParam(params)) != null) {
                boolean neg = false;
                if (name.startsWith("!")) {
                    neg = true;
                    name = name.substring(1);
                }
                int mcnt = this.myModuls.size();
                for (int i = 0; i < mcnt; ++i) {
                    TPMImageModul modul = (TPMImageModul)this.myModuls.get(i);
                    String mname = modul.getModulName();
                    if (!neg && name.equals(mname) || neg && !name.equals(mname)) {
                        modul.filter(params);
                        continue;
                    }
                    this.myModuls.remove(i);
                    --i;
                    --mcnt;
                }
                int tcnt = this.myTables.size();
                for (int i = 0; i < tcnt; ++i) {
                    TPMImageTable table = (TPMImageTable)this.myTables.get(i);
                    String tname = table.getTableName();
                    if (!neg && name.equals(tname) || neg && !name.equals(tname)) continue;
                    this.myTables.remove(i);
                    --i;
                    --tcnt;
                }
                int plcnt = this.myPLs.size();
                for (int i = 0; i < plcnt; ++i) {
                    TPMImagePL pl = (TPMImagePL)this.myPLs.get(i);
                    String plname = pl.getPLName();
                    if (!neg && name.equals(plname) || neg && !name.equals(plname)) continue;
                    this.myPLs.remove(i);
                    --i;
                    --plcnt;
                }
            }
        }

        public void addModul(TPMImageModul modul) {
            this.myModuls.add(modul);
        }

        public void addTable(TPMImageTable table) {
            this.myTables.add(table);
        }

        public void addPL(TPMImagePL pl) {
            this.myPLs.add(pl);
        }

        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.overreadICD(xs);
            while ((t = xs.getLeafStart("modul")) != null) {
                String modulop = t.getAttr("modulop");
                TPMImageModul tpmmodul = new TPMImageModul();
                tpmmodul.load(t, xs);
                if (!"del".equals(modulop)) {
                    this.myModuls.add(tpmmodul);
                }
                xs.getLeafEnd("modul");
            }
            while ((t = xs.getLeafStart("table")) != null) {
                String tableop = t.getAttr("tableop");
                TPMImageTable tpmtable = new TPMImageTable();
                tpmtable.load(t, xs);
                if (!"del".equals(tableop)) {
                    this.myTables.add(tpmtable);
                }
                xs.getLeafEnd("table");
            }
            while ((t = xs.getLeafStart("pl")) != null) {
                String pltype = t.getAttr("pltype");
                TPMImagePL tpmpl = new TPMImagePL();
                tpmpl.load(t, xs);
                if (!"DelPL".equals(pltype)) {
                    this.myPLs.add(tpmpl);
                }
                xs.getLeafEnd("pl");
            }
        }

        public void run(boolean genimg, boolean onlythisimg, String name) {
            int mcnt = this.myModuls.size();
            for (int i = 0; i < mcnt; ++i) {
                ((TPMImageModul)this.myModuls.get(i)).run(genimg, onlythisimg);
            }
            int tcnt = this.myTables.size();
            for (int i = 0; i < tcnt; ++i) {
                ((TPMImageTable)this.myTables.get(i)).run(genimg, onlythisimg);
            }
            int plcnt = this.myPLs.size();
            for (int i = 0; i < plcnt; ++i) {
                ((TPMImagePL)this.myPLs.get(i)).run();
            }
            if (genimg) {
                int i;
                int sizey;
                int sizex;
                ImageBuffer img;
                int i2;
                ImageIcon icon = MImagesTPM.getCellIcon4Type(this instanceof TPMImageModel ? "Model" : "Modul", this.check4large);
                int iconwidth = icon != null ? icon.getIconWidth() : 16;
                int iconheight = icon != null ? icon.getIconHeight() : 16;
                int textwidth = this.getWidthX(name, null);
                this.mySizeX = iconwidth + statNameGap + textwidth;
                this.mySizeY = statMultiFrameTop + statInsetFrameTop + iconheight;
                for (i2 = 0; i2 < mcnt; ++i2) {
                    TPMImageModul modul = (TPMImageModul)this.myModuls.get(i2);
                    img = modul.getImageBuffer();
                    if (img == null) continue;
                    sizex = modul.getSizeX();
                    sizey = modul.getSizeY();
                    if (sizex > this.mySizeX) {
                        this.mySizeX = sizex;
                    }
                    this.mySizeY += sizey;
                }
                for (i2 = 0; i2 < tcnt; ++i2) {
                    TPMImageTable table = (TPMImageTable)this.myTables.get(i2);
                    img = table.getImageBuffer();
                    if (img == null) continue;
                    sizex = table.getSizeX();
                    sizey = table.getSizeY();
                    if (sizex > this.mySizeX) {
                        this.mySizeX = sizex;
                    }
                    this.mySizeY += sizey;
                }
                for (i2 = 0; i2 < plcnt; ++i2) {
                    TPMImagePL pl = (TPMImagePL)this.myPLs.get(i2);
                    img = pl.getImageBuffer();
                    if (img == null) continue;
                    sizex = pl.getSizeX();
                    sizey = pl.getSizeY();
                    if (sizex > this.mySizeX) {
                        this.mySizeX = sizex;
                    }
                    this.mySizeY += sizey;
                }
                this.mySizeX += statMultiFrameLeft + statInsetFrameLeft + statInsetFrameRight + statMultiFrameRight;
                this.mySizeY += statInsetFrameBottom + statMultiFrameBottom;
                this.myImageBuffer.newImage(this.mySizeX, this.mySizeY);
                int x = statMultiFrameLeft + statInsetFrameLeft;
                int y = statMultiFrameTop + statInsetFrameTop;
                this.drawIconX(icon, x, y, iconwidth, iconheight, name, null, null, null);
                y += iconheight;
                for (i = 0; i < mcnt; ++i) {
                    TPMImageModul modul = (TPMImageModul)this.myModuls.get(i);
                    ImageBuffer img2 = modul.getImageBuffer();
                    if (img2 == null) continue;
                    this.myImageBuffer.drawImageBuffer(modul.getImageBuffer(), x, y);
                    if (onlythisimg) {
                        modul.resImageBuffer();
                    }
                    y += modul.getSizeY();
                }
                for (i = 0; i < tcnt; ++i) {
                    TPMImageTable table = (TPMImageTable)this.myTables.get(i);
                    ImageBuffer img3 = table.getImageBuffer();
                    if (img3 == null) continue;
                    this.myImageBuffer.drawImageBuffer(table.getImageBuffer(), x, y);
                    if (onlythisimg) {
                        table.resImageBuffer();
                    }
                    y += table.getSizeY();
                }
                for (i = 0; i < plcnt; ++i) {
                    TPMImagePL pl = (TPMImagePL)this.myPLs.get(i);
                    ImageBuffer img4 = pl.getImageBuffer();
                    if (img4 == null) continue;
                    this.myImageBuffer.drawImageBuffer(pl.getImageBuffer(), x, y);
                    if (onlythisimg) {
                        pl.resImageBuffer();
                    }
                    y += pl.getSizeY();
                }
                this.drawRectWH(statMultiFrameLeft, statMultiFrameTop, this.mySizeX - statMultiFrameLeft - statMultiFrameRight, this.mySizeY - statMultiFrameTop - statMultiFrameBottom, statTableFrameShadowSize);
            }
        }

        public void save(String dst) throws Exception {
            int mcnt = this.myModuls.size();
            for (int i = 0; i < mcnt; ++i) {
                ((TPMImageModul)this.myModuls.get(i)).save(dst);
            }
            int tcnt = this.myTables.size();
            for (int i = 0; i < tcnt; ++i) {
                ((TPMImageTable)this.myTables.get(i)).save(dst);
            }
            int plcnt = this.myPLs.size();
            for (int i = 0; i < plcnt; ++i) {
                ((TPMImagePL)this.myPLs.get(i)).save(dst);
            }
        }
    }

    public static class TPMImageTable
    extends TPMImageBase {
        protected String myTableName;
        protected Vector myPLs = new Vector();

        public TPMImageTable() {
        }

        public TPMImageTable(String tablename) {
            this.myTableName = tablename;
        }

        public String getTableName() {
            return this.myTableName;
        }

        public void addPL(TPMImagePL pl) {
            this.myPLs.add(pl);
        }

        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.myTableName = t.getAttr("tablename");
            this.overreadICD(xs);
            while ((t = xs.getLeafStart("pl")) != null) {
                String pltype = t.getAttr("pltype");
                TPMImagePL tpmpl = new TPMImagePL();
                tpmpl.load(t, xs);
                if (!"DelPL".equals(pltype)) {
                    this.myPLs.add(tpmpl);
                }
                xs.getLeafEnd("pl");
            }
        }

        public void run(boolean genimg, boolean onlythisimg) {
            MLogger.deb((String)("Table: " + this.myTableName));
            int plcnt = this.myPLs.size();
            for (int i = 0; i < plcnt; ++i) {
                ((TPMImagePL)this.myPLs.get(i)).run();
            }
            if (genimg) {
                ImageIcon icon = MImagesTPM.getCellIcon4Type("Table", this.check4large);
                int iconwidth = icon != null ? icon.getIconWidth() : 16;
                int iconheight = icon != null ? icon.getIconHeight() : 16;
                int textwidth = this.getWidthX(this.myTableName, null);
                this.mySizeX = iconwidth + statNameGap + textwidth;
                int y0 = this.mySizeY = statMultiFrameTop + statInsetFrameTop + iconheight;
                int sizex0 = 0;
                int sizey0 = 0;
                for (int i = 0; i < plcnt; ++i) {
                    TPMImagePL pl = (TPMImagePL)this.myPLs.get(i);
                    ImageBuffer img = pl.getImageBuffer();
                    if (img == null) continue;
                    int sizex = pl.getSizeX();
                    int sizey = pl.getSizeY();
                    String pltype = pl.getPLType();
                    if ("BasePL".equals(pltype) || "DelPL".equals(pltype)) {
                        sizex0 += sizex;
                        if (sizey > sizey0) {
                            sizey0 = sizey;
                        }
                        if (sizex0 > this.mySizeX) {
                            this.mySizeX = sizex0;
                        }
                        if (y0 + sizey0 <= this.mySizeY) continue;
                        this.mySizeY = y0 + sizey0;
                        continue;
                    }
                    if (sizex > this.mySizeX) {
                        this.mySizeX = sizex;
                    }
                    this.mySizeY += sizey;
                }
                this.mySizeX += statMultiFrameLeft + statInsetFrameLeft + statInsetFrameRight + statMultiFrameRight;
                this.mySizeY += statInsetFrameBottom + statMultiFrameBottom;
                this.myImageBuffer.newImage(this.mySizeX, this.mySizeY);
                int x = statMultiFrameLeft + statInsetFrameLeft;
                int y = statMultiFrameTop + statInsetFrameTop;
                this.drawIconX(icon, x, y, iconwidth, iconheight, this.myTableName, null, null, null);
                int x0 = x;
                y0 = y += iconheight;
                for (int i = 0; i < plcnt; ++i) {
                    TPMImagePL pl = (TPMImagePL)this.myPLs.get(i);
                    ImageBuffer img = pl.getImageBuffer();
                    if (img == null) continue;
                    String pltype = pl.getPLType();
                    if ("BasePL".equals(pltype) || "DelPL".equals(pltype)) {
                        this.myImageBuffer.drawImageBuffer(pl.getImageBuffer(), x0, y0);
                        x0 += pl.getSizeX();
                        if (y0 + pl.getSizeY() > y) {
                            y = y0 + pl.getSizeY();
                        }
                    } else {
                        this.myImageBuffer.drawImageBuffer(pl.getImageBuffer(), x, y);
                        y += pl.getSizeY();
                    }
                    if (!onlythisimg) continue;
                    pl.resImageBuffer();
                }
                this.drawRectWH(statMultiFrameLeft, statMultiFrameTop, this.mySizeX - statMultiFrameLeft - statMultiFrameRight, this.mySizeY - statMultiFrameTop - statMultiFrameBottom, statTableFrameShadowSize);
            }
        }

        public void save(String dst) throws Exception {
            MLogger.deb((String)("Table: " + this.myTableName));
            String name = this.myTableName.toLowerCase();
            int plcnt = this.myPLs.size();
            for (int i = 0; i < plcnt; ++i) {
                ((TPMImagePL)this.myPLs.get(i)).save(dst);
            }
            BufferedImage img = this.myImageBuffer.getImage();
            if (img != null) {
                MLogger.deb((String)("Table: " + this.myTableName + " (*)"));
                ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), img);
                this.resImageBuffer();
            }
        }
    }

    public static class TPMImagePL
    extends TPMImagePLx {
        protected String myPLType;
        protected String myPLName;
        protected String myPLSuper;
        protected String myPLBaseName;
        protected String myText;
        protected String myText2;
        protected Integer myState;

        public void setDrawEndIcon(boolean b) {
            this.myDrawEndIconIfPL = b;
        }

        public TPMImagePL() {
        }

        public TPMImagePL(String pltype, String plname, String plsuper, String plbasename, Integer state) {
            this.myPLType = pltype;
            this.myPLName = plname;
            this.myPLSuper = plsuper;
            this.myPLBaseName = plbasename;
            this.myState = state;
        }

        public TPMImagePL(String pltype, String plname, String plsuper, String plbasename, String text, String text2, Integer state) {
            this.myPLType = pltype;
            this.myPLName = plname;
            this.myPLSuper = plsuper;
            this.myPLBaseName = plbasename;
            this.myText = text;
            this.myText2 = text2;
            this.myState = state;
        }

        public String getPLType() {
            return this.myPLType;
        }

        public String getPLName() {
            return this.myPLName;
        }

        @Override
        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.myPLType = t.getAttr("pltype");
            this.myPLName = t.getAttr("plname");
            this.myPLSuper = t.getAttr("plsuper");
            this.myPLBaseName = t.getAttr("plbasename");
            this.myState = UniTypeConv.convString2Int((String)t.getAttr("plstate"));
            super.load(t, xs);
        }

        private void addPLP(int i, String pPLPType, Integer state) {
            TPMImagePLP plp = new TPMImagePLP(pPLPType, this.myPLBaseName + ("Main".equals(pPLPType) ? "" : pPLPType), null, state);
            this.myPLPs.add(i, plp);
        }

        @Override
        public void run() {
            if ("BasePL".equals(this.myPLType) && this.myPLSuper == null) {
                boolean hasEP = false;
                boolean hasMain = false;
                boolean hasCR = false;
                int plpcnt = this.myPLPs.size();
                for (int i = 0; i < plpcnt; ++i) {
                    TPMImagePLP plp = (TPMImagePLP)this.myPLPs.get(i);
                    String plptype = plp.getPLPType();
                    if ("EP".equals(plptype)) {
                        hasEP = true;
                    } else if (!hasEP && !"PreEP".equals(plptype)) {
                        this.addPLP(i, "EP", null);
                        hasEP = true;
                        ++plpcnt;
                        ++i;
                    }
                    if ("Main".equals(plptype)) {
                        hasMain = true;
                    } else if (!hasMain && ("PstMain".equals(plptype) || "PreCR".equals(plptype) || "CR".equals(plptype) || "PstCR".equals(plptype))) {
                        this.addPLP(i, "Main", null);
                        hasMain = true;
                        ++plpcnt;
                        ++i;
                    }
                    if ("CR".equals(plptype)) {
                        hasCR = true;
                        continue;
                    }
                    if (hasCR || !"PstCR".equals(plptype)) continue;
                    this.addPLP(i, "CR", null);
                    hasCR = true;
                    ++plpcnt;
                    ++i;
                }
                if (!hasEP) {
                    this.addPLP(plpcnt, "EP", null);
                    ++plpcnt;
                }
                if (!hasMain) {
                    this.addPLP(plpcnt, "Main", null);
                    ++plpcnt;
                }
                if (!hasCR) {
                    this.addPLP(plpcnt, "CR", null);
                    ++plpcnt;
                }
            }
            super.run();
            this.runMultiVertical(this.myPLType, this.myPLName, this.myPLSuper != null ? "(" + this.myPLSuper + ")" : this.myText, this.myText2, this.myState, true, true, false, false, false);
        }

        @Override
        public void save(String dst) throws Exception {
            String name = this.myPLName.toLowerCase();
            super.save(dst);
            if (this.myImageBuffer != null) {
                ImageRenderer.saveImage(dst + File.separator + statImagePrefix + name + "." + statImageType.toLowerCase(), this.myImageBuffer.getImage());
                this.resImageBuffer();
            }
        }
    }

    public static class TPMImagePLP
    extends TPMImagePLx {
        protected String myPLPType;
        protected String myPLPName;
        protected String myPLPSuper;
        protected String myText;
        protected String myText2;
        protected Integer myState;
        protected int myConnectX = -1;
        protected int myConnectY = -1;

        public TPMImagePLP() {
        }

        public TPMImagePLP(String plptype, String plpname, String plpsuper, Integer state) {
            this.myPLPType = plptype;
            this.myPLPName = plpname;
            this.myPLPSuper = plpsuper;
            this.myState = state;
        }

        public TPMImagePLP(String plptype, String plpname, String plpsuper, String text, String text2, Integer state) {
            this.myPLPType = plptype;
            this.myPLPName = plpname;
            this.myPLPSuper = plpsuper;
            this.myText = text;
            this.myText2 = text2;
            this.myState = state;
        }

        public String getPLPType() {
            return this.myPLPType;
        }

        public String getPLPName() {
            return this.myPLPName;
        }

        public String getPLPSuper() {
            return this.myPLPSuper;
        }

        public int getConnectX() {
            return this.myConnectX;
        }

        public int getConnectY() {
            return this.myConnectY;
        }

        @Override
        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.myPLPType = t.getAttr("plptype");
            this.myPLPName = t.getAttr("plpname");
            this.myState = UniTypeConv.convString2Int((String)t.getAttr("plpstate"));
            super.load(t, xs);
        }

        protected boolean isPLPTypeIn(String ... typenames) {
            for (int i = 0; i < typenames.length; ++i) {
                if (!typenames[i].equals(this.myPLPType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            super.run();
            if (!statExpandAssign && "Assign".equals(this.myPLPType) || this.isPLPTypeIn("AssignAdd", "AssignCopy", "AssignMove", "AssignRemove", "AssignLoad", "AssignSave", "BeanShell", "Call", "Empty", "HumanTask", "Invoke", "Java", "Receive", "Reply", "Terminate", "Throw", "Transform", "Wait")) {
                this.myConnectX = this.runSimple(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState);
            } else if (statExpandAssign && "Assign".equals(this.myPLPType) || this.isPLPTypeIn("PreEP", "EP", "PreMain", "Main", "PstMain", "CR", "PstCR", "Scope", "Sequence")) {
                this.myConnectX = this.runMultiVertical(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState, true, false, false, false, false);
            } else if (this.isPLPTypeIn("Case", "Otherwise")) {
                this.myConnectX = this.runMultiVertical(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState, false, false, false, true, false);
            } else if (this.isPLPTypeIn("ForEach", "While")) {
                this.myConnectX = this.runMultiVertical(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState, false, false, true, false, false);
            } else if (this.isPLPTypeIn("Catch", "CatchAll")) {
                this.myConnectX = this.runMultiVertical(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState, false, false, true, true, false);
                this.myConnectY = 2;
            } else if (this.isPLPTypeIn("Finally")) {
                this.myConnectX = this.runMultiVertical(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState, false, false, false, true, true);
                this.myConnectY = 3;
            } else if (this.isPLPTypeIn("Switch", "Flow")) {
                this.myConnectX = this.runMultiHorizontal(this.myPLPType, this.myPLPName + (this.myPLPSuper != null ? " (" + this.myPLPSuper + ")" : ""), this.myText, this.myText2, this.myState);
            } else {
                MLogger.deb((String)(" PLP(unknown): " + this.myPLPType + "/" + this.myPLPName));
            }
        }

        @Override
        public void save(String dst) throws Exception {
            super.save(dst);
        }
    }

    public static class TPMImagePLx
    extends TPMImageBase {
        protected Vector myPLPs = new Vector();
        protected boolean myDrawEndIconIfPL = true;
        private int addsizescnt = 4;

        public void addPLP(TPMImagePLP plp) {
            this.myPLPs.add(plp);
        }

        public void load(XMLTag t, XMLScanner xs) throws Exception {
            this.overreadICD(xs);
            while ((t = xs.getLeafStart("plp")) != null) {
                TPMImagePLP tpmplp = new TPMImagePLP();
                tpmplp.load(t, xs);
                this.myPLPs.add(tpmplp);
                xs.getLeafEnd("plp");
            }
        }

        public void run() {
            int plpcnt = this.myPLPs.size();
            for (int i = 0; i < plpcnt; ++i) {
                ((TPMImagePLP)this.myPLPs.get(i)).run();
            }
        }

        protected void drawPointerUp(int x, int y) {
            for (int i = 1; i <= statPointerWidth; ++i) {
                this.myImageBuffer.drawLine(x - i, y + statPointerLength - 1, x, y);
                this.myImageBuffer.drawLine(x + i, y + statPointerLength - 1, x, y);
            }
        }

        protected void drawPointerDown(int x, int y) {
            for (int i = 1; i <= statPointerWidth; ++i) {
                this.myImageBuffer.drawLine(x - i, y - statPointerLength, x, y - 1);
                this.myImageBuffer.drawLine(x + i, y - statPointerLength, x, y - 1);
            }
        }

        protected void drawPointerRight(int x, int y) {
            for (int i = 1; i <= statPointerWidth; ++i) {
                this.myImageBuffer.drawLine(x - statPointerLength, y - i, x - 1, y);
                this.myImageBuffer.drawLine(x - statPointerLength, y + i, x - 1, y);
            }
        }

        protected void drawPointerLeft(int x, int y) {
            for (int i = 1; i <= statPointerWidth; ++i) {
                this.myImageBuffer.drawLine(x + statPointerLength - 1, y - i, x, y);
                this.myImageBuffer.drawLine(x + statPointerLength - 1, y + i, x, y);
            }
        }

        protected int runSimple(String typename, String name, String text, String text2, Integer state) {
            ImageIcon icon;
            MLogger.deb((String)(" PLP(simple): " + typename + "/" + name));
            if (this.myPLPs.size() != 0) {
                MLogger.wrn((String)("There are PLP's under a leaf PLP (" + typename + ": " + name + ")."));
            }
            int iconwidth = (icon = MImagesTPM.getCellIcon4Type(typename, this.check4large)) != null ? icon.getIconWidth() : 16;
            int iconheight = icon != null ? icon.getIconHeight() : 16;
            int textwidth = this.getWidthX(name, text);
            this.mySizeX = statSimpleFrameLeft + iconwidth + statNameGap + textwidth + statSimpleFrameRight;
            this.mySizeY = statSimpleFrameTop + iconheight + statSimpleFrameBottom;
            this.myImageBuffer.newImage(this.mySizeX, this.mySizeY, new Color(255, 255, 255, 255));
            this.drawIconX(icon, statSimpleFrameLeft, statSimpleFrameTop, iconwidth, iconheight, name, text, text2, state);
            int locConnectX = statSimpleFrameLeft + iconwidth / 2;
            this.myImageBuffer.drawLine(locConnectX, 0, locConnectX, statSimpleFrameTop - 1);
            this.drawPointerDown(locConnectX, statSimpleFrameTop);
            this.myImageBuffer.drawLine(locConnectX, statSimpleFrameTop + iconheight, locConnectX, this.mySizeY);
            return locConnectX;
        }

        protected int calcSizeVertical(int pConnectX, int[] addSizeX, int[] addPositionsY) {
            int[] addSizesX = new int[this.addsizescnt];
            int[] addSizesY = new int[this.addsizescnt];
            for (int i = 0; i < this.addsizescnt; ++i) {
                addSizesX[i] = 0;
                addSizesY[i] = 0;
                addPositionsY[i] = 0;
            }
            boolean drawplp = false;
            boolean addplp = false;
            int plpcnt = this.myPLPs.size();
            for (int i = 0; i < plpcnt; ++i) {
                TPMImagePLP plp = (TPMImagePLP)this.myPLPs.get(i);
                int sizex = plp.getSizeX();
                int sizey = plp.getSizeY();
                int conx = plp.getConnectX();
                int cony = plp.getConnectY();
                if (cony == -1) {
                    if (conx > pConnectX) {
                        this.mySizeX += conx - pConnectX;
                        pConnectX = conx;
                    }
                    if (this.mySizeX < pConnectX + (sizex - conx)) {
                        this.mySizeX = pConnectX + (sizex - conx);
                    }
                    this.mySizeY += sizey;
                    drawplp = true;
                    continue;
                }
                if (cony < this.addsizescnt - 1) {
                    int n = cony;
                    addSizesX[n] = addSizesX[n] + sizex;
                    if (sizey > addSizesY[cony]) {
                        addSizesY[cony] = sizey;
                    }
                } else {
                    if (sizex > addSizesX[this.addsizescnt - 1]) {
                        addSizesX[this.addsizescnt - 1] = sizex;
                    }
                    int n = this.addsizescnt - 1;
                    addSizesY[n] = addSizesY[n] + (sizey + statMultiFrameBottom);
                }
                addplp = true;
            }
            if (!drawplp) {
                this.mySizeY += statInsetFrameTop + statInsetFrameBottom;
            }
            addSizeX[0] = 0;
            if (addplp) {
                int addSizeY = 3 * statMultiFrameTop;
                for (int i = 0; i < this.addsizescnt; ++i) {
                    addPositionsY[i] = addSizeY;
                    if (addSizesX[i] > addSizeX[0]) {
                        addSizeX[0] = addSizesX[i];
                    }
                    if (addSizesY[i] <= 0) continue;
                    addSizeY += addSizesY[i];
                    addSizeY += 3 * statMultiFrameBottom;
                }
                if (addSizeY > this.mySizeY) {
                    this.mySizeY = addSizeY;
                }
                if (addSizeX[0] > statMultiFrameRight) {
                    addSizeX[0] = addSizeX[0] - statMultiFrameRight;
                }
            }
            return pConnectX;
        }

        protected int drawPLPsVertical(int pConnectX, int y, int[] addpositionsy, boolean isPL) {
            int[] addpositionsx = new int[this.addsizescnt];
            for (int i = 0; i < this.addsizescnt; ++i) {
                addpositionsx[i] = 0;
            }
            boolean drawplp = false;
            int plpcnt = this.myPLPs.size();
            for (int i = 0; i < plpcnt; ++i) {
                TPMImagePLP plp = (TPMImagePLP)this.myPLPs.get(i);
                int cony = plp.getConnectY();
                if (cony == -1) {
                    this.myImageBuffer.drawImageBuffer(plp.getImageBuffer(), pConnectX - plp.getConnectX(), y);
                    String type = plp.getPLPType();
                    if (isPL && ("PreEP".equals(type) || "EP".equals(type) || "PreMain".equals(type) || "Main".equals(type) || "PstMain".equals(type) || "CR".equals(type) || "PstCR".equals(type))) {
                        int x1 = statMultiFrameLeft + statInsetFrameLeft + statMultiFrameLeft;
                        int x2 = pConnectX - plp.getConnectX() + statMultiFrameLeft;
                        if (x2 > x1) {
                            int y1 = y + statMultiFrameTop;
                            int y2 = y + plp.getSizeY() - statMultiFrameBottom - 1;
                            Color c = this.myImageBuffer.getColor();
                            this.myImageBuffer.setColor(Color.WHITE);
                            this.myImageBuffer.drawLine(x2, y1, x2, y2);
                            this.myImageBuffer.setColor(c);
                            this.myImageBuffer.drawLine(x1, y1, x2, y1);
                            this.myImageBuffer.drawLine(x1, y1, x1, y2);
                            this.drawRectWH(x1, y2, x2 - x1 + 1, 1, statPLFrameShadowSize);
                            int subimgwidth = plp.getConnectX() - statMultiFrameLeft - statInsetFrameLeft;
                            int subimgheight = MImagesTPM.getCellIcon4Type("BasePL", this.check4large).getIconHeight();
                            this.myImageBuffer.copyImageWH(pConnectX - plp.getConnectX() + statMultiFrameLeft + statInsetFrameLeft, y + statMultiFrameTop + statInsetFrameTop, subimgwidth, subimgheight, x1 + statInsetFrameLeft, y1 + statInsetFrameTop);
                            int fillimgx = x1 + statInsetFrameLeft + subimgwidth;
                            int fillimgy = y1 + statInsetFrameTop;
                            this.myImageBuffer.setColor(Color.WHITE);
                            this.myImageBuffer.fillRect(fillimgx, fillimgy, pConnectX - fillimgx, subimgheight);
                            this.myImageBuffer.setColor(c);
                        }
                    }
                    plp.resImageBuffer();
                    y += plp.getSizeY();
                    drawplp = true;
                    continue;
                }
                if (cony < this.addsizescnt - 1) {
                    int xx = this.mySizeX - statMultiFrameRight + addpositionsx[cony];
                    int yy = addpositionsy[cony];
                    this.myImageBuffer.drawImageBuffer(plp.getImageBuffer(), xx, yy);
                    plp.resImageBuffer();
                    int dx = plp.getSizeX();
                    this.myImageBuffer.drawLine(xx, yy - 1, xx + dx, yy - 1);
                    int xx2 = xx + plp.getConnectX();
                    int yy2 = addpositionsy[cony + 1] - 2 * statMultiFrameBottom;
                    this.myImageBuffer.drawLine(xx, yy2, xx + dx, yy2);
                    this.myImageBuffer.drawLine(xx2, yy + plp.getSizeY(), xx2, yy2);
                    this.drawPointerDown(xx + plp.getConnectX(), yy2);
                    int n = cony;
                    addpositionsx[n] = addpositionsx[n] + dx;
                    continue;
                }
                this.myImageBuffer.drawImageBuffer(plp.getImageBuffer(), this.mySizeX - statMultiFrameRight + addpositionsx[this.addsizescnt - 1], addpositionsy[this.addsizescnt - 1]);
                plp.resImageBuffer();
                int n = this.addsizescnt - 1;
                addpositionsy[n] = addpositionsy[n] + (plp.getSizeY() + statMultiFrameBottom);
            }
            if (!drawplp) {
                int ye = y + statInsetFrameTop + statInsetFrameBottom;
                this.myImageBuffer.drawLine(pConnectX, y, pConnectX, ye);
                y = ye;
            }
            return y;
        }

        protected int runMultiVertical(String typename, String name, String text, String text2, Integer state, boolean isIconLeft, boolean isPL, boolean isPointerAboveIcon, boolean isLineUnderIcon, boolean isPointerFromLeft) {
            int iconx;
            int locConnectX;
            ImageIcon icon;
            if (!isIconLeft && isPL) {
                MLogger.wrn((String)"Invalid flag combination (*).");
            }
            if (isIconLeft && (isPointerAboveIcon || isLineUnderIcon || isPointerFromLeft)) {
                MLogger.wrn((String)"Invalid flag combination (**).");
            }
            if (isPointerAboveIcon && isPointerFromLeft) {
                MLogger.wrn((String)"Invalid flag combination (***).");
            }
            int iconwidth = (icon = MImagesTPM.getCellIcon4Type(typename, this.check4large)) != null ? icon.getIconWidth() : 16;
            int iconheight = icon != null ? icon.getIconHeight() : 16;
            int textwidth = this.getWidthX(name, text);
            ImageIcon starticon = isPL ? MImagesTPM.getCellIcon4Type("StartPL", this.check4large) : null;
            int starticonwidth = starticon != null ? starticon.getIconWidth() : 16;
            int starticonheight = starticon != null ? starticon.getIconHeight() : 16;
            ImageIcon endicon = isPL ? MImagesTPM.getCellIcon4Type("EndPL", this.check4large) : null;
            int endiconwidth = endicon != null ? endicon.getIconWidth() : 16;
            int endiconheight = endicon != null ? endicon.getIconHeight() : 16;
            this.mySizeX = iconwidth + statNameGap + textwidth + statNameGap + (isPL ? Math.max(starticonwidth, endiconwidth) : 0);
            int n = isIconLeft ? iconwidth + statNameGap + textwidth + statNameGap + (isPL ? Math.max(starticonwidth / 2, endiconwidth / 2) : 0) : (locConnectX = iconwidth / 2);
            int yy = this.mySizeY = isIconLeft ? statMultiFrameTop + statInsetFrameTop + (isPL ? Math.max(iconheight, starticonheight) : iconheight) : (isPointerAboveIcon ? statMultiFrameTop + statInsetFrameTop : 0) + iconheight + (isLineUnderIcon ? statInsetFrameBottom : 0);
            int[] addsizex = new int[1];
            int[] addpositionsy = new int[this.addsizescnt];
            locConnectX = this.calcSizeVertical(locConnectX, addsizex, addpositionsy);
            this.mySizeX += statMultiFrameLeft + statInsetFrameLeft + statInsetFrameRight + statMultiFrameRight;
            this.mySizeY += (isPL ? 2 * statInsetFrameBottom + endiconheight + statInsetFrameBottom : 0) + statMultiFrameBottom + (isPointerFromLeft ? 2 * statMultiFrameBottom : 0);
            this.myImageBuffer.newImage(this.mySizeX + addsizex[0], this.mySizeY);
            int n2 = iconx = isIconLeft ? statMultiFrameLeft + statInsetFrameLeft : (locConnectX += statMultiFrameLeft + statInsetFrameLeft) - iconwidth / 2;
            int icony = isIconLeft ? statMultiFrameTop + statInsetFrameTop : (isPointerAboveIcon ? statMultiFrameTop + statInsetFrameTop : 0);
            this.drawIconX(icon, iconx, icony, iconwidth, iconheight, name, text, text2, state);
            if (isPL) {
                int starticonx = locConnectX - starticonwidth / 2;
                int starticony = statMultiFrameTop + statInsetFrameTop;
                if (starticon != null) {
                    this.myImageBuffer.drawImage(starticon.getImage(), starticonx, starticony);
                } else {
                    this.myImageBuffer.drawRectWH(starticonx, starticony, starticonwidth, starticonheight);
                }
                int endiconx = locConnectX - endiconwidth / 2;
                int endicony = this.mySizeY - statMultiFrameBottom - statInsetFrameBottom - endiconheight;
                if (endicon != null) {
                    if (this.myDrawEndIconIfPL) {
                        this.myImageBuffer.drawImage(endicon.getImage(), endiconx, endicony);
                    }
                } else {
                    this.myImageBuffer.drawRectWH(endiconx, endicony, endiconwidth, endiconheight);
                }
            }
            if (isIconLeft) {
                this.myImageBuffer.drawLine(locConnectX, isPL ? statMultiFrameTop + statInsetFrameTop + starticonheight : 0, locConnectX, yy);
            } else {
                if (isPointerAboveIcon) {
                    this.myImageBuffer.drawLine(locConnectX, 0, locConnectX, statMultiFrameTop + statInsetFrameTop - 1);
                    this.drawPointerDown(locConnectX, statMultiFrameTop + statInsetFrameTop);
                }
                if (isPointerFromLeft) {
                    int yp = icony + iconheight / 2;
                    this.myImageBuffer.drawLine(0, yp, iconx - 1, yp);
                    this.drawPointerRight(iconx, yp);
                }
                if (isLineUnderIcon) {
                    this.myImageBuffer.drawLine(locConnectX, (isPointerAboveIcon ? statMultiFrameTop + statInsetFrameTop : 0) + iconheight, locConnectX, yy);
                }
            }
            yy = this.drawPLPsVertical(locConnectX, yy, addpositionsy, isPL);
            if (isPL) {
                int endy = this.mySizeY - statMultiFrameBottom - statInsetFrameBottom - endiconheight;
                this.myImageBuffer.drawLine(locConnectX, yy, locConnectX, endy - 1);
                if (this.myDrawEndIconIfPL) {
                    this.drawPointerDown(locConnectX, endy);
                }
            } else {
                this.myImageBuffer.drawLine(locConnectX, yy, locConnectX, this.mySizeY - (isPointerFromLeft ? statMultiFrameBottom : 0));
            }
            if (isIconLeft) {
                this.drawRectWH(statMultiFrameLeft, statMultiFrameTop, this.mySizeX - statMultiFrameLeft - statMultiFrameRight, this.mySizeY - statMultiFrameTop - statMultiFrameBottom, isPL ? statPLFrameShadowSize : statPLPFrameShadowSize);
            } else {
                if (!isLineUnderIcon) {
                    this.myImageBuffer.drawRectWH(statMultiFrameLeft, icony + iconheight, this.mySizeX - statMultiFrameLeft - statMultiFrameRight, this.mySizeY - (isPointerFromLeft ? 2 * statMultiFrameBottom : 0) - icony - iconheight - statMultiFrameBottom);
                } else {
                    this.myImageBuffer.drawRectWH(statMultiFrameLeft, icony + iconheight + statInsetFrameTop, this.mySizeX - statMultiFrameLeft - statMultiFrameRight, this.mySizeY - (isPointerFromLeft ? 2 * statMultiFrameBottom : 0) - icony - iconheight - statInsetFrameTop - statMultiFrameBottom);
                }
                if (isPointerFromLeft) {
                    this.myImageBuffer.drawLine(0, this.mySizeY - statMultiFrameBottom, locConnectX, this.mySizeY - statMultiFrameBottom);
                    this.drawPointerLeft(0, this.mySizeY - statMultiFrameBottom);
                }
            }
            this.mySizeX += addsizex[0];
            return locConnectX;
        }

        protected int runMultiHorizontal(String typename, String name, String text, String text2, Integer state) {
            ImageIcon icon = MImagesTPM.getCellIcon4Type(typename, this.check4large);
            int iconwidth = icon != null ? icon.getIconWidth() : 16;
            int iconheight = icon != null ? icon.getIconHeight() : 16;
            int textwidth = this.getWidthX(name, text);
            this.mySizeX = iconwidth + statNameGap + textwidth + statNameGap;
            this.mySizeY = statSimpleFrameTop + iconheight;
            int locConnectX = iconwidth / 2;
            int width = 0;
            ++this.mySizeY;
            int y = this.mySizeY;
            int plpcnt = this.myPLPs.size();
            for (int i = 0; i < plpcnt; ++i) {
                TPMImagePLP plp = (TPMImagePLP)this.myPLPs.get(i);
                int sizex = plp.getSizeX();
                int sizey = plp.getSizeY();
                int cony = plp.getConnectY();
                if (cony != -1) continue;
                width += sizex;
                if (y + sizey <= this.mySizeY) continue;
                this.mySizeY = y + sizey;
            }
            if (width / 2 > locConnectX) {
                this.mySizeX += width / 2 - locConnectX;
                locConnectX = width / 2;
            }
            if (width > this.mySizeX) {
                this.mySizeX = width;
            }
            this.mySizeX += statSimpleFrameLeft + statInsetFrameLeft + statInsetFrameRight + statSimpleFrameRight;
            this.mySizeY += (plpcnt > 0 ? statInsetFrameBottom : 0) + statSimpleFrameBottom;
            this.myImageBuffer.newImage(this.mySizeX, this.mySizeY);
            this.myImageBuffer.drawLine(locConnectX += statSimpleFrameLeft + statInsetFrameLeft, 0, locConnectX, statSimpleFrameTop);
            this.drawPointerDown(locConnectX, statSimpleFrameTop);
            this.drawIconX(icon, locConnectX - iconwidth / 2, statSimpleFrameTop, iconwidth, iconheight, name, text, text2, state);
            this.myImageBuffer.drawLine(statSimpleFrameLeft, y - 1, statSimpleFrameLeft + statInsetFrameLeft + width + statInsetFrameRight, y - 1);
            int x = statSimpleFrameLeft + statInsetFrameLeft;
            for (int i = 0; i < plpcnt; ++i) {
                TPMImagePLP plp = (TPMImagePLP)this.myPLPs.get(i);
                this.myImageBuffer.drawImageBuffer(plp.getImageBuffer(), x, y);
                plp.resImageBuffer();
                this.myImageBuffer.drawLine(x + plp.getConnectX(), y + plp.getSizeY(), x + plp.getConnectX(), this.mySizeY - statSimpleFrameBottom);
                this.drawPointerDown(x + plp.getConnectX(), this.mySizeY - statSimpleFrameBottom);
                x += plp.getSizeX();
            }
            y = this.mySizeY - statSimpleFrameBottom;
            this.myImageBuffer.drawLine(statSimpleFrameLeft, y, statSimpleFrameLeft + statInsetFrameLeft + width + statInsetFrameRight, y);
            this.myImageBuffer.drawLine(locConnectX, y, locConnectX, this.mySizeY);
            return locConnectX;
        }

        public void save(String dst) throws Exception {
            int plpcnt = this.myPLPs.size();
            for (int i = 0; i < plpcnt; ++i) {
                ((TPMImagePLP)this.myPLPs.get(i)).save(dst);
            }
        }
    }

    public static class TPMImageBase {
        protected int myX = -1;
        protected int myY = -1;
        protected int mySizeX;
        protected int mySizeY;
        protected boolean check4large = true;
        protected ImageBuffer myImageBuffer = new ImageBuffer();

        public int getX() {
            return this.myX;
        }

        public void setX(int x) {
            this.myX = x;
        }

        public int getY() {
            return this.myY;
        }

        public void setY(int y) {
            this.myY = y;
        }

        public int getSizeX() {
            return this.mySizeX;
        }

        public int getSizeY() {
            return this.mySizeY;
        }

        public ImageBuffer getImageBuffer() {
            return this.myImageBuffer;
        }

        public void resImageBuffer() {
            this.myImageBuffer = null;
        }

        public boolean getCheck4Large() {
            return this.check4large;
        }

        public void setCheck4Large(boolean b) {
            this.check4large = b;
        }

        public void overreadICD(XMLScanner xs) throws Exception {
            XMLTag t;
            while ((t = xs.getLeafStart("info")) != null) {
                xs.getLeafEnd("info");
            }
            while ((t = xs.getLeafStart("comment")) != null) {
                xs.getLeafEnd("comment");
            }
            while ((t = xs.getLeafStart("description")) != null) {
                xs.getLeafEnd("description");
            }
        }

        protected void drawShadow(int x, int y, int width, int height) {
            this.myImageBuffer.drawShadowWH(x, y, width, height);
        }

        protected void drawRectWH(int x, int y, int width, int height, int shadowsize) {
            this.myImageBuffer.drawRectWH(x, y, width, height);
            if (shadowsize > 0) {
                this.drawShadow(x + shadowsize, y + height, width, shadowsize);
                this.drawShadow(x + width, y + shadowsize, shadowsize, height);
            }
        }

        protected int getWidthX(String name, String text) {
            int w1 = name != null ? this.myImageBuffer.getWidth(name) : 0;
            int w2 = text != null ? this.myImageBuffer.getWidth(text) : 0;
            return Math.max(w1, w2);
        }

        protected void drawIconX(ImageIcon icon, int iconx, int icony, int iconwidth, int iconheight, String name, String text, String text2, Integer state) {
            if (icon != null) {
                this.myImageBuffer.drawImage(icon.getImage(), iconx, icony);
            } else {
                this.myImageBuffer.drawRectWH(iconx, icony, iconwidth, iconheight);
            }
            try {
                int x = iconx + iconwidth + statNameGap;
                int y = icony;
                int fs = this.myImageBuffer.getFontSize();
                int lines = iconheight / fs;
                Color c = null;
                if (state != null && (state == 0 || state == 2)) {
                    c = this.myImageBuffer.getColor();
                    this.myImageBuffer.setColor(state == 2 ? Color.RED : Color.GREEN);
                    int w = this.myImageBuffer.getWidth(name);
                    this.myImageBuffer.fillRect(x - 2, y + 1, w + 3, fs + 3);
                    this.myImageBuffer.setColor(c);
                }
                if (name != null) {
                    this.myImageBuffer.printat(x, y, name);
                    y += fs;
                    --lines;
                }
                if (lines > 0 && text != null) {
                    this.myImageBuffer.printat(x, y, text);
                    y += fs;
                    --lines;
                }
                if (lines > 0 && text2 != null) {
                    this.myImageBuffer.printat(x, y, text2);
                    y += fs;
                    --lines;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

