/*
 * Decompiled with CFR 0.152.
 */
package com.sta.mimages;

import com.sta.cts.UniTypeConv;
import com.sta.mimages.ImageRenderer;
import com.sta.mimages.ImageUtils;
import com.sta.mimages.ImageWarper;
import com.sta.mimages.MImages;
import com.sta.mlogger.MLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class MImgProc
extends MImages {
    private Stack<BufferedImage> myImages = new Stack();

    private void newimage(Vector params) {
        Integer xx = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        this.myImages.push(ImageUtils.newImage(xx != null ? xx : 1, yy != null ? yy : 1, cc));
    }

    private void loadimage(Vector params) throws Exception {
        String fn = MImgProc.getNextParam(params);
        boolean ii = true;
        if (ii || "ii".equals(MImgProc.getNextParam(params))) {
            ImageIcon icon = MImgProc.loadImageIcon(fn);
            Image iimg = icon.getImage();
            BufferedImage img = new BufferedImage(iimg.getWidth(null), iimg.getHeight(null), 2);
            img.getGraphics().drawImage(iimg, 0, 0, null);
            this.myImages.push(img);
        } else {
            BufferedImage img = ImageIO.read(new BufferedInputStream(new FileInputStream(fn)));
            this.myImages.push(img);
        }
    }

    private void saveimage(Vector params) throws Exception {
        BufferedImage img = this.myImages.pop();
        String fn = MImgProc.getNextParam(params);
        File f = new File(fn);
        File dir = f.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        ImageRenderer.saveImage(fn, img);
    }

    private void duplimage(Vector params) {
        Integer ii = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int i = ii != null ? ii : 0;
        BufferedImage img = (BufferedImage)this.myImages.get(this.myImages.size() - 1 - i);
        this.myImages.push(img);
    }

    private void zoomimage(Vector params) {
        BufferedImage img = this.myImages.pop();
        String sx = MImgProc.getNextParam(params);
        String sy = MImgProc.getNextParam(params);
        this.myImages.push(ImageUtils.zoomImage(img, sx, sy));
    }

    private void combine(Vector params) {
        BufferedImage foreground = this.myImages.pop();
        BufferedImage background = this.myImages.pop();
        Integer xx = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        this.myImages.push(ImageUtils.combine(background, foreground, xx != null ? xx : 1, yy != null ? yy : 1));
    }

    private void mboximage(Vector params) {
        Integer xx = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        BufferedImage img = this.myImages.pop();
        this.myImages.push(ImageUtils.mboxImage(img, xx != null ? xx : 1, yy != null ? yy : 1, cc));
    }

    private void warpimage(Vector params) {
        BufferedImage img = this.myImages.pop();
        Integer x0 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer y0 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer x1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer y1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer x2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer y2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer x3 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer y3 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        img = new ImageWarper().execWarpFromRect(img, new Point(x0, y0), new Point(x1, y1), new Point(x2, y2), new Point(x3, y3)).getImage();
        this.myImages.push(img);
    }

    private void cropimage(Vector params) {
        BufferedImage orgimg = this.myImages.pop();
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x1 = xx1 != null ? xx1 : 0;
        int y1 = yy1 != null ? yy1 : 0;
        int x2 = xx2 != null ? xx2 : 0;
        int y2 = yy2 != null ? yy2 : 0;
        int width = x2 - x1;
        int height = y2 - y1;
        BufferedImage newimg = new BufferedImage(width, height, 2);
        Graphics g = newimg.getGraphics();
        g.drawImage(orgimg.getSubimage(x1, y1, width, height), 0, 0, null);
        this.myImages.push(newimg);
    }

    private boolean cmpColor(int rgb, int cmp1, int cmp2) {
        return (rgb & 0xFFFFFF) == cmp1;
    }

    private int findFirstX(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int x = 0;
        boolean isnn = false;
        while (!isnn && x < width) {
            int y;
            for (y = 0; y < height && this.cmpColor(img.getRGB(x, y), 0xFFFFFF, 0xFFFFFF); ++y) {
            }
            isnn = y < height;
            if (isnn) continue;
            ++x;
        }
        return x;
    }

    private int findLastX(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int x = width - 1;
        boolean isnn = false;
        while (!isnn && x >= 0) {
            int y;
            for (y = 0; y < height && this.cmpColor(img.getRGB(x, y), 0xFFFFFF, 0xFFFFFF); ++y) {
            }
            isnn = y < height;
            if (isnn) continue;
            --x;
        }
        return x;
    }

    private int findFirstY(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int y = 0;
        boolean isnn = false;
        while (!isnn && y < height) {
            int x;
            for (x = 0; x < width && this.cmpColor(img.getRGB(x, y), 0xFFFFFF, 0xFFFFFF); ++x) {
            }
            isnn = x < width;
            if (isnn) continue;
            ++y;
        }
        return y;
    }

    private int findLastY(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int y = height - 1;
        boolean isnn = false;
        while (!isnn && y >= 0) {
            int x;
            for (x = 0; x < width && this.cmpColor(img.getRGB(x, y), 0xFFFFFF, 0xFFFFFF); ++x) {
            }
            isnn = x < width;
            if (isnn) continue;
            --y;
        }
        return y;
    }

    private void cutimage(Vector params) {
        BufferedImage orgimg = this.myImages.pop();
        int x1 = this.findFirstX(orgimg);
        int y1 = this.findFirstY(orgimg);
        int x2 = this.findLastX(orgimg);
        int y2 = this.findLastY(orgimg);
        MLogger.deb((String)("x1,y1 / x2,y2 = " + x1 + "," + y1 + " / " + x2 + "," + y2));
        int width = x2 - x1 + 1;
        int height = y2 - y1 + 1;
        BufferedImage newimg = new BufferedImage(width, height, 2);
        Graphics g = newimg.getGraphics();
        g.drawImage(orgimg.getSubimage(x1, y1, width, height), 0, 0, null);
        this.myImages.push(newimg);
    }

    private boolean cmpColorWithTollerance(int argb1, int argb2, int tollerance) {
        int b1 = argb1 & 0xFF;
        int g1 = argb1 >> 8 & 0xFF;
        int r1 = argb1 >> 16 & 0xFF;
        int a1 = argb1 >> 24 & 0xFF;
        int b2 = argb2 & 0xFF;
        int g2 = argb2 >> 8 & 0xFF;
        int r2 = argb2 >> 16 & 0xFF;
        int a2 = argb2 >> 24 & 0xFF;
        int bt = tollerance & 0xFF;
        int gt = tollerance >> 8 & 0xFF;
        int rt = tollerance >> 16 & 0xFF;
        int at = tollerance >> 24 & 0xFF;
        int db = Math.abs(b2 - b1);
        int dg = Math.abs(g2 - g1);
        int dr = Math.abs(r2 - r1);
        int da = Math.abs(a2 - a1);
        return db <= bt && dg <= gt && dr <= rt && da <= at;
    }

    private void fill(BufferedImage img, int x, int y, int width, int height, int oldcolor, int tollerance, int newcolor) {
        ArrayList<Point> fifo = new ArrayList<Point>();
        fifo.add(new Point(x, y));
        while (fifo.size() > 0) {
            Point point = (Point)fifo.remove(0);
            x = point.x;
            y = point.y;
            if (y >= 1 && this.cmpColorWithTollerance(img.getRGB(x, y - 1), oldcolor, tollerance)) {
                img.setRGB(x, y - 1, newcolor);
                fifo.add(new Point(x, y - 1));
            }
            if (y < height - 1 && this.cmpColorWithTollerance(img.getRGB(x, y + 1), oldcolor, tollerance)) {
                img.setRGB(x, y + 1, newcolor);
                fifo.add(new Point(x, y + 1));
            }
            if (x >= 1 && this.cmpColorWithTollerance(img.getRGB(x - 1, y), oldcolor, tollerance)) {
                img.setRGB(x - 1, y, newcolor);
                fifo.add(new Point(x - 1, y));
            }
            if (x >= width - 1 || !this.cmpColorWithTollerance(img.getRGB(x + 1, y), oldcolor, tollerance)) continue;
            img.setRGB(x + 1, y, newcolor);
            fifo.add(new Point(x + 1, y));
        }
    }

    private void fillimage(Vector params) {
        BufferedImage img = this.myImages.peek();
        Integer xx = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        Long tt = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int x = xx != null ? xx : 0;
        int y = yy != null ? yy : 0;
        int newcolor = cc != null ? cc.intValue() : 0;
        int tollerance = tt != null ? tt.intValue() : 0;
        int width = img.getWidth();
        int height = img.getHeight();
        int oldolor = img.getRGB(x, y);
        img.setRGB(x, y, newcolor);
        this.fill(img, x, y, width, height, oldolor, tollerance, newcolor);
    }

    private void replcolor(Vector params) {
        BufferedImage img = this.myImages.peek();
        Long oc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        Long tt = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        Long nc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int oldcolor = oc != null ? oc.intValue() : 0;
        int tollerance = tt != null ? tt.intValue() : 0;
        int newcolor = nc != null ? nc.intValue() : 0;
        int width = img.getWidth();
        int height = img.getHeight();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int curcolor = img.getRGB(x, y);
                if (!this.cmpColorWithTollerance(curcolor, oldcolor, tollerance)) continue;
                img.setRGB(x, y, newcolor);
            }
        }
    }

    private BufferedImage rot90right(BufferedImage orgimg) {
        int orgwidth = orgimg.getWidth();
        int orgheight = orgimg.getHeight();
        BufferedImage newimg = new BufferedImage(orgheight, orgwidth, 2);
        for (int y = 0; y < orgheight; ++y) {
            for (int x = 0; x < orgwidth; ++x) {
                int argb = orgimg.getRGB(x, y);
                newimg.setRGB(orgheight - y - 1, x, argb);
            }
        }
        return newimg;
    }

    private void rotimage(Vector params) {
        BufferedImage newimg;
        Integer deg = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        if (deg == null) {
            return;
        }
        if (deg == 0) {
            return;
        }
        if (deg != -270 && deg != -180 && deg != -90 && deg != 90 && deg != 180 && deg != 270) {
            MLogger.wrn((String)("Possible problem with rotation degrees: " + deg + ". Check image size!"));
        }
        deg = (deg + 360) % 360;
        BufferedImage orgimg = this.myImages.pop();
        if (deg == 90) {
            newimg = this.rot90right(orgimg);
        } else {
            int orgwidth = orgimg.getWidth();
            int orgheight = orgimg.getHeight();
            int newwidth = orgwidth;
            int newheight = orgheight;
            int pos = 0;
            if (deg == 90) {
                newwidth = orgheight;
                newheight = orgwidth;
                pos = (orgwidth - orgheight) / 2;
            } else if (deg == 270) {
                newwidth = orgheight;
                newheight = orgwidth;
                pos = (orgheight - orgwidth) / 2;
            }
            newimg = new BufferedImage(newwidth, newheight, 2);
            Graphics2D g = newimg.createGraphics();
            AffineTransform at = new AffineTransform();
            at.rotate(Math.toRadians(deg.intValue()), orgwidth / 2, orgheight / 2);
            g.transform(at);
            g.drawImage(orgimg, pos, pos, orgwidth, orgheight, null);
            orgimg = null;
        }
        this.myImages.push(newimg);
    }

    private void flipimage(Vector params) {
        String dir = MImgProc.getNextParam(params);
        boolean hor = true;
        if ("h".equals(dir)) {
            hor = true;
        } else if ("v".equals(dir)) {
            hor = false;
        } else {
            return;
        }
        BufferedImage orgimg = this.myImages.pop();
        int orgwidth = orgimg.getWidth();
        int orgheight = orgimg.getHeight();
        BufferedImage newimg = new BufferedImage(orgwidth, orgheight, 2);
        for (int y = 0; y < orgheight; ++y) {
            for (int x = 0; x < orgwidth; ++x) {
                int argb = orgimg.getRGB(x, y);
                if (hor) {
                    newimg.setRGB(orgwidth - x - 1, y, argb);
                    continue;
                }
                newimg.setRGB(x, orgheight - y - 1, argb);
            }
        }
        this.myImages.push(newimg);
    }

    private void addborder(Vector params) {
        BufferedImage orgimg = this.myImages.pop();
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        this.myImages.push(ImageUtils.addBorder(orgimg, xx1 != null ? xx1 : 0, yy1 != null ? yy1 : 0, xx2 != null ? xx2 : 0, yy2 != null ? yy2 : 0, cc));
    }

    private void grayscale(Vector params) {
        BufferedImage img = this.myImages.peek();
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.getRGB(x, y);
                int b = argb & 0xFF;
                int g = argb >> 8 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int a = argb >> 24 & 0xFF;
                int m = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
                m = m <= 255 ? m : 255;
                argb = (a << 24) + (m << 16) + (m << 8) + m;
                img.setRGB(x, y, argb);
            }
        }
    }

    private void scale(Vector params) {
        BufferedImage img = this.myImages.peek();
        Long factor = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int ff = factor != null ? factor.intValue() : -1;
        ImageUtils.scale(img, ff);
    }

    private void scale4(Vector params) {
        BufferedImage orgimg = this.myImages.pop();
        Integer alpha = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer red = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer green = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer blue = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        this.myImages.push(ImageUtils.scale4(orgimg, alpha, red, green, blue));
    }

    private void scalex(Vector params) {
        BufferedImage img = this.myImages.peek();
        Long factor = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int ff = factor != null ? factor.intValue() : -1;
        int blue = ff & 0xFF;
        int green = ff >> 8 & 0xFF;
        int red = ff >> 16 & 0xFF;
        int alpha = ff >> 24 & 0xFF;
        MLogger.deb((String)("argb = " + alpha + " / " + red + " / " + green + " / " + blue));
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.getRGB(x, y);
                int b = argb & 0xFF;
                int g = argb >> 8 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int a = argb >> 24 & 0xFF;
                a = (a ^ alpha) & 0xFF;
                r = (r ^ red) & 0xFF;
                g = (g ^ green) & 0xFF;
                b = (b ^ blue) & 0xFF;
                argb = (a << 24) + (r << 16) + (g << 8) + b;
                img.setRGB(x, y, argb);
            }
        }
    }

    private void scale4x(Vector params) {
        BufferedImage img1 = this.myImages.pop();
        BufferedImage img = new BufferedImage(img1.getWidth(null), img1.getHeight(null), 2);
        img.getGraphics().drawImage(img1, 0, 0, null);
        int alpha = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int red = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int green = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int blue = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        MLogger.deb((String)("argb = " + alpha + " / " + red + " / " + green + " / " + blue));
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.getRGB(x, y);
                int b = argb & 0xFF;
                int g = argb >> 8 & 0xFF;
                int r = argb >> 16 & 0xFF;
                int a = argb >> 24 & 0xFF;
                a = (a ^ alpha) & 0xFF;
                r = (r ^ red) & 0xFF;
                g = (g ^ green) & 0xFF;
                b = (b ^ blue) & 0xFF;
                argb = ((a <= 255 ? a : 255) << 24) + ((r <= 255 ? r : 255) << 16) + ((g <= 255 ? g : 255) << 8) + (b <= 255 ? b : 255);
                img.setRGB(x, y, argb);
            }
        }
        this.myImages.push(img);
    }

    private void transform(Vector params) {
        BufferedImage img = this.myImages.peek();
        int[][] matrix = new int[4][4];
        for (int z = 0; z < 4; ++z) {
            for (int s = 0; s < 4; ++s) {
                matrix[z][s] = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
            }
        }
        int w = img.getWidth();
        int h = img.getHeight();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = img.getRGB(x, y);
                int[] src = new int[]{argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF};
                int[] dst = new int[4];
                for (int z = 0; z < 4; ++z) {
                    int v = 0;
                    for (int s = 0; s < 4; ++s) {
                        v += matrix[z][s] * src[s];
                    }
                    dst[z] = (v >>= 8) <= 255 ? v : 255;
                }
                argb = (dst[0] << 24) + (dst[1] << 16) + (dst[2] << 8) + dst[3];
                img.setRGB(x, y, argb);
            }
        }
    }

    private void print(Vector params) {
        BufferedImage background;
        Graphics g;
        Integer xx = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x = xx != null ? xx : 1;
        int y = yy != null ? yy : 1;
        String fontname = MImgProc.getNextParam(params);
        Integer fontsize = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer fontstyleindex = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer cc = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        String text = MImgProc.getNextParam(params);
        if (text.startsWith("\"")) {
            String s;
            if (text.length() > 1) {
                text = text.substring(1);
            }
            while (!text.endsWith("\"") && (s = MImgProc.getNextParam(params)) != null) {
                text = text + " " + s;
            }
            if (text.endsWith("\"")) {
                text = text.length() > 1 ? text.substring(0, text.length() - 1) : "";
            }
        }
        if ((g = (background = this.myImages.pop()).getGraphics()) instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setFont(new Font(fontname, (int)fontstyleindex, fontsize));
        g.setColor(new Color(cc));
        g.drawString(text, x, y);
        this.myImages.push(background);
    }

    private void drawline(Vector params) {
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x1 = xx1 != null ? xx1 : 0;
        int y1 = yy1 != null ? yy1 : 0;
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x2 = xx2 != null ? xx2 : 0;
        int y2 = yy2 != null ? yy2 : 0;
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int color = cc != null ? cc.intValue() : 0;
        BufferedImage background = this.myImages.peek();
        Graphics g = background.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(new Color(color));
        g.drawLine(x1, y1, x2, y2);
    }

    private void drawrect(Vector params) {
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x1 = xx1 != null ? xx1 : 0;
        int y1 = yy1 != null ? yy1 : 0;
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x2 = xx2 != null ? xx2 : 0;
        int y2 = yy2 != null ? yy2 : 0;
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int color = cc != null ? cc.intValue() : 0;
        BufferedImage background = this.myImages.peek();
        Graphics g = background.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(new Color(color));
        g.drawRect(x1, y1, x2 - x1, y2 - y1);
    }

    private void drawbox(Vector params) {
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x1 = xx1 != null ? xx1 : 0;
        int y1 = yy1 != null ? yy1 : 0;
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x2 = xx2 != null ? xx2 : 0;
        int y2 = yy2 != null ? yy2 : 0;
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int color = cc != null ? cc.intValue() : 0;
        BufferedImage background = this.myImages.peek();
        Graphics g = background.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(new Color(color));
        g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    private void fillrect(Vector params) {
        this.drawbox(params);
    }

    private void drawoval(Vector params) {
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x1 = xx1 != null ? xx1 : 0;
        int y1 = yy1 != null ? yy1 : 0;
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x2 = xx2 != null ? xx2 : 0;
        int y2 = yy2 != null ? yy2 : 0;
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int color = cc != null ? cc.intValue() : 0;
        BufferedImage background = this.myImages.peek();
        Graphics g = background.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(new Color(color));
        g.drawOval(x1, y1, x2 - x1, y2 - y1);
    }

    private void filloval(Vector params) {
        Integer xx1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x1 = xx1 != null ? xx1 : 0;
        int y1 = yy1 != null ? yy1 : 0;
        Integer xx2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        Integer yy2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x2 = xx2 != null ? xx2 : 0;
        int y2 = yy2 != null ? yy2 : 0;
        Long cc = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int color = cc != null ? cc.intValue() : 0;
        BufferedImage background = this.myImages.peek();
        Graphics g = background.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(new Color(color));
        g.fillOval(x1, y1, x2 - x1, y2 - y1);
    }

    private boolean checkColor(int argb, int a1, int a2, int r1, int r2, int g1, int g2, int b1, int b2) {
        int a = argb >> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        return a1 <= a && a <= a2 && r1 <= r && r <= r2 && g1 <= g && g <= g2 && b1 <= b && b <= b2;
    }

    private void killtext(Vector params) throws Exception {
        MLogger.deb((String)"killtext...");
        BufferedImage img = this.myImages.peek();
        int w = img.getWidth();
        int h = img.getHeight();
        int x1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int y1 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int x2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        int y2 = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        long color = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        long toll = UniTypeConv.convString2Long((String)MImgProc.getNextParam(params));
        int circ = UniTypeConv.convString2Int((String)MImgProc.getNextParam(params));
        if (x1 < 0) {
            x1 = w + x1;
            if (x2 == 0) {
                x2 = w;
            }
        }
        if (x2 < 0) {
            x2 = w + x2;
        }
        if (y1 < 0) {
            y1 = h + y1;
            if (y2 == 0) {
                y2 = h;
            }
        }
        if (y2 < 0) {
            y2 = h + y2;
        }
        if (x1 >= x2) {
            throw new Exception("X-Problem: " + x1 + " / " + x2);
        }
        if (y1 >= y2) {
            throw new Exception("Y-Problem: " + y1 + " / " + y2);
        }
        int a = (int)color >> 24 & 0xFF;
        int r = (int)color >> 16 & 0xFF;
        int g = (int)color >> 8 & 0xFF;
        int b = (int)color & 0xFF;
        int at = (int)toll >> 24 & 0xFF;
        int rt = (int)toll >> 16 & 0xFF;
        int gt = (int)toll >> 8 & 0xFF;
        int bt = (int)toll & 0xFF;
        int b1 = Math.max(b - bt, 0);
        int b2 = Math.min(b + bt, 255);
        int g1 = Math.max(g - gt, 0);
        int g2 = Math.min(g + gt, 255);
        int r1 = Math.max(r - rt, 0);
        int r2 = Math.min(r + rt, 255);
        int a1 = Math.max(a - at, 0);
        int a2 = Math.min(a + at, 255);
        int dx = x2 - x1;
        int dy = y2 - y1;
        MLogger.deb((String)("x1/dx/x2: " + x1 + "/" + dx + "/" + x2));
        MLogger.deb((String)("y1/dy/y2: " + y1 + "/" + dy + "/" + y2));
        MLogger.deb((String)("toll: " + Long.toHexString(toll)));
        MLogger.deb((String)("argb: " + a + "/" + r + "/" + g + "/" + b));
        MLogger.deb((String)("toll: " + at + "/" + rt + "/" + gt + "/" + bt));
        MLogger.deb((String)("toll1: " + a1 + "/" + r1 + "/" + g1 + "/" + b1));
        MLogger.deb((String)("toll2: " + a2 + "/" + r2 + "/" + g2 + "/" + b2));
        boolean[] ba = new boolean[dy * dx];
        Arrays.fill(ba, false);
        for (int y = 0; y < dy; ++y) {
            for (int x = 0; x < dx; ++x) {
                int argb = img.getRGB(x1 + x, y1 + y);
                int ii = y * dx + x;
                if (!this.checkColor(argb, a1, a2, r1, r2, g1, g2, b1, b2)) continue;
                ba[ii] = true;
                if (x > 0) {
                    ba[ii - 1] = true;
                }
                if (x < dx - 1) {
                    ba[ii + 1] = true;
                }
                if (y > 0) {
                    ba[ii - dx] = true;
                }
                if (y >= dy - 1) continue;
                ba[ii + dx] = true;
            }
        }
        int[] ca = new int[dy * dx];
        for (int y = 0; y < dy; ++y) {
            for (int x = 0; x < dx; ++x) {
                int argb = img.getRGB(x1 + x, y1 + y);
                if (ba[y * dx + x]) {
                    ca[y * dx + x] = -16777216;
                    int asum = 0;
                    int rsum = 0;
                    int gsum = 0;
                    int bsum = 0;
                    int cnt = 0;
                    for (int yy = -circ; yy <= circ; ++yy) {
                        int dxx = circ - Math.abs(yy);
                        for (int xx = -dxx; xx <= dxx; ++xx) {
                            if (yy == 0 && xx == 0 || x + xx >= 0 && x + xx < dx && y + yy >= 0 && y + yy < dy && ba[(y + yy) * dx + (x + xx)]) continue;
                            int argbx = img.getRGB(x1 + x + xx, y1 + y + yy);
                            int ax = argbx >> 24 & 0xFF;
                            int rx = argbx >> 16 & 0xFF;
                            int gx = argbx >> 8 & 0xFF;
                            int bx = argbx & 0xFF;
                            int f = 2 * circ - Math.abs(xx) - Math.abs(yy) + 1;
                            asum += ax * f;
                            rsum += rx * f;
                            gsum += gx * f;
                            bsum += bx * f;
                            cnt += f;
                        }
                    }
                    if (cnt != 0) {
                        ca[y * dx + x] = (asum / cnt << 24) + (rsum / cnt << 16) + (gsum / cnt << 8) + bsum / cnt;
                        continue;
                    }
                    ca[y * dx + x] = argb;
                    continue;
                }
                ca[y * dx + x] = argb;
            }
        }
        img.setRGB(x1, y1, dx, dy, ca, 0, dx);
        MLogger.deb((String)"killtext: Ok.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String filename) throws Exception {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        this.myImages.clear();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename)));){
            String line;
            int linenr = 0;
            block5: while ((line = br.readLine()) != null) {
                try {
                    ++linenr;
                    if ((line = line.trim()).startsWith(";") || line.startsWith("#") || line.length() <= 0) continue;
                    StringTokenizer st = new StringTokenizer(line);
                    Vector<String> params = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        params.add(st.nextToken());
                    }
                    String cmd = MImgProc.getNextParam(params);
                    if ("xdebug".equals(cmd)) {
                        MLogger.deb((String)"xdebug");
                        continue;
                    }
                    if ("newimage".equals(cmd)) {
                        this.newimage(params);
                        continue;
                    }
                    if ("loadimage".equals(cmd)) {
                        this.loadimage(params);
                        continue;
                    }
                    if ("saveimage".equals(cmd)) {
                        this.saveimage(params);
                        continue;
                    }
                    if ("duplimage".equals(cmd)) {
                        this.duplimage(params);
                        continue;
                    }
                    if ("zoomimage".equals(cmd)) {
                        this.zoomimage(params);
                        continue;
                    }
                    if ("combine".equals(cmd)) {
                        this.combine(params);
                        continue;
                    }
                    if ("mboximage".equals(cmd)) {
                        this.mboximage(params);
                        continue;
                    }
                    if ("warpimage".equals(cmd)) {
                        this.warpimage(params);
                        continue;
                    }
                    if ("cropimage".equals(cmd)) {
                        this.cropimage(params);
                        continue;
                    }
                    if ("cutimage".equals(cmd)) {
                        this.cutimage(params);
                        continue;
                    }
                    if ("fillimage".equals(cmd)) {
                        this.fillimage(params);
                        continue;
                    }
                    if ("replcolor".equals(cmd)) {
                        this.replcolor(params);
                        continue;
                    }
                    if ("rotimage".equals(cmd)) {
                        this.rotimage(params);
                        continue;
                    }
                    if ("flipimage".equals(cmd)) {
                        this.flipimage(params);
                        continue;
                    }
                    if ("addborder".equals(cmd)) {
                        this.addborder(params);
                        continue;
                    }
                    if ("addshadow".equals(cmd)) {
                        MLogger.deb((String)"addshadow");
                        continue;
                    }
                    if ("grayscale".equals(cmd)) {
                        this.grayscale(params);
                        continue;
                    }
                    if ("scale".equals(cmd)) {
                        this.scale(params);
                        continue;
                    }
                    if ("scale4".equals(cmd)) {
                        this.scale4(params);
                        continue;
                    }
                    if ("scalex".equals(cmd)) {
                        this.scalex(params);
                        continue;
                    }
                    if ("scale4x".equals(cmd)) {
                        this.scale4x(params);
                        continue;
                    }
                    if ("transform".equals(cmd)) {
                        this.transform(params);
                        continue;
                    }
                    if ("print".equals(cmd)) {
                        this.print(params);
                        continue;
                    }
                    if ("drawline".equals(cmd)) {
                        this.drawline(params);
                        continue;
                    }
                    if ("drawrect".equals(cmd)) {
                        this.drawrect(params);
                        continue;
                    }
                    if ("drawbox".equals(cmd)) {
                        this.drawbox(params);
                        continue;
                    }
                    if ("fillrect".equals(cmd)) {
                        this.fillrect(params);
                        continue;
                    }
                    if ("drawoval".equals(cmd)) {
                        this.drawoval(params);
                        continue;
                    }
                    if ("filloval".equals(cmd)) {
                        this.filloval(params);
                        continue;
                    }
                    if ("killtext".equals(cmd)) {
                        this.killtext(params);
                        continue;
                    }
                    if ("goto".equals(cmd)) {
                        String dst = MImgProc.getNextParam(params);
                        if (dst == null) continue;
                        while ((line = br.readLine()) != null) {
                            ++linenr;
                            if (!(line = line.trim()).equals(":" + dst)) continue;
                            continue block5;
                        }
                        continue;
                    }
                    MLogger.wrn((String)("Invalid command in line " + linenr + ": " + cmd));
                }
                catch (Exception ex) {
                    throw new Exception("File: " + filename + " --> error in line " + linenr + "\nLine: " + line, ex);
                }
            }
            MLogger.inf((String)(" " + this.myImages.size()));
        }
    }
}

