package com.starburstdata.docker.$internal.com.fasterxml.jackson.datatype.guava.deser;

import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.JsonDeserializer;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.type.CollectionType;
import com.starburstdata.docker.$internal.com.google.common.collect.LinkedHashMultiset;

public class LinkedHashMultisetDeserializer extends GuavaMultisetDeserializer<LinkedHashMultiset<Object>>
{
    private static final long serialVersionUID = 1L;

    public LinkedHashMultisetDeserializer(CollectionType type, TypeDeserializer typeDeser, JsonDeserializer<?> deser) {
        super(type, typeDeser, deser);
    }

    @Override
    protected LinkedHashMultiset<Object> createMultiset() {
        return LinkedHashMultiset.create();
    }

    @Override
    public GuavaCollectionDeserializer<LinkedHashMultiset<Object>> withResolved(TypeDeserializer typeDeser,
            JsonDeserializer<?> valueDeser) {
        return new LinkedHashMultisetDeserializer(_containerType, typeDeser, valueDeser);
    }
}
