package com.starburstdata.docker.$internal.com.fasterxml.jackson.datatype.guava.deser.multimap.list;

import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.JsonDeserializer;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.KeyDeserializer;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.type.MapLikeType;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.datatype.guava.deser.multimap.GuavaMultimapDeserializer;
import com.starburstdata.docker.$internal.com.google.common.collect.LinkedListMultimap;

import java.lang.reflect.Method;

/**
 * Provides deserialization for the Guava LinkedListMultimap class.
 *
 * @author mvolkhart
 */
public class LinkedListMultimapDeserializer
    extends GuavaMultimapDeserializer<LinkedListMultimap<Object,Object>>
{
    public LinkedListMultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer,
            TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer) {
        super(type, keyDeserializer, elementTypeDeserializer, elementDeserializer);
    }

    public LinkedListMultimapDeserializer(MapLikeType type, KeyDeserializer keyDeserializer,
            TypeDeserializer elementTypeDeserializer, JsonDeserializer<?> elementDeserializer,
            Method creatorMethod) {
        super(type, keyDeserializer, elementTypeDeserializer, elementDeserializer, creatorMethod);
    }

    @Override
    protected LinkedListMultimap<Object, Object> createMultimap() {
        return LinkedListMultimap.create();
    }

    @Override
    protected JsonDeserializer<?> _createContextual(MapLikeType type,
            KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer,
            JsonDeserializer<?> elementDeserializer, Method method) {
        return new LinkedListMultimapDeserializer(type, keyDeserializer, typeDeserializer,
                elementDeserializer, method);
    }
}
