package com.starburstdata.docker.$internal.com.fasterxml.jackson.jaxrs.cfg;

import java.io.IOException;

import com.starburstdata.docker.$internal.javax.ws.rs.core.MultivaluedMap;

import com.starburstdata.docker.$internal.com.fasterxml.jackson.core.*;
import com.starburstdata.docker.$internal.com.fasterxml.jackson.databind.*;

/**
 * @since 2.3
 */
public abstract class ObjectWriterModifier
{
    /**
     * Method called to let modifier make any changes it wants to to objects
     * used for writing response for specified endpoint.
     * 
     * @param responseHeaders HTTP headers being returned with response (mutable)
     */
    public abstract ObjectWriter modify(EndpointConfigBase<?> endpoint,
            MultivaluedMap<String,Object> responseHeaders,
            Object valueToWrite, ObjectWriter w, JsonGenerator g)
        throws IOException;
}
