/*
 * Copyright (C) 2008-2010 Wayne Meissner
 *
 * This file is part of the JNR project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.starburstdata.docker.$internal.jnr.ffi.annotations;

import com.starburstdata.docker.$internal.jnr.ffi.LibraryLoader;
import com.starburstdata.docker.$internal.jnr.ffi.LibraryOption;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;

/**
 * Tags a library method as requiring any error codes as returned
 * by errno on unix, or GetLastError on windows be saved.
 *
 * @see IgnoreError
 * @see LibraryLoader#saveError(Map, boolean, boolean)
 */
@Retention(RetentionPolicy.RUNTIME)
public @interface SaveError {

}
