/*
 * Copyright (C) 2008-2010 Wayne Meissner
 *
 * This file is part of the JNR project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.starburstdata.docker.$internal.jnr.ffi.mapper;

import com.starburstdata.docker.$internal.jnr.ffi.Pointer;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public interface ToNativeConverter<J, N> {
    public N toNative(J value, ToNativeContext context);
    public Class<N> nativeType();

    /**
     * Used to reload a parameter converted to a native type via a custom {@link com.starburstdata.docker.$internal.jnr.ffi.mapper.ToNativeConverter}
     */
    public static interface PostInvocation<J,N> extends ToNativeConverter<J, N> {
        public void postInvoke(J j, N n, ToNativeContext context);
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target({ElementType.TYPE, ElementType.METHOD})
    public static @interface NoContext {
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.TYPE)
    public static @interface Cacheable {
    }

    @Retention(RetentionPolicy.RUNTIME)
    @Target(ElementType.METHOD)
    @interface ToNative {
        Class nativeType();
    }
}
