/*
 * Copyright (C) 2013 Wayne Meissner
 *
 * This file is part of the JNR project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.starburstdata.docker.$internal.jnr.ffi.provider;

import com.starburstdata.docker.$internal.jnr.ffi.NativeType;
import com.starburstdata.docker.$internal.jnr.ffi.mapper.FromNativeContext;
import com.starburstdata.docker.$internal.jnr.ffi.mapper.FromNativeConverter;

import java.lang.annotation.Annotation;
import java.util.Collection;

/**
 *
 */
public class FromNativeType extends SigType implements com.starburstdata.docker.$internal.jnr.ffi.mapper.FromNativeType {
    private final FromNativeConverter fromNativeConverter;
    private final FromNativeContext fromNativeContext;

    public FromNativeType(Class javaType, NativeType nativeType, Collection<Annotation> annotations,
                   FromNativeConverter fromNativeConverter, FromNativeContext fromNativeContext) {
        super(javaType, nativeType, annotations, fromNativeConverter != null ? fromNativeConverter.nativeType() : javaType);
        this.fromNativeConverter = fromNativeConverter;
        this.fromNativeContext = fromNativeContext;
    }

    @Override
    public FromNativeConverter getFromNativeConverter() {
        return fromNativeConverter;
    }

    public FromNativeContext getFromNativeContext() {
        return fromNativeContext;
    }
}
