package com.starburstdata.docker.$internal.jnr.posix;

import com.starburstdata.docker.$internal.jnr.constants.platform.Sysconf;
import com.starburstdata.docker.$internal.jnr.ffi.*;
import com.starburstdata.docker.$internal.jnr.ffi.mapper.FromNativeContext;


final class MacOSPOSIX extends BaseNativePOSIX {

    private final NSGetEnviron environ;

    MacOSPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);

        final LibraryLoader<NSGetEnviron> loader = LibraryLoader.create(NSGetEnviron.class);
        loader.library("libSystem.B.dylib");
        environ = loader.load();
    }

    public FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    public MsgHdr allocateMsgHdr() {
        return new MacOSMsgHdr(this);
    }

    public SocketMacros socketMacros() {
        return MacOSSocketMacros.INSTANCE;
    }

    public long sysconf(Sysconf name) {
        return libc().sysconf(name);
    }

    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer environ() {
        return environ._NSGetEnviron().getPointer(0);
    }

    public static final PointerConverter PASSWD = new PointerConverter() {
        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer) arg) : null;
        }
    };
}
