
package com.starburstdata.docker.$internal.org.glassfish.jersey.message.filtering.internal;

import com.starburstdata.docker.$internal.org.glassfish.jersey.internal.l10n.Localizable;
import com.starburstdata.docker.$internal.org.glassfish.jersey.internal.l10n.LocalizableMessageFactory;
import com.starburstdata.docker.$internal.org.glassfish.jersey.internal.l10n.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class LocalizationMessages {

    private final static LocalizableMessageFactory messageFactory = new LocalizableMessageFactory("com.starburstdata.docker.$internal.org.glassfish.jersey.message.filtering.internal.localization");
    private final static Localizer localizer = new Localizer();

    public static Localizable localizableMERGING_FILTERING_SCOPES() {
        return messageFactory.getMessage("merging.filtering.scopes");
    }

    /**
     * Merging two sets of entity-filtering scopes obtained from two different scope resolvers.
     * 
     */
    public static String MERGING_FILTERING_SCOPES() {
        return localizer.localize(localizableMERGING_FILTERING_SCOPES());
    }

    public static Localizable localizableENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(Object arg0) {
        return messageFactory.getMessage("entity.filtering.scope.not.annotations", arg0);
    }

    /**
     * The entity-filtering scope property does not contain an instance of Annotation or Annotation[] ({0}).
     * 
     */
    public static String ENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(Object arg0) {
        return localizer.localize(localizableENTITY_FILTERING_SCOPE_NOT_ANNOTATIONS(arg0));
    }

}
