/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Basic utility libraries and interfaces.
 *
 * <p>This package is a part of the open-source
 * <a href="http://guava-libraries.googlecode.com">Guava libraries</a>.
 *
 * <h2>Contents</h2>
 *
 * <h3>String-related utilities</h3>
 *
 * <ul>
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Ascii}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.CaseFormat}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.CharMatcher}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Charsets}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Joiner}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Splitter}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Strings}
 * </ul>
 *
 * <h3>Function types</h3>
 *
 * <ul>
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Function},
 *     {@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Functions}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Predicate},
 *     {@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Predicates}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Equivalence}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Converter}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Supplier},
 *     {@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Suppliers}
 * </ul>
 *
 * <h3>Other</h3>
 *
 * <ul>
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Defaults}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Enums}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Objects}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Optional}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Preconditions}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Stopwatch}
 * <li>{@link jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base.Throwables}
 * </ul>
 *
 */
@ParametersAreNonnullByDefault
package jersey.repackaged.com.starburstdata.docker.$internal.com.google.common.base;

import com.starburstdata.docker.$internal.javax.annotation.ParametersAreNonnullByDefault;
