/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client.messages.swarm;

import com.spotify.docker.client.messages.swarm.NodeSpec;
import com.starburstdata.docker.;
import com.starburstdata.docker.$internal.com.google.common.collect.ImmutableMap;
import java.util.Map;

final class AutoValue_NodeSpec
extends NodeSpec {
    private final String name;
    private final ImmutableMap<String, String> labels;
    private final String role;
    private final String availability;

    private AutoValue_NodeSpec(@.Nullable String name, @.Nullable ImmutableMap<String, String> labels, String role, String availability) {
        this.name = name;
        this.labels = labels;
        this.role = role;
        this.availability = availability;
    }

    @Override
    @.Nullable
    @.JsonProperty(value="Name")
    public String name() {
        return this.name;
    }

    @Override
    @.Nullable
    @.JsonProperty(value="Labels")
    public ImmutableMap<String, String> labels() {
        return this.labels;
    }

    @Override
    @.JsonProperty(value="Role")
    public String role() {
        return this.role;
    }

    @Override
    @.JsonProperty(value="Availability")
    public String availability() {
        return this.availability;
    }

    public String toString() {
        return "NodeSpec{name=" + this.name + ", labels=" + this.labels + ", role=" + this.role + ", availability=" + this.availability + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof NodeSpec) {
            NodeSpec that = (NodeSpec)o;
            return (this.name == null ? that.name() == null : this.name.equals(that.name())) && (this.labels == null ? that.labels() == null : this.labels.equals(that.labels())) && this.role.equals(that.role()) && this.availability.equals(that.availability());
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name == null ? 0 : this.name.hashCode();
        h *= 1000003;
        h ^= this.labels == null ? 0 : this.labels.hashCode();
        h *= 1000003;
        h ^= this.role.hashCode();
        h *= 1000003;
        return h ^= this.availability.hashCode();
    }

    static final class Builder
    extends NodeSpec.Builder {
        private String name;
        private ImmutableMap.Builder<String, String> labelsBuilder$;
        private ImmutableMap<String, String> labels;
        private String role;
        private String availability;

        Builder() {
            this.labels = ImmutableMap.of();
        }

        Builder(NodeSpec source) {
            this.name = source.name();
            this.labels = source.labels();
            this.role = source.role();
            this.availability = source.availability();
        }

        @Override
        public NodeSpec.Builder name(@.Nullable String name) {
            this.name = name;
            return this;
        }

        @Override
        public NodeSpec.Builder labels(@.Nullable Map<String, String> labels) {
            if (this.labelsBuilder$ != null) {
                throw new IllegalStateException("Cannot set labels after calling labelsBuilder()");
            }
            this.labels = labels == null ? null : ImmutableMap.copyOf(labels);
            return this;
        }

        @Override
        public ImmutableMap.Builder<String, String> labelsBuilder() {
            if (this.labelsBuilder$ == null) {
                this.labelsBuilder$ = ImmutableMap.builder();
                this.labelsBuilder$.putAll(this.labels);
                this.labels = null;
            }
            return this.labelsBuilder$;
        }

        @Override
        public NodeSpec.Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public NodeSpec.Builder availability(String availability) {
            this.availability = availability;
            return this;
        }

        @Override
        public NodeSpec build() {
            if (this.labelsBuilder$ != null) {
                this.labels = this.labelsBuilder$.build();
            }
            String missing = "";
            if (this.role == null) {
                missing = missing + " role";
            }
            if (this.availability == null) {
                missing = missing + " availability";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_NodeSpec(this.name, this.labels, this.role, this.availability);
        }
    }
}

