/*
 * Decompiled with CFR 0.152.
 */
package com.starburstdata.docker.$internal.org.glassfish.jersey.message.filtering;

import com.starburstdata.docker.$internal.javax.inject.Inject;
import com.starburstdata.docker.$internal.javax.inject.Singleton;
import com.starburstdata.docker.$internal.javax.ws.rs.ConstrainedTo;
import com.starburstdata.docker.$internal.javax.ws.rs.RuntimeType;
import com.starburstdata.docker.$internal.javax.ws.rs.core.Configuration;
import com.starburstdata.docker.$internal.javax.ws.rs.core.Context;
import com.starburstdata.docker.$internal.javax.ws.rs.core.SecurityContext;
import com.starburstdata.docker.$internal.org.glassfish.hk2.api.ServiceLocator;
import com.starburstdata.docker.$internal.org.glassfish.jersey.message.filtering.SecurityHelper;
import com.starburstdata.docker.$internal.org.glassfish.jersey.message.filtering.ServerScopeProvider;
import java.lang.annotation.Annotation;
import java.util.Set;
import jersey.repackaged.com.google.common.collect.Sets;

@Singleton
@ConstrainedTo(value=RuntimeType.SERVER)
final class SecurityServerScopeProvider
extends ServerScopeProvider {
    @Context
    private SecurityContext securityContext;

    @Inject
    public SecurityServerScopeProvider(Configuration config, ServiceLocator serviceLocator) {
        super(config, serviceLocator);
    }

    @Override
    public Set<String> getFilteringScopes(Annotation[] entityAnnotations, boolean defaultIfNotFound) {
        Set<String> filteringScope = super.getFilteringScopes(entityAnnotations, false);
        if (filteringScope.isEmpty()) {
            filteringScope = Sets.newHashSet();
            for (String role : SecurityHelper.getProcessedRoles()) {
                if (!this.securityContext.isUserInRole(role)) continue;
                filteringScope.add(SecurityHelper.getRolesAllowedScope(role));
            }
        }
        return this.returnFilteringScopes(filteringScope, defaultIfNotFound);
    }
}

