/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.connection;

import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class StarRocksJdbcConnectionOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String url;
    protected final String driverName;
    protected final String cjDriverName;
    @Nullable
    protected final String username;
    @Nullable
    protected final String password;

    public StarRocksJdbcConnectionOptions(String url, String username, String password) {
        this.url = (String)Preconditions.checkNotNull((Object)url, (String)"jdbc url is empty");
        this.driverName = "com.mysql.jdbc.Driver";
        this.cjDriverName = "com.mysql.cj.jdbc.Driver";
        this.username = username;
        this.password = password;
    }

    public String getDbURL() {
        return this.url;
    }

    public String getCjDriverName() {
        return this.cjDriverName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }
}

