/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.connection;

import com.starrocks.connector.flink.connection.StarRocksJdbcConnectionIProvider;
import com.starrocks.connector.flink.connection.StarRocksJdbcConnectionOptions;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarRocksJdbcConnectionProvider
implements StarRocksJdbcConnectionIProvider,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksJdbcConnectionProvider.class);
    private static final long serialVersionUID = 1L;
    private final StarRocksJdbcConnectionOptions jdbcOptions;
    private volatile transient Connection connection;

    public StarRocksJdbcConnectionProvider(StarRocksJdbcConnectionOptions jdbcOptions) {
        this.jdbcOptions = jdbcOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException, ClassNotFoundException {
        if (this.connection == null) {
            StarRocksJdbcConnectionProvider starRocksJdbcConnectionProvider = this;
            synchronized (starRocksJdbcConnectionProvider) {
                if (this.connection == null) {
                    try {
                        Class.forName(this.jdbcOptions.getCjDriverName());
                    }
                    catch (ClassNotFoundException ex) {
                        Class.forName(this.jdbcOptions.getDriverName());
                    }
                    this.connection = this.jdbcOptions.getUsername().isPresent() ? DriverManager.getConnection(this.jdbcOptions.getDbURL(), this.jdbcOptions.getUsername().orElse(null), this.jdbcOptions.getPassword().orElse(null)) : DriverManager.getConnection(this.jdbcOptions.getDbURL());
                }
            }
        }
        return this.connection;
    }

    @Override
    public Connection reestablishConnection() throws SQLException, ClassNotFoundException {
        this.close();
        this.connection = this.getConnection();
        return this.connection;
    }

    @Override
    public void close() {
        if (this.connection == null) {
            return;
        }
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            LOG.error("JDBC connection close failed.", (Throwable)e);
        }
        finally {
            this.connection = null;
        }
    }
}

