/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.row;

import com.starrocks.connector.flink.row.StarRocksIRowTransformer;
import com.starrocks.connector.flink.row.StarRocksSinkOP;
import com.starrocks.connector.flink.row.StarRocksSinkRowBuilder;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.RowData;

public class StarRocksGenericRowTransformer<T>
implements StarRocksIRowTransformer<T> {
    private static final long serialVersionUID = 1L;
    private StarRocksSinkRowBuilder<T> consumer;
    private String[] fieldNames;

    public StarRocksGenericRowTransformer(StarRocksSinkRowBuilder<T> consumer) {
        this.consumer = consumer;
    }

    @Override
    public void setTableSchema(TableSchema ts) {
        this.fieldNames = ts.getFieldNames();
    }

    @Override
    public void setRuntimeContext(RuntimeContext ctx) {
    }

    @Override
    public Object[] transform(T record, boolean supportUpsertDelete) {
        Object[] rowData = new Object[this.fieldNames.length + (supportUpsertDelete ? 1 : 0)];
        this.consumer.accept(rowData, record);
        if (supportUpsertDelete && record instanceof RowData) {
            rowData[rowData.length - 1] = StarRocksSinkOP.parse(((RowData)record).getRowKind()).ordinal();
        }
        return rowData;
    }
}

