/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.row;

import com.starrocks.connector.flink.row.StarRocksCsvSerializer;
import com.starrocks.connector.flink.row.StarRocksISerializer;
import com.starrocks.connector.flink.row.StarRocksJsonSerializer;
import com.starrocks.connector.flink.table.StarRocksSinkOptions;

public class StarRocksSerializerFactory {
    private StarRocksSerializerFactory() {
    }

    public static StarRocksISerializer createSerializer(StarRocksSinkOptions sinkOptions, String[] fieldNames) {
        if (StarRocksSinkOptions.StreamLoadFormat.CSV.equals((Object)sinkOptions.getStreamLoadFormat())) {
            return new StarRocksCsvSerializer(sinkOptions.getSinkStreamLoadProperties().get("column_separator"));
        }
        if (StarRocksSinkOptions.StreamLoadFormat.JSON.equals((Object)sinkOptions.getStreamLoadFormat())) {
            if (sinkOptions.supportUpsertDelete()) {
                String[] tmp = new String[fieldNames.length + 1];
                System.arraycopy(fieldNames, 0, tmp, 0, fieldNames.length);
                tmp[fieldNames.length] = "__op";
                fieldNames = tmp;
            }
            return new StarRocksJsonSerializer(fieldNames);
        }
        throw new RuntimeException("Failed to create row serializer, unsupported `format` from stream load properties.");
    }
}

