/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.table;

import com.starrocks.connector.flink.row.StarRocksTableRowTransformer;
import com.starrocks.connector.flink.table.StarRocksDynamicSinkFunction;
import com.starrocks.connector.flink.table.StarRocksSinkOptions;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;

public class StarRocksDynamicTableSink
implements DynamicTableSink {
    private transient TableSchema flinkSchema;
    private StarRocksSinkOptions sinkOptions;

    public StarRocksDynamicTableSink(StarRocksSinkOptions sinkOptions, TableSchema schema) {
        this.flinkSchema = schema;
        this.sinkOptions = sinkOptions;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return requestedMode;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        TypeInformation rowDataTypeInfo = context.createTypeInformation(this.flinkSchema.toRowDataType());
        StarRocksDynamicSinkFunction<RowData> starrocksSinkFunction = new StarRocksDynamicSinkFunction<RowData>(this.sinkOptions, this.flinkSchema, new StarRocksTableRowTransformer((TypeInformation<RowData>)rowDataTypeInfo));
        return SinkFunctionProvider.of(starrocksSinkFunction, (Integer)this.sinkOptions.getSinkParallelism());
    }

    public DynamicTableSink copy() {
        return new StarRocksDynamicTableSink(this.sinkOptions, this.flinkSchema);
    }

    public String asSummaryString() {
        return "starrocks_sink";
    }
}

