/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.table;

import com.starrocks.connector.flink.table.StarRocksSinkSemantic;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.factories.FactoryUtil;

public class StarRocksSinkOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long KILO_BYTES_SCALE = 1024L;
    private static final long MEGA_BYTES_SCALE = 0x100000L;
    private static final long GIGA_BYTES_SCALE = 0x40000000L;
    private static final String FORMAT_KEY = "format";
    public static final ConfigOption<String> JDBC_URL = ConfigOptions.key((String)"jdbc-url").stringType().noDefaultValue().withDescription("Host of the stream load like: `jdbc:mysql://fe_ip1:query_port,fe_ip2:query_port...`.");
    public static final ConfigOption<List<String>> LOAD_URL = ConfigOptions.key((String)"load-url").stringType().asList().noDefaultValue().withDescription("Host of the stream load like: `fe_ip1:http_port;fe_ip2:http_port;fe_ip3:http_port`.");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of the stream load.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of the stream load.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("StarRocks user name.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("StarRocks user password.");
    public static final ConfigOption<Integer> SINK_CONNECT_TIMEOUT = ConfigOptions.key((String)"sink.connect.timeout-ms").intType().defaultValue((Object)1000).withDescription("Timeout in millisecond for connecting to the `load-url`.");
    public static final ConfigOption<String> SINK_SEMANTIC = ConfigOptions.key((String)"sink.semantic").stringType().defaultValue((Object)StarRocksSinkSemantic.AT_LEAST_ONCE.getName()).withDescription("Fault tolerance guarantee. `at-least-once` or `exactly-once`");
    public static final ConfigOption<Long> SINK_BATCH_MAX_SIZE = ConfigOptions.key((String)"sink.buffer-flush.max-bytes").longType().defaultValue((Object)0x5A00000L).withDescription("Max data bytes of the flush.");
    public static final ConfigOption<Long> SINK_BATCH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").longType().defaultValue((Object)500000L).withDescription("Max row count of the flush.");
    public static final ConfigOption<Long> SINK_BATCH_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval-ms").longType().defaultValue((Object)300000L).withDescription("Flush interval of the row batch in millisecond.");
    public static final ConfigOption<Integer> SINK_MAX_RETRIES = ConfigOptions.key((String)"sink.max-retries").intType().defaultValue((Object)1).withDescription("Max flushing retry times of the row batch.");
    public static final ConfigOption<Long> SINK_BATCH_OFFER_TIMEOUT = ConfigOptions.key((String)"sink.buffer-flush.enqueue-timeout-ms").longType().defaultValue((Object)600000L).withDescription("Offer to flushQueue timeout in millisecond.");
    public static final ConfigOption<Integer> SINK_METRIC_HISTOGRAM_WINDOW_SIZE = ConfigOptions.key((String)"sink.metric.histogram-window-size").intType().defaultValue((Object)100).withDescription("Window size of histogram metrics.");
    public static final ConfigOption<Integer> SINK_PARALLELISM = FactoryUtil.SINK_PARALLELISM;
    private static final Set<String> SINK_SEMANTIC_ENUMS = Arrays.stream(StarRocksSinkSemantic.values()).map(s -> s.getName()).collect(Collectors.toSet());
    public static final String SINK_PROPERTIES_PREFIX = "sink.properties.";
    private final ReadableConfig tableOptions;
    private final Map<String, String> streamLoadProps = new HashMap<String, String>();
    private final Map<String, String> tableOptionsMap;
    private StarRocksSinkSemantic sinkSemantic;
    private boolean supportUpsertDelete;

    public StarRocksSinkOptions(ReadableConfig options, Map<String, String> optionsMap) {
        this.tableOptions = options;
        this.tableOptionsMap = optionsMap;
        this.parseSinkStreamLoadProperties();
        this.validate();
    }

    private void validate() {
        this.validateRequired();
        this.validateStreamLoadUrl();
        this.validateSinkSemantic();
        this.validateParamsRange();
    }

    public String getJdbcUrl() {
        return (String)this.tableOptions.get(JDBC_URL);
    }

    public String getDatabaseName() {
        return (String)this.tableOptions.get(DATABASE_NAME);
    }

    public String getTableName() {
        return (String)this.tableOptions.get(TABLE_NAME);
    }

    public String getUsername() {
        return (String)this.tableOptions.get(USERNAME);
    }

    public String getPassword() {
        return (String)this.tableOptions.get(PASSWORD);
    }

    public List<String> getLoadUrlList() {
        return this.tableOptions.getOptional(LOAD_URL).orElse(null);
    }

    public int getSinkMaxRetries() {
        return (Integer)this.tableOptions.get(SINK_MAX_RETRIES);
    }

    public long getSinkMaxFlushInterval() {
        return (Long)this.tableOptions.get(SINK_BATCH_FLUSH_INTERVAL);
    }

    public long getSinkMaxRows() {
        return (Long)this.tableOptions.get(SINK_BATCH_MAX_ROWS);
    }

    public long getSinkMaxBytes() {
        return (Long)this.tableOptions.get(SINK_BATCH_MAX_SIZE);
    }

    public int getConnectTimeout() {
        int connectTimeout = (Integer)this.tableOptions.get(SINK_CONNECT_TIMEOUT);
        if (connectTimeout < 100) {
            return 100;
        }
        if (connectTimeout > 60000) {
            return 60000;
        }
        return connectTimeout;
    }

    public long getSinkOfferTimeout() {
        return (Long)this.tableOptions.get(SINK_BATCH_OFFER_TIMEOUT);
    }

    public int getSinkHistogramWindowSize() {
        return (Integer)this.tableOptions.get(SINK_METRIC_HISTOGRAM_WINDOW_SIZE);
    }

    public Integer getSinkParallelism() {
        return this.tableOptions.getOptional(SINK_PARALLELISM).orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public StarRocksSinkSemantic getSemantic() {
        return this.sinkSemantic;
    }

    public Map<String, String> getSinkStreamLoadProperties() {
        return this.streamLoadProps;
    }

    public boolean hasColumnMappingProperty() {
        return this.streamLoadProps.containsKey("columns");
    }

    public StreamLoadFormat getStreamLoadFormat() {
        Map<String, String> loadProsp = this.getSinkStreamLoadProperties();
        String format = loadProsp.get(FORMAT_KEY);
        if (null != format && StreamLoadFormat.JSON.name().equalsIgnoreCase(format)) {
            return StreamLoadFormat.JSON;
        }
        return StreamLoadFormat.CSV;
    }

    public void enableUpsertDelete() {
        this.supportUpsertDelete = true;
    }

    public boolean supportUpsertDelete() {
        return this.supportUpsertDelete;
    }

    private void validateStreamLoadUrl() {
        this.tableOptions.getOptional(LOAD_URL).ifPresent(urlList -> {
            for (String host : urlList) {
                if (host.split(":").length >= 2) continue;
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'host_name:port'.", host, LOAD_URL.key()));
            }
        });
    }

    private void validateSinkSemantic() {
        this.tableOptions.getOptional(SINK_SEMANTIC).ifPresent(semantic -> {
            if (!SINK_SEMANTIC_ENUMS.contains(semantic)) {
                throw new ValidationException(String.format("Unsupported value '%s' for '%s'. Supported values are ['at-least-once', 'exactly-once'].", semantic, SINK_SEMANTIC.key()));
            }
        });
        this.sinkSemantic = StarRocksSinkSemantic.fromName((String)this.tableOptions.get(SINK_SEMANTIC));
    }

    private void validateParamsRange() {
        this.tableOptions.getOptional(SINK_MAX_RETRIES).ifPresent(val -> {
            if (val < 0 || val > 10) {
                throw new ValidationException(String.format("Unsupported value '%d' for '%s'. Supported value range: [0, 10].", val, SINK_MAX_RETRIES.key()));
            }
        });
        this.tableOptions.getOptional(SINK_BATCH_FLUSH_INTERVAL).ifPresent(val -> {
            if (val < 1000L || val > 3600000L) {
                throw new ValidationException(String.format("Unsupported value '%d' for '%s'. Supported value range: [1000, 3600000].", val, SINK_BATCH_FLUSH_INTERVAL.key()));
            }
        });
        this.tableOptions.getOptional(SINK_BATCH_MAX_ROWS).ifPresent(val -> {
            if (val < 64000L || val > 5000000L) {
                throw new ValidationException(String.format("Unsupported value '%d' for '%s'. Supported value range: [64000, 5000000].", val, SINK_BATCH_MAX_ROWS.key()));
            }
        });
        this.tableOptions.getOptional(SINK_BATCH_MAX_SIZE).ifPresent(val -> {
            if (val < 0x4000000L || val > 0x280000000L) {
                throw new ValidationException(String.format("Unsupported value '%d' for '%s'. Supported value range: [%d, %d].", val, SINK_BATCH_MAX_SIZE.key(), 0x4000000L, 0x280000000L));
            }
        });
        this.tableOptions.getOptional(SINK_BATCH_OFFER_TIMEOUT).ifPresent(val -> {
            if (val < 300000L || val > Long.MAX_VALUE) {
                throw new ValidationException(String.format("Unsupported value '%d' for '%s'. Supported value range: [300000, Long.MAX_VALUE].", val, SINK_BATCH_OFFER_TIMEOUT.key()));
            }
        });
    }

    private void validateRequired() {
        ConfigOption[] configOptions = new ConfigOption[]{USERNAME, PASSWORD, TABLE_NAME, DATABASE_NAME, JDBC_URL, LOAD_URL};
        int presentCount = 0;
        for (ConfigOption configOption : configOptions) {
            if (!this.tableOptions.getOptional(configOption).isPresent()) continue;
            ++presentCount;
        }
        CharSequence[] propertyNames = (String[])Arrays.stream(configOptions).map(ConfigOption::key).toArray(String[]::new);
        Preconditions.checkArgument((configOptions.length == presentCount || presentCount == 0 ? 1 : 0) != 0, (Object)("Either all or none of the following options should be provided:\n" + String.join((CharSequence)"\n", propertyNames)));
    }

    private void parseSinkStreamLoadProperties() {
        this.tableOptionsMap.keySet().stream().filter(key -> key.startsWith(SINK_PROPERTIES_PREFIX)).forEach(key -> {
            String value = this.tableOptionsMap.get(key);
            String subKey = key.substring(SINK_PROPERTIES_PREFIX.length()).toLowerCase();
            this.streamLoadProps.put(subKey, value);
        });
    }

    public static final class Builder {
        private final Configuration conf = new Configuration();

        public Builder withProperty(String key, String value) {
            this.conf.setString(key, value);
            return this;
        }

        public StarRocksSinkOptions build() {
            return new StarRocksSinkOptions((ReadableConfig)this.conf, this.conf.toMap());
        }
    }

    public static enum StreamLoadFormat {
        CSV,
        JSON;

    }
}

