/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.flink.tools;

import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.api.java.utils.MultipleParameterTool;
import org.apache.flink.calcite.shaded.com.google.common.base.Strings;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;

public class ExecuteSQL {
    public static void main(String[] args) throws Exception {
        String[] sqls;
        MultipleParameterTool params = MultipleParameterTool.fromArgs((String[])args);
        if (!params.has("f") || Strings.isNullOrEmpty((String)params.get("f"))) {
            throw new IllegalArgumentException("No sql file specified.");
        }
        EnvironmentSettings bsSettings = EnvironmentSettings.newInstance().useBlinkPlanner().inStreamingMode().build();
        TableEnvironment tEnv = TableEnvironment.create((EnvironmentSettings)bsSettings);
        ExecutionEnvironment env = ExecutionEnvironment.getExecutionEnvironment();
        for (String sql : sqls = (String.join((CharSequence)"\n", env.readTextFile(params.get("f")).collect()) + "\n").split(";\\s*\n")) {
            System.out.println(String.format("Executing SQL: \n%s\n", sql));
            tEnv.executeSql(sql);
        }
    }
}

