/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.shade.org.apache.http.impl.entity;

import com.starrocks.shade.org.apache.http.Header;
import com.starrocks.shade.org.apache.http.HttpEntity;
import com.starrocks.shade.org.apache.http.HttpException;
import com.starrocks.shade.org.apache.http.HttpMessage;
import com.starrocks.shade.org.apache.http.annotation.Contract;
import com.starrocks.shade.org.apache.http.annotation.ThreadingBehavior;
import com.starrocks.shade.org.apache.http.entity.BasicHttpEntity;
import com.starrocks.shade.org.apache.http.entity.ContentLengthStrategy;
import com.starrocks.shade.org.apache.http.impl.io.ChunkedInputStream;
import com.starrocks.shade.org.apache.http.impl.io.ContentLengthInputStream;
import com.starrocks.shade.org.apache.http.impl.io.IdentityInputStream;
import com.starrocks.shade.org.apache.http.io.SessionInputBuffer;
import com.starrocks.shade.org.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class EntityDeserializer {
    private final ContentLengthStrategy lenStrategy;

    public EntityDeserializer(ContentLengthStrategy lenStrategy) {
        this.lenStrategy = Args.notNull(lenStrategy, "Content length strategy");
    }

    protected BasicHttpEntity doDeserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Header contentEncodingHeader;
        BasicHttpEntity entity = new BasicHttpEntity();
        long len = this.lenStrategy.determineLength(message);
        if (len == -2L) {
            entity.setChunked(true);
            entity.setContentLength(-1L);
            entity.setContent(new ChunkedInputStream(inbuffer));
        } else if (len == -1L) {
            entity.setChunked(false);
            entity.setContentLength(-1L);
            entity.setContent(new IdentityInputStream(inbuffer));
        } else {
            entity.setChunked(false);
            entity.setContentLength(len);
            entity.setContent(new ContentLengthInputStream(inbuffer, len));
        }
        Header contentTypeHeader = message.getFirstHeader("Content-Type");
        if (contentTypeHeader != null) {
            entity.setContentType(contentTypeHeader);
        }
        if ((contentEncodingHeader = message.getFirstHeader("Content-Encoding")) != null) {
            entity.setContentEncoding(contentEncodingHeader);
        }
        return entity;
    }

    public HttpEntity deserialize(SessionInputBuffer inbuffer, HttpMessage message) throws HttpException, IOException {
        Args.notNull(inbuffer, "Session input buffer");
        Args.notNull(message, "HTTP message");
        return this.doDeserialize(inbuffer, message);
    }
}

